/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.geolatte.common.dataformats.json.jackson.GeometrySerializer;
import org.geolatte.common.dataformats.json.jackson.JsonMapper;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;

public class MultiPolygonSerializer
extends GeometrySerializer<MultiPolygon> {
    public MultiPolygonSerializer(JsonMapper containingTransformation) {
        super(containingTransformation);
    }

    @Override
    protected void writeShapeSpecificSerialization(MultiPolygon value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeFieldName("type");
        jgen.writeString("MultiPolygon");
        jgen.writeArrayFieldStart("coordinates");
        JsonSerializer<Object> ser = provider.findValueSerializer(Double.class, null);
        for (int i = 0; i < value.getNumGeometries(); ++i) {
            jgen.writeStartArray();
            Polygon currentPolygon = value.getGeometryN(i);
            LinearRing exterior = currentPolygon.getExteriorRing();
            jgen.writeStartArray();
            for (int j = 0; j < exterior.getNumPoints(); ++j) {
                Point point = exterior.getPointN(j);
                jgen.writeStartArray();
                ser.serialize(point.getX(), jgen, provider);
                ser.serialize(point.getY(), jgen, provider);
                jgen.writeEndArray();
            }
            jgen.writeEndArray();
            for (int k = 0; k < currentPolygon.getNumInteriorRing(); ++k) {
                LinearRing ml = currentPolygon.getInteriorRingN(k);
                jgen.writeStartArray();
                for (int j = 0; j < ml.getNumPoints(); ++j) {
                    Point point = ml.getPointN(j);
                    jgen.writeStartArray();
                    ser.serialize(point.getX(), jgen, provider);
                    ser.serialize(point.getY(), jgen, provider);
                    jgen.writeEndArray();
                }
                jgen.writeEndArray();
            }
            jgen.writeEndArray();
        }
        jgen.writeEndArray();
    }
}

