/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.geolatte.common.dataformats.json.jackson.GeometrySerializer;
import org.geolatte.common.dataformats.json.jackson.JsonMapper;
import org.geolatte.geom.LineString;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.Point;

public class MultiLineStringSerializer
extends GeometrySerializer<MultiLineString> {
    public MultiLineStringSerializer(JsonMapper containingTransformation) {
        super(containingTransformation);
    }

    @Override
    public void writeShapeSpecificSerialization(MultiLineString value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeFieldName("type");
        jgen.writeString("MultiLineString");
        jgen.writeArrayFieldStart("coordinates");
        JsonSerializer<Object> ser = provider.findValueSerializer(Double.class, null);
        for (int i = 0; i < value.getNumGeometries(); ++i) {
            LineString ml = value.getGeometryN(i);
            jgen.writeStartArray();
            for (int j = 0; j < ml.getNumPoints(); ++j) {
                Point point = ml.getPointN(j);
                jgen.writeStartArray();
                ser.serialize(point.getX(), jgen, provider);
                ser.serialize(point.getY(), jgen, provider);
                jgen.writeEndArray();
            }
            jgen.writeEndArray();
        }
        jgen.writeEndArray();
    }
}

