/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.geolatte.common.Feature;
import org.geolatte.common.FeatureCollection;
import org.geolatte.common.dataformats.json.jackson.AnyGeometrySerializer;
import org.geolatte.common.dataformats.json.jackson.FeatureCollectionDeserializer;
import org.geolatte.common.dataformats.json.jackson.FeatureDeserializer;
import org.geolatte.common.dataformats.json.jackson.FeatureSerializer;
import org.geolatte.common.dataformats.json.jackson.GeometryCollectionSerializer;
import org.geolatte.common.dataformats.json.jackson.GeometryDeserializer;
import org.geolatte.common.dataformats.json.jackson.JsonException;
import org.geolatte.common.dataformats.json.jackson.LineStringSerializer;
import org.geolatte.common.dataformats.json.jackson.MultiLineStringSerializer;
import org.geolatte.common.dataformats.json.jackson.MultiPointSerializer;
import org.geolatte.common.dataformats.json.jackson.MultiPolygonSerializer;
import org.geolatte.common.dataformats.json.jackson.PointSerializer;
import org.geolatte.common.dataformats.json.jackson.PolygonSerializer;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.crs.CrsId;

public class JsonMapper {
    private static final CrsId WGS84 = CrsId.valueOf(4326);
    public static final int MAXIMUMDEPTH = 10;
    private ObjectMapper mapper;
    private int depth;
    private CrsId defaultCrsId;
    private boolean insideGeometryCollection;
    private boolean serializeNullValues;
    private boolean ignoreUnknownProperties;

    public JsonMapper(CrsId defaultCrsId, boolean serializeNullValues, boolean ignoreUnknownProperties) {
        this.defaultCrsId = defaultCrsId;
        this.serializeNullValues = serializeNullValues;
        this.ignoreUnknownProperties = ignoreUnknownProperties;
        this.setNewObjectMapper();
        SimpleModule mod = new SimpleModule("GeolatteCommonModule");
        mod.addSerializer(MultiLineString.class, new MultiLineStringSerializer(this));
        mod.addSerializer(LineString.class, new LineStringSerializer(this));
        mod.addSerializer(Point.class, new PointSerializer(this));
        mod.addSerializer(MultiPoint.class, new MultiPointSerializer(this));
        mod.addSerializer(Polygon.class, new PolygonSerializer(this));
        mod.addSerializer(Feature.class, new FeatureSerializer(this));
        mod.addSerializer(MultiPolygon.class, new MultiPolygonSerializer(this));
        mod.addSerializer(Geometry.class, new AnyGeometrySerializer());
        mod.addSerializer(GeometryCollection.class, new GeometryCollectionSerializer(this));
        mod.addDeserializer(Geometry.class, new GeometryDeserializer<Geometry>(this, Geometry.class));
        mod.addDeserializer(Point.class, new GeometryDeserializer<Point>(this, Point.class));
        mod.addDeserializer(LineString.class, new GeometryDeserializer<LineString>(this, LineString.class));
        mod.addDeserializer(MultiPoint.class, new GeometryDeserializer<MultiPoint>(this, MultiPoint.class));
        mod.addDeserializer(MultiLineString.class, new GeometryDeserializer<MultiLineString>(this, MultiLineString.class));
        mod.addDeserializer(Polygon.class, new GeometryDeserializer<Polygon>(this, Polygon.class));
        mod.addDeserializer(MultiPolygon.class, new GeometryDeserializer<MultiPolygon>(this, MultiPolygon.class));
        mod.addDeserializer(GeometryCollection.class, new GeometryDeserializer<GeometryCollection>(this, GeometryCollection.class));
        mod.addDeserializer(Feature.class, new FeatureDeserializer(this));
        mod.addDeserializer(FeatureCollection.class, new FeatureCollectionDeserializer(this));
        this.mapper.registerModule(mod);
    }

    public JsonMapper(boolean serializeNullValues, boolean ignoreUnknownProperties) {
        this(WGS84, serializeNullValues, ignoreUnknownProperties);
    }

    public JsonMapper() {
        this(WGS84, true, false);
    }

    public synchronized String toJson(Object input) throws JsonException {
        try {
            return this.recurse(input);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public synchronized <T> T fromJson(String jsonString, Class<T> clazz) throws JsonException {
        if (jsonString == null) {
            return null;
        }
        StringReader reader = new StringReader(jsonString);
        try {
            return this.mapper.readValue((Reader)reader, clazz);
        }
        catch (JsonParseException e) {
            throw new JsonException(e.getMessage(), e);
        }
        catch (JsonMappingException e) {
            throw new JsonException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    public <T> List<T> collectionFromJson(String json, Class<T> clazz) throws JsonException {
        if (json == null) {
            return null;
        }
        try {
            ArrayList<T> result = new ArrayList<T>();
            List tempParseResult = (List)this.mapper.readValue(json, new TypeReference<List<T>>(){});
            for (Object temp : tempParseResult) {
                result.add(this.fromJson(this.toJson(temp), clazz));
            }
            return result;
        }
        catch (JsonParseException e) {
            throw new JsonException(e.getMessage(), e);
        }
        catch (JsonMappingException e) {
            throw new JsonException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    int getDepth() {
        return this.depth;
    }

    protected String recurse(Object input) throws IOException {
        this.increaseDepth();
        if (this.depth > 10) {
            this.decreaseDepth();
            return "{ \"error\": \"maximum serialization-depth reached.\" }";
        }
        StringWriter writer = new StringWriter();
        this.mapper.writeValue(writer, input);
        writer.close();
        this.decreaseDepth();
        return writer.getBuffer().toString();
    }

    public <T> void addClassSerializer(Class<? extends T> classToMap, JsonSerializer<T> classSerializer) {
        this.setNewObjectMapper();
        SimpleModule mod = new SimpleModule("GeolatteCommonModule-" + classSerializer.getClass().getSimpleName());
        mod.addSerializer(classToMap, classSerializer);
        this.mapper.registerModule(mod);
    }

    public <T> void addClassDeserializer(Class<T> classToMap, JsonDeserializer<? extends T> classDeserializer) {
        this.setNewObjectMapper();
        SimpleModule mod = new SimpleModule("GeolatteCommonModule-" + classDeserializer.getClass().getSimpleName());
        mod.addDeserializer(classToMap, classDeserializer);
        this.mapper.registerModule(mod);
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public CrsId getDefaultCrsId() {
        return this.defaultCrsId;
    }

    void increaseDepth() {
        ++this.depth;
    }

    void decreaseDepth() {
        --this.depth;
    }

    boolean insideGeometryCollection() {
        return this.insideGeometryCollection;
    }

    void moveInsideGeometryCollection() {
        this.insideGeometryCollection = true;
    }

    void moveOutsideGeometryCollection() {
        this.insideGeometryCollection = false;
    }

    private void setNewObjectMapper() {
        this.mapper = new ObjectMapper();
        if (!this.serializeNullValues) {
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            if (this.ignoreUnknownProperties) {
                this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            }
        }
    }
}

