/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.geolatte.common.dataformats.json.jackson.JsonMapper;
import org.geolatte.geom.Envelope;
import org.geolatte.geom.Geometry;

public abstract class GeometrySerializer<T extends Geometry>
extends JsonSerializer<T> {
    protected JsonMapper parent;

    public GeometrySerializer(JsonMapper containingTransformation) {
        this.parent = containingTransformation;
    }

    protected JsonMapper getParent() {
        return this.parent;
    }

    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (!this.parent.insideGeometryCollection()) {
            this.writeCrs(jgen, (Geometry)value);
            this.writeBbox(jgen, value, provider);
        }
        this.writeShapeSpecificSerialization(value, jgen, provider);
        jgen.writeEndObject();
    }

    protected abstract void writeShapeSpecificSerialization(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

    protected double[] getBboxCoordinates(JsonGenerator jgen, T shape, SerializerProvider provider) throws JsonMappingException {
        return this.envelopeToCoordinates(((Geometry)shape).getEnvelope());
    }

    protected void writeCrs(JsonGenerator jgen, Geometry shape) throws IOException {
        if (shape.getSRID() > 0) {
            jgen.writeFieldName("crs");
            jgen.writeStartObject();
            jgen.writeStringField("type", "name");
            jgen.writeFieldName("properties");
            jgen.writeStartObject();
            jgen.writeStringField("name", "EPSG:" + shape.getSRID());
            jgen.writeEndObject();
            jgen.writeEndObject();
        }
    }

    protected void writeBbox(JsonGenerator jgen, T shape, SerializerProvider provider) throws IOException {
        double[] coordinates = this.getBboxCoordinates(jgen, shape, provider);
        if (coordinates != null) {
            jgen.writeFieldName("bbox");
            jgen.writeObject(coordinates);
        }
    }

    protected double[] envelopeToCoordinates(Envelope e) {
        return new double[]{e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY()};
    }
}

