/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import java.io.IOException;
import java.util.HashMap;
import org.geolatte.common.Feature;
import org.geolatte.common.dataformats.json.jackson.GeometrySerializer;
import org.geolatte.common.dataformats.json.jackson.JsonMapper;
import org.geolatte.common.reflection.EntityClassReader;
import org.geolatte.common.reflection.InvalidObjectReaderException;
import org.geolatte.geom.Geometry;

public class FeatureSerializer
extends JsonSerializer<Feature> {
    JsonMapper parent;

    public FeatureSerializer(JsonMapper jsonTransformation) {
        this.parent = jsonTransformation;
    }

    @Override
    public void serialize(Feature value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("type", "Feature");
        if (value != null) {
            Geometry geom = value.getGeometry();
            if (geom == null) {
                jgen.writeNullField("geometry");
            } else {
                JsonSerializer<Object> ser = provider.findValueSerializer(geom.getClass(), null);
                if (ser != null && ser instanceof GeometrySerializer) {
                    this.parent.increaseDepth();
                    jgen.writeFieldName("geometry");
                    ser.serialize(geom, jgen, provider);
                    this.parent.decreaseDepth();
                }
            }
            Object id = value.getId();
            if (id != null) {
                jgen.writeObjectField("id", id);
            }
            jgen.writeFieldName("properties");
            jgen.writeStartObject();
            for (String propertyName : value.getProperties()) {
                Object propertyContents = value.getProperty(propertyName);
                if (propertyContents == null) continue;
                try {
                    JsonSerializer<Object> ser = provider.findValueSerializer(propertyContents.getClass(), null);
                    if (ser == null) continue;
                    if (ser instanceof BeanSerializer) {
                        String subPart = this.parent.recurse(EntityClassReader.getClassReaderFor(propertyContents.getClass()).asFeature(propertyContents));
                        try {
                            HashMap subPartMap = this.parent.getObjectMapper().readValue(subPart, HashMap.class);
                            jgen.writeFieldName(propertyName);
                            jgen.writeObject(subPartMap);
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                    jgen.writeFieldName(propertyName);
                    ser.serialize(propertyContents, jgen, provider);
                }
                catch (JsonMappingException exc) {
                    jgen.writeStartObject();
                    jgen.writeEndObject();
                }
                catch (InvalidObjectReaderException invalidObjectReaderException) {}
            }
            jgen.writeEndObject();
        }
        jgen.writeEndObject();
    }
}

