/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.List;
import org.geolatte.common.Feature;
import org.geolatte.common.FeatureCollection;
import org.geolatte.common.dataformats.json.jackson.DefaultFeatureCollection;
import org.geolatte.common.dataformats.json.jackson.GeoJsonDeserializer;
import org.geolatte.common.dataformats.json.jackson.JsonException;
import org.geolatte.common.dataformats.json.jackson.JsonMapper;

public class FeatureCollectionDeserializer
extends GeoJsonDeserializer<FeatureCollection> {
    public FeatureCollectionDeserializer(JsonMapper owner) {
        super(owner, FeatureCollection.class);
    }

    @Override
    protected FeatureCollection deserialize(JsonParser jsonParser) throws IOException {
        int sridToUse;
        Integer srid = this.getSrid();
        String type = this.getStringParam("type", "Invalid Feature, type property required.");
        int n = sridToUse = srid == null ? 5 : srid;
        if ("FeatureCollection".equals(type)) {
            try {
                List<Feature> features = this.parent.collectionFromJson(this.getSubJson("features", "A geometry field is required for a Feature"), Feature.class);
                return new DefaultFeatureCollection(features);
            }
            catch (JsonException e) {
                throw new IOException("Problem deserializing individual features in collection", e);
            }
        }
        throw new IOException("For a featurecollection, the type property must equal 'FeatureCollection'");
    }
}

