/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.geolatte.common.dataformats.json.jackson.JsonException;
import org.geolatte.common.dataformats.json.jackson.JsonMapper;

public abstract class AbstractJsonDeserializer<T>
extends JsonDeserializer<T> {
    protected JsonMapper parent;
    private static final ThreadLocal inputParams = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return null;
        }
    };

    public AbstractJsonDeserializer(JsonMapper owner) {
        this.parent = owner;
    }

    @Override
    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Map originalParams = (Map)inputParams.get();
        try {
            Map newValue = (Map)jp.readValueAs(Object.class);
            inputParams.set(newValue);
        }
        catch (ClassCastException exc) {
            throw new IOException("Expected a JSON Object, but this was not the case. ", exc);
        }
        T answer = this.deserialize(jp);
        inputParams.set(originalParams);
        return answer;
    }

    protected abstract T deserialize(JsonParser var1) throws IOException;

    protected String getStringParam(String paramName, String errorMessage, Map<String, Object> mapToUse) throws IOException {
        return this.getTypedParam(paramName, errorMessage, String.class, mapToUse);
    }

    protected String getStringParam(String paramName, String errorMessage) throws IOException {
        return this.getStringParam(paramName, errorMessage, (Map)inputParams.get());
    }

    public String getSubJson(String paramName, String errorMessage, Map<String, Object> mapToUse) throws IOException {
        Object o = mapToUse.get(paramName);
        if (o != null) {
            try {
                return this.parent.toJson(o);
            }
            catch (JsonException e) {
                throw new IOException(errorMessage, e);
            }
        }
        if (errorMessage != null) {
            throw new IOException(errorMessage);
        }
        return null;
    }

    public String getSubJson(String paramName, String errorMessage) throws IOException {
        return this.getSubJson(paramName, errorMessage, (Map)inputParams.get());
    }

    protected Double getDoubleParam(String paramName, String errorMessage) throws IOException {
        return this.getDoubleParam(paramName, errorMessage, (Map)inputParams.get());
    }

    protected Double getDoubleParam(String paramName, String errorMessage, Map<String, Object> mapToUse) throws IOException {
        Object o = mapToUse.get(paramName);
        if (o != null) {
            try {
                return Double.parseDouble(o.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.getTypedParam(paramName, errorMessage, Double.class, mapToUse);
    }

    protected Integer getIntParam(String paramName, String errorMessage, Map<String, Object> mapToUse) throws IOException {
        Object o = mapToUse.get(paramName);
        if (o != null) {
            try {
                return Integer.parseInt(o.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.getTypedParam(paramName, errorMessage, Integer.class, mapToUse);
    }

    protected Integer getIntParam(String paramName, String errorMessage) throws IOException {
        return this.getIntParam(paramName, errorMessage, (Map)inputParams.get());
    }

    protected Boolean getBooleanParam(String paramName, String errorMessage, Map<String, Object> mapToUse) throws IOException {
        String s2;
        Boolean result = this.getTypedParam(paramName, errorMessage, Boolean.class, mapToUse);
        if (result == null && (s2 = this.getTypedParam(paramName, errorMessage, String.class, mapToUse)) != null) {
            return Boolean.parseBoolean(s2);
        }
        return result;
    }

    protected Boolean getBooleanParam(String paramName, String errorMessage) throws IOException {
        return this.getBooleanParam(paramName, errorMessage, (Map)inputParams.get());
    }

    protected <A> A getTypedParam(String paramName, String errorMessage, Class<A> clazz, Map<String, Object> mapToUse) throws IOException {
        Object o = mapToUse.get(paramName);
        if (o != null && clazz.isAssignableFrom(o.getClass())) {
            return (A)o;
        }
        if (errorMessage != null) {
            throw new IOException(errorMessage);
        }
        return null;
    }

    protected <A> A getTypedParam(String paramName, String errorMessage, Class<A> clazz) throws IOException {
        return this.getTypedParam(paramName, errorMessage, clazz, (Map)inputParams.get());
    }

    public Double parseDefault(String input, Double defaultValue) {
        if (input == null) {
            return defaultValue;
        }
        Double answer = defaultValue;
        try {
            answer = Double.parseDouble(input);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return answer;
    }

    public Integer parseDefault(String input, Integer defaultValue) {
        if (input == null) {
            return defaultValue;
        }
        Integer answer = defaultValue;
        try {
            answer = Integer.parseInt(input);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return answer;
    }

    protected Date getDateParam(String paramName, String errorMessage, Map<String, Object> mapToUse) throws IOException {
        String dateInString = this.getStringParam(paramName, errorMessage, mapToUse);
        if (dateInString == null) {
            if (errorMessage == null) {
                return null;
            }
            throw new IOException(errorMessage);
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            return formatter.parse(dateInString);
        }
        catch (ParseException ignored) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            try {
                return formatter.parse(dateInString);
            }
            catch (ParseException e) {
                if (errorMessage == null) {
                    return null;
                }
                throw new IOException(errorMessage, e);
            }
        }
    }

    protected Date getDateParam(String paramName, String errorMessage) throws IOException {
        return this.getDateParam(paramName, errorMessage, (Map)inputParams.get());
    }
}

