/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.csv;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.geolatte.common.reflection.EntityClassReader;
import org.geolatte.common.reflection.InvalidObjectReaderException;
import org.geolatte.common.transformer.Transformation;
import org.geolatte.common.transformer.TransformationException;
import org.geolatte.geom.Geometry;

public class CsvSerializationTransformation<T>
implements Transformation<T, String> {
    private char separator;
    private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private Class<? extends T> entityClass;
    private EntityClassReader reader;
    private List<String> columnList;

    public CsvSerializationTransformation(Class<? extends T> objectClass, char csvChar) {
        this.separator = csvChar;
        this.entityClass = objectClass;
        this.reader = EntityClassReader.getClassReaderFor(objectClass);
        this.columnList = new ArrayList<String>();
    }

    public CsvSerializationTransformation(Class<? extends T> objectClass, char csvChar, List<String> columnList) {
        this.separator = csvChar;
        this.entityClass = objectClass;
        this.reader = EntityClassReader.getClassReaderFor(objectClass);
        this.columnList = columnList == null ? new ArrayList() : columnList;
    }

    public void setDateFormatter(DateFormat formatterToUse) {
        this.formatter = formatterToUse;
    }

    public String getHeader() {
        StringBuilder sb = new StringBuilder();
        if (this.columnList.size() > 0) {
            for (String s2 : this.columnList) {
                sb.append(s2);
                sb.append(this.separator);
            }
        } else {
            if (this.reader.getIdName() != null) {
                sb.append(this.reader.getIdName());
                sb.append(this.separator);
            }
            for (String name : this.reader.getProperties()) {
                sb.append(name);
                sb.append(this.separator);
            }
            if (this.reader.getGeometryName() != null) {
                sb.append(this.reader.getGeometryName());
                sb.append(this.separator);
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public String transform(T input) throws TransformationException {
        if (input.getClass() != this.entityClass) {
            throw new TransformationException((Object)"Object not of correct type");
        }
        try {
            StringBuilder sb = new StringBuilder();
            if (this.columnList.size() > 0) {
                for (String column : this.columnList) {
                    if (column.equalsIgnoreCase(this.reader.getIdName())) {
                        Object id = this.reader.getId(input);
                        sb.append(id == null ? "" : id);
                        sb.append(this.separator);
                        continue;
                    }
                    if (column.equalsIgnoreCase(this.reader.getGeometryName())) {
                        Geometry geom = this.reader.getGeometry(input);
                        sb.append(geom == null ? "" : geom.asText());
                        sb.append(this.separator);
                        continue;
                    }
                    Object value = this.reader.getPropertyValue(input, column);
                    Object object = value = null == value ? "" : value;
                    if (value instanceof Date) {
                        sb.append(this.formatter.format((Date)value));
                    } else {
                        sb.append(value);
                    }
                    sb.append(this.separator);
                }
            } else {
                if (this.reader.getIdName() != null) {
                    Iterator<String> id = this.reader.getId(input);
                    sb.append(id == null ? "" : id);
                    sb.append(this.separator);
                }
                for (String name : this.reader.getProperties()) {
                    Object value = this.reader.getPropertyValue(input, name);
                    Object object = value = null == value ? "" : value;
                    if (value instanceof Date) {
                        sb.append(this.formatter.format((Date)value));
                    } else {
                        sb.append(value);
                    }
                    sb.append(this.separator);
                }
                if (this.reader.getGeometryName() != null) {
                    Geometry geom = this.reader.getGeometry(input);
                    sb.append(geom == null ? "" : geom.asText());
                    sb.append(this.separator);
                }
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        catch (InvalidObjectReaderException e) {
            throw new TransformationException("Object not of correct type.", (Object)e);
        }
    }
}

