/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.cql.lexer;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PushbackReader;
import org.geolatte.common.cql.lexer.LexerException;
import org.geolatte.common.cql.node.EOF;
import org.geolatte.common.cql.node.TBlank;
import org.geolatte.common.cql.node.TBooleanAndOperator;
import org.geolatte.common.cql.node.TBooleanFalse;
import org.geolatte.common.cql.node.TBooleanNotOperator;
import org.geolatte.common.cql.node.TBooleanOrOperator;
import org.geolatte.common.cql.node.TBooleanTrue;
import org.geolatte.common.cql.node.TBooleanUnknown;
import org.geolatte.common.cql.node.TCharacterStringLiteral;
import org.geolatte.common.cql.node.TColon;
import org.geolatte.common.cql.node.TComma;
import org.geolatte.common.cql.node.TDatetime;
import org.geolatte.common.cql.node.TDoesnotexistOperator;
import org.geolatte.common.cql.node.TDurDaySymbol;
import org.geolatte.common.cql.node.TDurHourSymbol;
import org.geolatte.common.cql.node.TDurMinuteSymbol;
import org.geolatte.common.cql.node.TDurMonthSymbol;
import org.geolatte.common.cql.node.TDurSecondSymbol;
import org.geolatte.common.cql.node.TDurYearSymbol;
import org.geolatte.common.cql.node.TDurationDateTimeSeparator;
import org.geolatte.common.cql.node.TDurationSymbol;
import org.geolatte.common.cql.node.TEqualsOperator;
import org.geolatte.common.cql.node.TExistsOperator;
import org.geolatte.common.cql.node.TGeoContainsOperator;
import org.geolatte.common.cql.node.TGeoCrossesOperator;
import org.geolatte.common.cql.node.TGeoDisjointOperator;
import org.geolatte.common.cql.node.TGeoEqualsOperator;
import org.geolatte.common.cql.node.TGeoIntersectsOperator;
import org.geolatte.common.cql.node.TGeoOverlapsOperator;
import org.geolatte.common.cql.node.TGeoRelateOperator;
import org.geolatte.common.cql.node.TGeoTouchesOperator;
import org.geolatte.common.cql.node.TGeoWithinOperator;
import org.geolatte.common.cql.node.TGreaterThanOperator;
import org.geolatte.common.cql.node.TGreaterThanOrEqualsOperator;
import org.geolatte.common.cql.node.TIdentifier;
import org.geolatte.common.cql.node.TLeftParen;
import org.geolatte.common.cql.node.TLessThanOperator;
import org.geolatte.common.cql.node.TLessThanOrEqualsOperator;
import org.geolatte.common.cql.node.TNewline;
import org.geolatte.common.cql.node.TNotEqualsOperator;
import org.geolatte.common.cql.node.TNullConstant;
import org.geolatte.common.cql.node.TNullIsOperator;
import org.geolatte.common.cql.node.TNullNotOperator;
import org.geolatte.common.cql.node.TPeriod;
import org.geolatte.common.cql.node.TRelgeoBeyondOperator;
import org.geolatte.common.cql.node.TRelgeoDwithinOperator;
import org.geolatte.common.cql.node.TRightParen;
import org.geolatte.common.cql.node.TSign;
import org.geolatte.common.cql.node.TSignedNumericLiteral;
import org.geolatte.common.cql.node.TSpace;
import org.geolatte.common.cql.node.TTemporalAfterOperator;
import org.geolatte.common.cql.node.TTemporalBeforeOperator;
import org.geolatte.common.cql.node.TTemporalBeforeorduringOperator;
import org.geolatte.common.cql.node.TTemporalDuringOperator;
import org.geolatte.common.cql.node.TTemporalDuringorafterOperator;
import org.geolatte.common.cql.node.TTextIlikeOperator;
import org.geolatte.common.cql.node.TTextLikeOperator;
import org.geolatte.common.cql.node.TTimeSpanSeparator;
import org.geolatte.common.cql.node.TUnsignedInteger;
import org.geolatte.common.cql.node.TWktEmptySetLiteral;
import org.geolatte.common.cql.node.TWktGeometryCollectionLiteral;
import org.geolatte.common.cql.node.TWktLineStringLiteral;
import org.geolatte.common.cql.node.TWktMultiLineStringLiteral;
import org.geolatte.common.cql.node.TWktMultiPointLiteral;
import org.geolatte.common.cql.node.TWktMultiPolygonLiteral;
import org.geolatte.common.cql.node.TWktPointLiteral;
import org.geolatte.common.cql.node.TWktPolygonLiteral;
import org.geolatte.common.cql.node.Token;

public class Lexer {
    protected Token token;
    protected State state = State.NORMAL;
    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    private static int[][][][] gotoTable;
    private static int[][] accept;

    protected void filter() throws LexerException, IOException {
    }

    public Lexer(PushbackReader in) {
        this.in = in;
    }

    public Token peek() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        return this.token;
    }

    public Token next() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException {
        int dfa_state = 0;
        int start_pos = this.pos;
        int start_line = this.line;
        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;
        int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
        int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);
        while (true) {
            int c;
            if ((c = this.getChar()) != -1) {
                switch (c) {
                    case 10: {
                        if (this.cr) {
                            this.cr = false;
                            break;
                        }
                        ++this.line;
                        this.pos = 0;
                        break;
                    }
                    case 13: {
                        ++this.line;
                        this.pos = 0;
                        this.cr = true;
                        break;
                    }
                    default: {
                        ++this.pos;
                        this.cr = false;
                    }
                }
                this.text.append((char)c);
                block246: do {
                    int oldState = dfa_state < -1 ? -2 - dfa_state : dfa_state;
                    dfa_state = -1;
                    int[][] tmp1 = gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;
                    while (low <= high) {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];
                        if (c < tmp2[0]) {
                            high = middle - 1;
                            continue;
                        }
                        if (c > tmp2[1]) {
                            low = middle + 1;
                            continue;
                        }
                        dfa_state = tmp2[2];
                        continue block246;
                    }
                } while (dfa_state < -1);
            } else {
                dfa_state = -1;
            }
            if (dfa_state >= 0) {
                if (accept[dfa_state] == -1) continue;
                accept_state = dfa_state;
                accept_token = accept[dfa_state];
                accept_length = this.text.length();
                accept_pos = this.pos;
                accept_line = this.line;
                continue;
            }
            if (accept_state == -1) break;
            switch (accept_token) {
                case 0: {
                    Token token = this.new0(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.WKT;
                            break;
                        }
                        case 1: {
                            this.state = State.WKT;
                        }
                    }
                    return token;
                }
                case 1: {
                    Token token = this.new1(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.WKT;
                            break;
                        }
                        case 1: {
                            this.state = State.WKT;
                        }
                    }
                    return token;
                }
                case 2: {
                    Token token = this.new2(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.WKT;
                            break;
                        }
                        case 1: {
                            this.state = State.WKT;
                        }
                    }
                    return token;
                }
                case 3: {
                    Token token = this.new3(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.WKT;
                            break;
                        }
                        case 1: {
                            this.state = State.WKT;
                        }
                    }
                    return token;
                }
                case 4: {
                    Token token = this.new4(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.WKT;
                            break;
                        }
                        case 1: {
                            this.state = State.WKT;
                        }
                    }
                    return token;
                }
                case 5: {
                    Token token = this.new5(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.WKT;
                            break;
                        }
                        case 1: {
                            this.state = State.WKT;
                        }
                    }
                    return token;
                }
                case 6: {
                    Token token = this.new6(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.WKT;
                            break;
                        }
                        case 1: {
                            this.state = State.WKT;
                        }
                    }
                    return token;
                }
                case 7: {
                    Token token = this.new7(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.WKT;
                            break;
                        }
                        case 1: {
                            this.state = State.WKT;
                        }
                    }
                    return token;
                }
                case 8: {
                    Token token = this.new8(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 9: {
                    Token token = this.new9(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 10: {
                    Token token = this.new10(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 11: {
                    Token token = this.new11(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 12: {
                    Token token = this.new12(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 13: {
                    Token token = this.new13(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 14: {
                    Token token = this.new14(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 15: {
                    Token token = this.new15(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 16: {
                    Token token = this.new16(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 17: {
                    Token token = this.new17(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 18: {
                    Token token = this.new18(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 19: {
                    Token token = this.new19(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 20: {
                    Token token = this.new20(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 21: {
                    Token token = this.new21(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 22: {
                    Token token = this.new22(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 23: {
                    Token token = this.new23(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 24: {
                    Token token = this.new24(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 25: {
                    Token token = this.new25(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 26: {
                    Token token = this.new26(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 27: {
                    Token token = this.new27(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 28: {
                    Token token = this.new28(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 29: {
                    Token token = this.new29(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 30: {
                    Token token = this.new30(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 31: {
                    Token token = this.new31(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 32: {
                    Token token = this.new32(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 33: {
                    Token token = this.new33(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 34: {
                    Token token = this.new34(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 35: {
                    Token token = this.new35(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 36: {
                    Token token = this.new36(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 37: {
                    Token token = this.new37(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 38: {
                    Token token = this.new38(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 39: {
                    Token token = this.new39(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 40: {
                    Token token = this.new40(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 41: {
                    Token token = this.new41(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 42: {
                    Token token = this.new42(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 43: {
                    Token token = this.new43(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 44: {
                    Token token = this.new44(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 45: {
                    Token token = this.new45(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 46: {
                    Token token = this.new46(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 47: {
                    Token token = this.new47(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 48: {
                    Token token = this.new48(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 49: {
                    Token token = this.new49(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 50: {
                    Token token = this.new50(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 51: {
                    Token token = this.new51(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 52: {
                    Token token = this.new52(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 53: {
                    Token token = this.new53(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 54: {
                    Token token = this.new54(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 55: {
                    Token token = this.new55(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 56: {
                    Token token = this.new56(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 57: {
                    Token token = this.new57(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 58: {
                    Token token = this.new58(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 59: {
                    Token token = this.new59(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 60: {
                    Token token = this.new60(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 61: {
                    Token token = this.new61(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 62: {
                    Token token = this.new62(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 63: {
                    Token token = this.new63(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 64: {
                    Token token = this.new64(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 65: {
                    Token token = this.new65(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
            }
        }
        if (this.text.length() > 0) {
            throw new LexerException("[" + (start_line + 1) + "," + (start_pos + 1) + "]" + " Unknown token: " + this.text);
        }
        EOF token = new EOF(start_line + 1, start_pos + 1);
        return token;
    }

    Token new0(String text, int line, int pos) {
        return new TWktPointLiteral(text, line, pos);
    }

    Token new1(String text, int line, int pos) {
        return new TWktLineStringLiteral(text, line, pos);
    }

    Token new2(String text, int line, int pos) {
        return new TWktPolygonLiteral(text, line, pos);
    }

    Token new3(String text, int line, int pos) {
        return new TWktMultiPointLiteral(text, line, pos);
    }

    Token new4(String text, int line, int pos) {
        return new TWktMultiLineStringLiteral(text, line, pos);
    }

    Token new5(String text, int line, int pos) {
        return new TWktMultiPolygonLiteral(text, line, pos);
    }

    Token new6(String text, int line, int pos) {
        return new TWktGeometryCollectionLiteral(text, line, pos);
    }

    Token new7(String text, int line, int pos) {
        return new TWktEmptySetLiteral(text, line, pos);
    }

    Token new8(String text, int line, int pos) {
        return new TBlank(text, line, pos);
    }

    Token new9(String text, int line, int pos) {
        return new TSpace(text, line, pos);
    }

    Token new10(String text, int line, int pos) {
        return new TNewline(text, line, pos);
    }

    Token new11(String text, int line, int pos) {
        return new TSign(text, line, pos);
    }

    Token new12(int line, int pos) {
        return new TLeftParen(line, pos);
    }

    Token new13(int line, int pos) {
        return new TRightParen(line, pos);
    }

    Token new14(int line, int pos) {
        return new TPeriod(line, pos);
    }

    Token new15(String text, int line, int pos) {
        return new TColon(text, line, pos);
    }

    Token new16(String text, int line, int pos) {
        return new TComma(text, line, pos);
    }

    Token new17(int line, int pos) {
        return new TLessThanOperator(line, pos);
    }

    Token new18(int line, int pos) {
        return new TEqualsOperator(line, pos);
    }

    Token new19(int line, int pos) {
        return new TGreaterThanOperator(line, pos);
    }

    Token new20(int line, int pos) {
        return new TNotEqualsOperator(line, pos);
    }

    Token new21(int line, int pos) {
        return new TGreaterThanOrEqualsOperator(line, pos);
    }

    Token new22(int line, int pos) {
        return new TLessThanOrEqualsOperator(line, pos);
    }

    Token new23(String text, int line, int pos) {
        return new TBooleanNotOperator(text, line, pos);
    }

    Token new24(String text, int line, int pos) {
        return new TBooleanAndOperator(text, line, pos);
    }

    Token new25(String text, int line, int pos) {
        return new TBooleanOrOperator(text, line, pos);
    }

    Token new26(String text, int line, int pos) {
        return new TTextLikeOperator(text, line, pos);
    }

    Token new27(String text, int line, int pos) {
        return new TTextIlikeOperator(text, line, pos);
    }

    Token new28(String text, int line, int pos) {
        return new TExistsOperator(text, line, pos);
    }

    Token new29(String text, int line, int pos) {
        return new TDoesnotexistOperator(text, line, pos);
    }

    Token new30(String text, int line, int pos) {
        return new TTemporalBeforeOperator(text, line, pos);
    }

    Token new31(String text, int line, int pos) {
        return new TTemporalBeforeorduringOperator(text, line, pos);
    }

    Token new32(String text, int line, int pos) {
        return new TTemporalDuringOperator(text, line, pos);
    }

    Token new33(String text, int line, int pos) {
        return new TTemporalDuringorafterOperator(text, line, pos);
    }

    Token new34(String text, int line, int pos) {
        return new TTemporalAfterOperator(text, line, pos);
    }

    Token new35(String text, int line, int pos) {
        return new TNullIsOperator(text, line, pos);
    }

    Token new36(String text, int line, int pos) {
        return new TNullNotOperator(text, line, pos);
    }

    Token new37(String text, int line, int pos) {
        return new TGeoEqualsOperator(text, line, pos);
    }

    Token new38(String text, int line, int pos) {
        return new TGeoDisjointOperator(text, line, pos);
    }

    Token new39(String text, int line, int pos) {
        return new TGeoIntersectsOperator(text, line, pos);
    }

    Token new40(String text, int line, int pos) {
        return new TGeoTouchesOperator(text, line, pos);
    }

    Token new41(String text, int line, int pos) {
        return new TGeoCrossesOperator(text, line, pos);
    }

    Token new42(String text, int line, int pos) {
        return new TGeoWithinOperator(text, line, pos);
    }

    Token new43(String text, int line, int pos) {
        return new TGeoContainsOperator(text, line, pos);
    }

    Token new44(String text, int line, int pos) {
        return new TGeoOverlapsOperator(text, line, pos);
    }

    Token new45(String text, int line, int pos) {
        return new TGeoRelateOperator(text, line, pos);
    }

    Token new46(String text, int line, int pos) {
        return new TRelgeoDwithinOperator(text, line, pos);
    }

    Token new47(String text, int line, int pos) {
        return new TRelgeoBeyondOperator(text, line, pos);
    }

    Token new48(String text, int line, int pos) {
        return new TBooleanTrue(text, line, pos);
    }

    Token new49(String text, int line, int pos) {
        return new TBooleanFalse(text, line, pos);
    }

    Token new50(String text, int line, int pos) {
        return new TBooleanUnknown(text, line, pos);
    }

    Token new51(String text, int line, int pos) {
        return new TNullConstant(text, line, pos);
    }

    Token new52(String text, int line, int pos) {
        return new TSignedNumericLiteral(text, line, pos);
    }

    Token new53(String text, int line, int pos) {
        return new TUnsignedInteger(text, line, pos);
    }

    Token new54(String text, int line, int pos) {
        return new TCharacterStringLiteral(text, line, pos);
    }

    Token new55(String text, int line, int pos) {
        return new TIdentifier(text, line, pos);
    }

    Token new56(String text, int line, int pos) {
        return new TDurationDateTimeSeparator(text, line, pos);
    }

    Token new57(String text, int line, int pos) {
        return new TDurationSymbol(text, line, pos);
    }

    Token new58(String text, int line, int pos) {
        return new TTimeSpanSeparator(text, line, pos);
    }

    Token new59(String text, int line, int pos) {
        return new TDatetime(text, line, pos);
    }

    Token new60(int line, int pos) {
        return new TDurDaySymbol(line, pos);
    }

    Token new61(int line, int pos) {
        return new TDurMonthSymbol(line, pos);
    }

    Token new62(int line, int pos) {
        return new TDurYearSymbol(line, pos);
    }

    Token new63(int line, int pos) {
        return new TDurSecondSymbol(line, pos);
    }

    Token new64(int line, int pos) {
        return new TDurMinuteSymbol(line, pos);
    }

    Token new65(int line, int pos) {
        return new TDurHourSymbol(line, pos);
    }

    private int getChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        int result = this.in.read();
        if (result == -1) {
            this.eof = true;
        }
        return result;
    }

    private void pushBack(int acceptLength) throws IOException {
        int length = this.text.length();
        for (int i = length - 1; i >= acceptLength; --i) {
            this.eof = false;
            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(Token token) throws IOException {
        String text = token.getText();
        int length = text.length();
        for (int i = length - 1; i >= 0; --i) {
            this.eof = false;
            this.in.unread(text.charAt(i));
        }
        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength) {
        StringBuffer s2 = new StringBuffer(acceptLength);
        for (int i = 0; i < acceptLength; ++i) {
            s2.append(this.text.charAt(i));
        }
        return s2.toString();
    }

    static {
        try {
            int j;
            int i;
            DataInputStream s2 = new DataInputStream(new BufferedInputStream(Lexer.class.getResourceAsStream("lexer.dat")));
            int length = s2.readInt();
            gotoTable = new int[length][][][];
            for (i = 0; i < gotoTable.length; ++i) {
                length = s2.readInt();
                Lexer.gotoTable[i] = new int[length][][];
                for (j = 0; j < gotoTable[i].length; ++j) {
                    length = s2.readInt();
                    Lexer.gotoTable[i][j] = new int[length][3];
                    for (int k = 0; k < gotoTable[i][j].length; ++k) {
                        for (int l = 0; l < 3; ++l) {
                            Lexer.gotoTable[i][j][k][l] = s2.readInt();
                        }
                    }
                }
            }
            length = s2.readInt();
            accept = new int[length][];
            for (i = 0; i < accept.length; ++i) {
                length = s2.readInt();
                Lexer.accept[i] = new int[length];
                for (j = 0; j < accept[i].length; ++j) {
                    Lexer.accept[i][j] = s2.readInt();
                }
            }
            s2.close();
        }
        catch (Exception e) {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }

    public static class State {
        public static final State NORMAL = new State(0);
        public static final State WKT = new State(1);
        private int id;

        private State(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }
}

