/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.cql;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.geolatte.common.cql.analysis.DepthFirstAdapter;
import org.geolatte.common.cql.node.ACompoundIdAttr;
import org.geolatte.common.cql.node.ADefaultDatetimeLiteral;
import org.geolatte.common.cql.node.ADefaultDurationLiteral;
import org.geolatte.common.cql.node.ADefaultNumericLiteral;
import org.geolatte.common.cql.node.ADefaultStringLiteral;
import org.geolatte.common.cql.node.AFalseBooleanLiteral;
import org.geolatte.common.cql.node.AFromToTimespanLiteral;
import org.geolatte.common.cql.node.AIdAttr;
import org.geolatte.common.cql.node.APointGeometryLiteral;
import org.geolatte.common.cql.node.ATrueBooleanLiteral;
import org.geolatte.common.cql.node.AUnknownBooleanLiteral;
import org.geolatte.common.cql.node.Node;
import org.geolatte.common.cql.node.PAttr;
import org.geolatte.common.cql.node.PLiteral;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkt;
import org.geolatte.geom.codec.WktDecodeException;

public class AbstractBuilder
extends DepthFirstAdapter {
    protected HashMap<Node, Object> translatedLiterals = new HashMap();

    private void putLiteral(Node node, Object value) {
        this.translatedLiterals.put(node, value);
        node = node.parent();
        if (node instanceof PLiteral) {
            this.translatedLiterals.put(node, value);
        }
    }

    protected Object getLiteral(Node node) {
        return this.translatedLiterals.get(node);
    }

    @Override
    public void outADefaultStringLiteral(ADefaultStringLiteral node) {
        this.putLiteral(node, node.getCharacterStringLiteral().getText().trim().substring(1, node.getCharacterStringLiteral().getText().length() - 1));
    }

    @Override
    public void outADefaultNumericLiteral(ADefaultNumericLiteral node) {
        this.putLiteral(node, node.getSignedNumericLiteral().getText());
    }

    @Override
    public void outATrueBooleanLiteral(ATrueBooleanLiteral node) {
        this.putLiteral(node, "true");
    }

    @Override
    public void outAFalseBooleanLiteral(AFalseBooleanLiteral node) {
        this.putLiteral(node, "false");
    }

    @Override
    public void outAFromToTimespanLiteral(AFromToTimespanLiteral node) {
        this.putLiteral(node, new FromToTimeSpan(AbstractBuilder.parseDate(node.getFrom().getText().trim()), AbstractBuilder.parseDate(node.getTo().getText().trim())));
    }

    @Override
    public void outAUnknownBooleanLiteral(AUnknownBooleanLiteral node) {
        this.putLiteral(node, "null");
    }

    @Override
    public void outADefaultDurationLiteral(ADefaultDurationLiteral node) {
        int years = Integer.parseInt(node.getYears().getText());
        int months = Integer.parseInt(node.getMonths().getText());
        int days = Integer.parseInt(node.getDays().getText());
        int hours = Integer.parseInt(node.getHours().getText());
        int minutes = Integer.parseInt(node.getMinutes().getText());
        int seconds = Integer.parseInt(node.getSeconds().getText());
        this.putLiteral(node, new Duration(years, months, days, hours, minutes, seconds));
    }

    @Override
    public void outADefaultDatetimeLiteral(ADefaultDatetimeLiteral node) {
        this.putLiteral(node, node.getDatetime().getText());
    }

    @Override
    public void outAPointGeometryLiteral(APointGeometryLiteral node) {
        String wkt = node.getWktPointLiteral().getText();
        try {
            Geometry geo = Wkt.fromWkt(wkt);
            this.putLiteral(node, geo);
        }
        catch (WktDecodeException e) {
            throw new RuntimeException("Could not parse WKT: " + wkt, e);
        }
    }

    public static Date parseDate(String dateString) {
        Date date = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            date = formatter.parse(dateString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    protected List<String> getPropertyParts(PAttr attr) {
        ArrayList<String> parts = new ArrayList<String>();
        if (attr instanceof AIdAttr) {
            parts.add(((AIdAttr)attr).getIdentifier().getText().trim());
            return parts;
        }
        ACompoundIdAttr compoundAttr = (ACompoundIdAttr)attr;
        parts.add(compoundAttr.getIdentifier().getText().trim());
        parts.addAll(this.getPropertyParts(compoundAttr.getAttr()));
        return parts;
    }

    protected String getPropertyPath(Collection<String> parts) {
        StringBuilder propertyPath = new StringBuilder();
        Iterator<String> partsIterator = parts.iterator();
        propertyPath.append(partsIterator.next());
        while (partsIterator.hasNext()) {
            propertyPath.append(".").append(partsIterator.next());
        }
        return propertyPath.toString();
    }

    protected String getPropertyPath(PAttr attr) {
        Iterator<String> propertyPartsIterator = this.getPropertyParts(attr).iterator();
        String propertyPath = propertyPartsIterator.next();
        while (propertyPartsIterator.hasNext()) {
            String propertyPart = propertyPartsIterator.next();
            propertyPath = propertyPath + "." + propertyPart;
        }
        return propertyPath;
    }

    protected String getLastPropertyPart(PAttr attr) {
        if (attr instanceof AIdAttr) {
            return ((AIdAttr)attr).getIdentifier().getText().trim();
        }
        ACompoundIdAttr compoundAttr = (ACompoundIdAttr)attr;
        return this.getLastPropertyPart(compoundAttr.getAttr());
    }

    protected class Duration {
        private int years;
        private int months;
        private int days;
        private int hours;
        private int minutes;
        private int seconds;

        private Duration(int years, int months, int days, int hours, int minutes, int seconds) {
            this.years = years;
            this.months = months;
            this.days = days;
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
        }

        public int getYears() {
            return this.years;
        }

        public int getMonths() {
            return this.months;
        }

        public int getDays() {
            return this.days;
        }

        public int getHours() {
            return this.hours;
        }

        public int getMinutes() {
            return this.minutes;
        }

        public int getSeconds() {
            return this.seconds;
        }
    }

    protected class FromToTimeSpan {
        public Date from;
        public Date to;

        private FromToTimeSpan(Date from, Date to) {
            this.from = from;
            this.to = to;
        }
    }
}

