/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.logging;

import java.lang.reflect.Method;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.paho.client.mqttv3.logging.JSR47Logger;
import org.eclipse.paho.client.mqttv3.logging.Logger;

public class LoggerFactory {
    public static final String MQTT_CLIENT_MSG_CAT = "org.eclipse.paho.client.mqttv3.internal.nls.logcat";
    private static final String CLASS_NAME = LoggerFactory.class.getName();
    private static String overrideloggerClassName = null;
    private static String jsr47LoggerClassName = JSR47Logger.class.getName();

    public static Logger getLogger(String messageCatalogName, String loggerID) {
        String loggerClassName = overrideloggerClassName;
        Logger logger = null;
        if (loggerClassName == null) {
            loggerClassName = jsr47LoggerClassName;
        }
        if ((logger = LoggerFactory.getLogger(loggerClassName, ResourceBundle.getBundle(messageCatalogName), loggerID, null)) == null) {
            throw new MissingResourceException("Error locating the logging class", CLASS_NAME, loggerID);
        }
        return logger;
    }

    private static Logger getLogger(String loggerClassName, ResourceBundle messageCatalog, String loggerID, String resourceName) {
        Logger logger = null;
        Class<?> logClass = null;
        try {
            logClass = Class.forName(loggerClassName);
        }
        catch (NoClassDefFoundError ncdfe) {
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        if (logClass != null) {
            try {
                logger = (Logger)logClass.newInstance();
            }
            catch (IllegalAccessException e) {
                return null;
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (ExceptionInInitializerError e) {
                return null;
            }
            catch (SecurityException e) {
                return null;
            }
            logger.initialise(messageCatalog, loggerID, resourceName);
        }
        return logger;
    }

    public static String getLoggingProperty(String name) {
        String result = null;
        try {
            Class<?> logManagerClass = Class.forName("java.util.logging.LogManager");
            Method m1 = logManagerClass.getMethod("getLogManager", new Class[0]);
            Object logManagerInstance = m1.invoke(null, null);
            Method m22 = logManagerClass.getMethod("getProperty", String.class);
            result = (String)m22.invoke(logManagerInstance, name);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static void setLogger(String loggerClassName) {
        overrideloggerClassName = loggerClassName;
    }
}

