/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.text.ParseException;
import net.time4j.CalendarUnit;
import net.time4j.IsoDateUnit;
import net.time4j.Weekcycle;
import net.time4j.base.MathUtils;
import net.time4j.engine.TimePoint;
import net.time4j.range.CalendarMonth;
import net.time4j.range.CalendarQuarter;
import net.time4j.range.CalendarWeek;
import net.time4j.range.CalendarYear;
import net.time4j.range.SingleUnitTimeSpan;

public final class Years<U extends IsoDateUnit>
extends SingleUnitTimeSpan<U, Years<U>> {
    public static final Years<CalendarUnit> ZERO = new Years<CalendarUnit>(0, CalendarUnit.YEARS);
    public static final Years<CalendarUnit> ONE = new Years<CalendarUnit>(1, CalendarUnit.YEARS);
    private static final long serialVersionUID = 6288717039772347252L;

    private Years(int n, U u) {
        super(n, u);
    }

    public static Years<CalendarUnit> ofGregorian(int n) {
        return n == 0 ? ZERO : (n == 1 ? ONE : new Years<CalendarUnit>(n, CalendarUnit.YEARS));
    }

    public static Years<Weekcycle> ofWeekBased(int n) {
        return new Years<Weekcycle>(n, Weekcycle.YEARS);
    }

    public static <T extends TimePoint<? super CalendarUnit, T>> Years<CalendarUnit> between(T t2, T t3) {
        long l = CalendarUnit.YEARS.between(t2, t3);
        return Years.ofGregorian(MathUtils.safeCast(l));
    }

    public static Years<CalendarUnit> between(CalendarYear calendarYear, CalendarYear calendarYear2) {
        return Years.ofGregorian(calendarYear2.getValue() - calendarYear.getValue());
    }

    public static Years<CalendarUnit> between(CalendarQuarter calendarQuarter, CalendarQuarter calendarQuarter2) {
        int n = calendarQuarter2.getYear() - calendarQuarter.getYear();
        if (n > 0) {
            if (calendarQuarter2.getQuarter().compareTo(calendarQuarter.getQuarter()) < 0) {
                --n;
            }
        } else if (n < 0 && calendarQuarter2.getQuarter().compareTo(calendarQuarter.getQuarter()) > 0) {
            ++n;
        }
        return Years.ofGregorian(n);
    }

    public static Years<CalendarUnit> between(CalendarMonth calendarMonth, CalendarMonth calendarMonth2) {
        int n = calendarMonth.getYear() - calendarMonth2.getYear();
        if (n > 0) {
            if (calendarMonth2.getMonth().compareTo(calendarMonth.getMonth()) < 0) {
                --n;
            }
        } else if (n < 0 && calendarMonth2.getMonth().compareTo(calendarMonth.getMonth()) > 0) {
            ++n;
        }
        return Years.ofGregorian(n);
    }

    public static Years<Weekcycle> between(CalendarWeek calendarWeek, CalendarWeek calendarWeek2) {
        int n = calendarWeek2.getYear() - calendarWeek.getYear();
        if (n > 0) {
            if (calendarWeek2.getWeek() < calendarWeek.getWeek()) {
                --n;
            }
        } else if (n < 0 && calendarWeek2.getWeek() > calendarWeek.getWeek()) {
            ++n;
        }
        return Years.ofWeekBased(n);
    }

    public static Years<CalendarUnit> parseGregorian(String string) throws ParseException {
        int n = SingleUnitTimeSpan.parsePeriod(string, 'Y');
        return Years.ofGregorian(n);
    }

    public static Years<Weekcycle> parseWeekBased(String string) throws ParseException {
        int n = SingleUnitTimeSpan.parsePeriod(string, 'Y');
        return Years.ofWeekBased(n);
    }

    @Override
    Years<U> with(int n) {
        return new Years(n, this.getUnit());
    }

    @Override
    Years<U> self() {
        return this;
    }

    @Override
    void checkConsistency(U u) {
        if (!u.equals(CalendarUnit.YEARS) && !u.equals(Weekcycle.YEARS)) {
            throw new IllegalArgumentException("Invalid year unit: " + u);
        }
    }
}

