/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.Duration;
import net.time4j.IsoDateUnit;
import net.time4j.PrettyTime;
import net.time4j.base.MathUtils;
import net.time4j.engine.TimePoint;
import net.time4j.engine.TimeSpan;
import net.time4j.format.TextWidth;

public abstract class SingleUnitTimeSpan<U extends IsoDateUnit, D extends SingleUnitTimeSpan<U, D>>
implements TimeSpan<U>,
Comparable<D>,
Serializable {
    private final int amount;
    private final U unit;

    SingleUnitTimeSpan(int n, U u) {
        this.amount = n;
        this.unit = u;
        this.checkConsistency(u);
    }

    public int getAmount() {
        return this.amount;
    }

    public U getUnit() {
        return this.unit;
    }

    @Override
    public int compareTo(D d) {
        if (this.unit.equals(((SingleUnitTimeSpan)d).getUnit())) {
            return this.amount < ((SingleUnitTimeSpan)d).getAmount() ? -1 : (this.amount == ((SingleUnitTimeSpan)d).getAmount() ? 0 : 1);
        }
        throw new ClassCastException("Durations with different units are not comparable.");
    }

    @Override
    public List<TimeSpan.Item<U>> getTotalLength() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        long l = this.amount;
        TimeSpan.Item<U> item = TimeSpan.Item.of(Math.abs(l), this.unit);
        return Collections.singletonList(item);
    }

    @Override
    public boolean contains(IsoDateUnit isoDateUnit) {
        return this.unit.equals(isoDateUnit) && this.amount != 0;
    }

    @Override
    public long getPartialAmount(IsoDateUnit isoDateUnit) {
        return this.unit.equals(isoDateUnit) ? this.amount : 0;
    }

    @Override
    public boolean isNegative() {
        return this.amount < 0;
    }

    @Override
    public boolean isPositive() {
        return this.amount > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.amount == 0;
    }

    @Override
    public <T extends TimePoint<? super U, T>> T addTo(T t2) {
        return t2.plus(this.amount, this.unit);
    }

    @Override
    public <T extends TimePoint<? super U, T>> T subtractFrom(T t2) {
        return t2.minus(this.amount, this.unit);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SingleUnitTimeSpan) {
            SingleUnitTimeSpan singleUnitTimeSpan = (SingleUnitTimeSpan)SingleUnitTimeSpan.class.cast(object);
            return this.amount == singleUnitTimeSpan.amount && this.unit.equals(singleUnitTimeSpan.unit);
        }
        return false;
    }

    public int hashCode() {
        return this.amount ^ this.unit.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.amount < 0) {
            stringBuilder.append('-');
        }
        stringBuilder.append('P');
        long l = this.amount;
        stringBuilder.append(Math.abs(l));
        stringBuilder.append(this.unit.getSymbol());
        return stringBuilder.toString();
    }

    public String toString(Locale locale, TextWidth textWidth) {
        return PrettyTime.of(locale).print(this.toStdDuration(), textWidth);
    }

    public D abs() {
        long l = this.amount;
        return this.with(MathUtils.safeCast(Math.abs(l)));
    }

    public D inverse() {
        return this.with(MathUtils.safeNegate(this.amount));
    }

    public D plus(int n) {
        if (n == 0) {
            return this.self();
        }
        long l = this.amount;
        return this.with(MathUtils.safeCast(l + (long)n));
    }

    public D plus(D d) {
        if (((SingleUnitTimeSpan)d).isEmpty()) {
            return this.self();
        }
        long l = this.amount;
        return this.with(MathUtils.safeCast(l + (long)((SingleUnitTimeSpan)d).getAmount()));
    }

    public D minus(int n) {
        if (n == 0) {
            return this.self();
        }
        long l = this.amount;
        return this.with(MathUtils.safeCast(l - (long)n));
    }

    public D minus(D d) {
        if (((SingleUnitTimeSpan)d).isEmpty()) {
            return this.self();
        }
        long l = this.amount;
        return this.with(MathUtils.safeCast(l - (long)((SingleUnitTimeSpan)d).getAmount()));
    }

    public D multipliedBy(int n) {
        switch (n) {
            case -1: {
                return this.inverse();
            }
            case 1: {
                return this.self();
            }
        }
        return this.with(MathUtils.safeMultiply(this.amount, n));
    }

    public Duration<U> toStdDuration() {
        return Duration.of(this.amount, this.unit);
    }

    abstract D with(int var1);

    abstract D self();

    static int parsePeriod(String string, char c) throws ParseException {
        char c2;
        if (string.isEmpty()) {
            throw new ParseException("Empty period.", 0);
        }
        boolean bl = false;
        int n = 0;
        int n2 = string.length();
        if (string.charAt(0) == '-') {
            ++n;
            bl = true;
        }
        if (n < n2 && string.charAt(n) != 'P') {
            throw new ParseException("Missing P-literal: " + string, n);
        }
        long l = 0L;
        int n3 = ++n;
        int n4 = Math.min(n2, 10);
        for (int i = n; i < n4 && (c2 = string.charAt(i)) >= '0' && c2 <= '9'; ++i) {
            int n5 = c2 - 48;
            l = l * 10L + (long)n5;
            ++n;
        }
        if (n == n3) {
            throw new ParseException("Missing digits: " + string, n);
        }
        if (n2 == n + 1 && string.charAt(n) == c) {
            ++n;
            try {
                if (bl) {
                    l = MathUtils.safeNegate(l);
                }
                return MathUtils.safeCast(l);
            }
            catch (ArithmeticException arithmeticException) {
                throw new ParseException(arithmeticException.getMessage(), n);
            }
        }
        throw new ParseException("Unparseable format: " + string, n);
    }

    final void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.checkConsistency(this.unit);
    }

    void checkConsistency(U u) {
        if (u == null) {
            throw new NullPointerException("Missing unit.");
        }
    }
}

