/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.text.ParseException;
import net.time4j.CalendarUnit;
import net.time4j.PlainDate;
import net.time4j.base.MathUtils;
import net.time4j.engine.TimePoint;
import net.time4j.range.CalendarQuarter;
import net.time4j.range.SingleUnitTimeSpan;

public final class Quarters
extends SingleUnitTimeSpan<CalendarUnit, Quarters> {
    public static final Quarters ZERO = new Quarters(0);
    public static final Quarters ONE = new Quarters(1);
    private static final long serialVersionUID = -2100419304667904214L;

    private Quarters(int n) {
        super(n, CalendarUnit.QUARTERS);
    }

    public static Quarters of(int n) {
        return n == 0 ? ZERO : (n == 1 ? ONE : new Quarters(n));
    }

    public static <T extends TimePoint<? super CalendarUnit, T>> Quarters between(T t2, T t3) {
        long l = CalendarUnit.QUARTERS.between(t2, t3);
        return Quarters.of(MathUtils.safeCast(l));
    }

    public static Quarters between(CalendarQuarter calendarQuarter, CalendarQuarter calendarQuarter2) {
        PlainDate plainDate = calendarQuarter.atDayOfQuarter(1);
        PlainDate plainDate2 = calendarQuarter2.atDayOfQuarter(1);
        return Quarters.between(plainDate, plainDate2);
    }

    public static Quarters parsePeriod(String string) throws ParseException {
        int n = SingleUnitTimeSpan.parsePeriod(string, 'Q');
        return Quarters.of(n);
    }

    @Override
    Quarters with(int n) {
        return Quarters.of(n);
    }

    @Override
    Quarters self() {
        return this;
    }
}

