/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.text.ParseException;
import net.time4j.CalendarUnit;
import net.time4j.PlainDate;
import net.time4j.base.MathUtils;
import net.time4j.engine.TimePoint;
import net.time4j.range.CalendarMonth;
import net.time4j.range.SingleUnitTimeSpan;

public final class Months
extends SingleUnitTimeSpan<CalendarUnit, Months> {
    public static final Months ZERO = new Months(0);
    public static final Months ONE = new Months(1);
    private static final long serialVersionUID = 6367060429891625338L;

    private Months(int n) {
        super(n, CalendarUnit.MONTHS);
    }

    public static Months of(int n) {
        return n == 0 ? ZERO : (n == 1 ? ONE : new Months(n));
    }

    public static <T extends TimePoint<? super CalendarUnit, T>> Months between(T t2, T t3) {
        long l = CalendarUnit.MONTHS.between(t2, t3);
        return Months.of(MathUtils.safeCast(l));
    }

    public static Months between(CalendarMonth calendarMonth, CalendarMonth calendarMonth2) {
        PlainDate plainDate = calendarMonth.atDayOfMonth(1);
        PlainDate plainDate2 = calendarMonth2.atDayOfMonth(1);
        return Months.between(plainDate, plainDate2);
    }

    public static Months parsePeriod(String string) throws ParseException {
        int n = SingleUnitTimeSpan.parsePeriod(string, 'M');
        return Months.of(n);
    }

    @Override
    Months with(int n) {
        return Months.of(n);
    }

    @Override
    Months self() {
        return this;
    }
}

