/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.Serializable;
import java.time.Instant;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.engine.TimeLine;
import net.time4j.range.Boundary;
import net.time4j.range.ChronoInterval;
import net.time4j.range.ClockWindows;
import net.time4j.range.DateWindows;
import net.time4j.range.GenericWindows;
import net.time4j.range.IntervalEdge;
import net.time4j.range.MomentWindows;
import net.time4j.range.SimpleInterval;
import net.time4j.range.TimestampWindows;

public abstract class IntervalCollection<T>
extends AbstractCollection<ChronoInterval<T>>
implements Serializable {
    private final transient List<ChronoInterval<T>> intervals;

    IntervalCollection() {
        this.intervals = Collections.emptyList();
    }

    IntervalCollection(List<ChronoInterval<T>> list) {
        this.intervals = Collections.unmodifiableList(list);
    }

    public static IntervalCollection<PlainDate> onDateAxis() {
        return DateWindows.EMPTY;
    }

    public static IntervalCollection<PlainTime> onClockAxis() {
        return ClockWindows.EMPTY;
    }

    public static IntervalCollection<PlainTimestamp> onTimestampAxis() {
        return TimestampWindows.EMPTY;
    }

    public static IntervalCollection<Moment> onMomentAxis() {
        return MomentWindows.EMPTY;
    }

    public static IntervalCollection<Date> onTraditionalTimeLine() {
        return IntervalCollection.on(SimpleInterval.onTraditionalTimeLine().getTimeLine());
    }

    public static IntervalCollection<Instant> onInstantTimeLine() {
        return IntervalCollection.on(SimpleInterval.onInstantTimeLine().getTimeLine());
    }

    public static <T> IntervalCollection<T> on(TimeLine<T> timeLine) {
        if (timeLine.equals(PlainDate.axis())) {
            return IntervalCollection.onDateAxis();
        }
        if (timeLine.equals(PlainTime.axis())) {
            return IntervalCollection.onClockAxis();
        }
        if (timeLine.equals(PlainTimestamp.axis())) {
            return IntervalCollection.onTimestampAxis();
        }
        if (timeLine.equals(Moment.axis())) {
            return IntervalCollection.onMomentAxis();
        }
        return new GenericWindows<T>(timeLine, Collections.emptyList());
    }

    public List<ChronoInterval<T>> getIntervals() {
        return this.intervals;
    }

    @Override
    public Iterator<ChronoInterval<T>> iterator() {
        return this.intervals.iterator();
    }

    @Override
    public int size() {
        return this.intervals.size();
    }

    @Override
    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public boolean isDisjunct() {
        int n = this.intervals.size() - 1;
        for (int i = 0; i < n; ++i) {
            ChronoInterval<T> chronoInterval = this.intervals.get(i);
            ChronoInterval<T> chronoInterval2 = this.intervals.get(i + 1);
            if (chronoInterval.getEnd().isInfinite() || chronoInterval2.getStart().isInfinite()) {
                return false;
            }
            if (!(chronoInterval.getEnd().isOpen() ? this.isAfter(chronoInterval.getEnd().getTemporal(), chronoInterval2.getStart().getTemporal()) : !this.isBefore(chronoInterval.getEnd().getTemporal(), chronoInterval2.getStart().getTemporal()))) continue;
            return false;
        }
        return true;
    }

    public boolean encloses(T t2) {
        for (ChronoInterval<T> chronoInterval : this.intervals) {
            if (chronoInterval.contains(t2)) {
                return true;
            }
            if (!chronoInterval.isAfter(t2)) continue;
            break;
        }
        return false;
    }

    public boolean contains(ChronoInterval<T> chronoInterval) {
        for (ChronoInterval<T> chronoInterval2 : this.intervals) {
            if (!chronoInterval2.equals(chronoInterval)) continue;
            return true;
        }
        return false;
    }

    public T getMinimum() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Empty time windows have no minimum.");
        }
        return this.intervals.get(0).getStart().getTemporal();
    }

    public T getMaximum() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Empty time windows have no maximum.");
        }
        int n = this.intervals.size();
        Boundary<T> boundary = this.intervals.get(n - 1).getEnd();
        Object object = boundary.getTemporal();
        if (boundary.isInfinite()) {
            return null;
        }
        if (this.isCalendrical()) {
            if (boundary.isOpen()) {
                object = this.getTimeLine().stepBackwards(object);
            }
            for (int i = n - 2; i >= 0; --i) {
                Boundary<T> boundary2 = this.intervals.get(i).getEnd();
                T t2 = boundary2.getTemporal();
                if (boundary2.isInfinite()) {
                    return null;
                }
                if (boundary2.isOpen()) {
                    t2 = this.getTimeLine().stepBackwards(t2);
                }
                if (!this.isAfter(t2, object)) continue;
                object = t2;
            }
        } else {
            Object var4_5 = null;
            if (boundary.isClosed()) {
                T t3 = this.getTimeLine().stepForward(object);
                if (t3 == null) {
                    var4_5 = object;
                } else {
                    object = t3;
                }
            }
            for (int i = n - 2; i >= 0; --i) {
                Boundary<T> boundary3 = this.intervals.get(i).getEnd();
                T t4 = boundary3.getTemporal();
                if (boundary3.isInfinite()) {
                    return null;
                }
                if (var4_5 != null) continue;
                if (boundary3.isClosed()) {
                    T t5 = this.getTimeLine().stepForward(t4);
                    if (t5 == null) {
                        var4_5 = t4;
                        continue;
                    }
                    t4 = t5;
                }
                if (!this.isAfter(t4, object)) continue;
                object = t4;
            }
            object = var4_5 != null ? var4_5 : this.getTimeLine().stepBackwards(object);
        }
        return object;
    }

    public ChronoInterval<T> getRange() {
        Boundary boundary = Boundary.infinitePast();
        Boundary boundary2 = Boundary.infiniteFuture();
        T t2 = this.getMinimum();
        T t3 = this.getMaximum();
        if (t2 != null) {
            boundary = Boundary.ofClosed(t2);
        }
        if (t3 != null) {
            T t4;
            boundary2 = this.isCalendrical() ? Boundary.ofClosed(t3) : ((t4 = this.getTimeLine().stepForward(t3)) != null ? Boundary.ofOpen(t4) : Boundary.ofClosed(t3));
        }
        return this.newInterval(boundary, boundary2);
    }

    public IntervalCollection<T> plus(ChronoInterval<T> chronoInterval) {
        if (chronoInterval.isEmpty()) {
            return this;
        }
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>(this.intervals);
        arrayList.add(this.adjust(chronoInterval));
        arrayList.sort(this.getComparator());
        return this.create(arrayList);
    }

    public IntervalCollection<T> plus(Collection<? extends ChronoInterval<T>> collection) {
        if (collection.isEmpty()) {
            return this;
        }
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>(this.intervals);
        for (ChronoInterval<T> chronoInterval : collection) {
            if (chronoInterval.isEmpty()) continue;
            arrayList.add(this.adjust(chronoInterval));
        }
        arrayList.sort(this.getComparator());
        return this.create(arrayList);
    }

    public IntervalCollection<T> plus(IntervalCollection<T> intervalCollection) {
        if (this == intervalCollection) {
            return this;
        }
        return this.plus(intervalCollection.getIntervals());
    }

    public IntervalCollection<T> minus(ChronoInterval<T> chronoInterval) {
        if (this.isEmpty() || chronoInterval.isEmpty()) {
            return this;
        }
        ChronoInterval<T> chronoInterval2 = this.intervals.get(0);
        ChronoInterval<T> chronoInterval3 = this.adjust(chronoInterval);
        if (!chronoInterval2.getStart().isInfinite() && chronoInterval3.isBefore(chronoInterval2.getStart().getTemporal())) {
            return this;
        }
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>();
        IntervalCollection<T> intervalCollection = this.create(Collections.singletonList(chronoInterval3));
        IntervalCollection<T> intervalCollection2 = intervalCollection.withComplement(chronoInterval2);
        if (!intervalCollection2.isEmpty()) {
            arrayList.addAll(intervalCollection2.intervals);
        }
        int n = this.intervals.size();
        for (int i = 1; i < n; ++i) {
            chronoInterval2 = this.intervals.get(i);
            if (!chronoInterval2.getStart().isInfinite() && chronoInterval3.isBefore(chronoInterval2.getStart().getTemporal())) {
                arrayList.add(chronoInterval2);
                for (int j = i + 1; j < n; ++j) {
                    arrayList.add(this.intervals.get(j));
                }
                break;
            }
            intervalCollection2 = intervalCollection.withComplement(chronoInterval2);
            if (intervalCollection2.isEmpty()) continue;
            arrayList.addAll(intervalCollection2.intervals);
        }
        arrayList.sort(this.getComparator());
        return this.create(arrayList);
    }

    public IntervalCollection<T> minus(Collection<? extends ChronoInterval<T>> collection) {
        if (this.isEmpty() || collection.isEmpty()) {
            return this;
        }
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>();
        ArrayList<ChronoInterval<T>> arrayList2 = new ArrayList<ChronoInterval<T>>();
        for (ChronoInterval<T> chronoInterval : collection) {
            if (chronoInterval.isEmpty()) continue;
            arrayList2.add(this.adjust(chronoInterval));
        }
        arrayList2.sort(this.getComparator());
        IntervalCollection<T> intervalCollection = this.create(arrayList2);
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            ChronoInterval<T> chronoInterval = this.intervals.get(i);
            IntervalCollection<T> intervalCollection2 = intervalCollection.withComplement(chronoInterval);
            if (intervalCollection2.isEmpty()) continue;
            arrayList.addAll(intervalCollection2.intervals);
        }
        arrayList.sort(this.getComparator());
        return this.create(arrayList);
    }

    public IntervalCollection<T> minus(IntervalCollection<T> intervalCollection) {
        if (this == intervalCollection) {
            List<ChronoInterval<T>> list = Collections.emptyList();
            return this.create(list);
        }
        return this.minus(intervalCollection.getIntervals());
    }

    public IntervalCollection<T> withTimeWindow(ChronoInterval<T> chronoInterval) {
        return this.withFilter(this.adjust(chronoInterval));
    }

    public IntervalCollection<T> withComplement(ChronoInterval<T> chronoInterval) {
        T t2;
        T t3;
        if (chronoInterval.isEmpty()) {
            List<ChronoInterval<T>> list = Collections.emptyList();
            return this.create(list);
        }
        ChronoInterval<T> chronoInterval2 = this.adjust(chronoInterval);
        IntervalCollection<T> intervalCollection = this.withFilter(chronoInterval2);
        if (intervalCollection.isEmpty()) {
            return this.create(Collections.singletonList(chronoInterval2));
        }
        Boundary<T> boundary = chronoInterval2.getStart();
        Boundary<T> boundary2 = chronoInterval2.getEnd();
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>();
        T t4 = intervalCollection.getMinimum();
        if (t4 != null) {
            if (boundary.isInfinite()) {
                this.addLeft(arrayList, t4);
            } else {
                t3 = boundary.getTemporal();
                if (boundary.isOpen()) {
                    t3 = this.getTimeLine().stepBackwards(t3);
                    if (t3 == null) {
                        this.addLeft(arrayList, t4);
                    } else {
                        this.addLeft(arrayList, t3, t4);
                    }
                } else {
                    this.addLeft(arrayList, t3, t4);
                }
            }
        }
        arrayList.addAll(intervalCollection.withGaps().getIntervals());
        t3 = intervalCollection.getMaximum();
        if (t3 != null && (t2 = this.getTimeLine().stepForward(t3)) != null) {
            Boundary<T> boundary3 = Boundary.ofClosed(t2);
            if (boundary2.isInfinite()) {
                Boundary<T> boundary4 = boundary2;
                arrayList.add(this.newInterval(boundary3, boundary4));
            } else if (this.isCalendrical()) {
                Boundary<T> boundary5;
                if (boundary2.isClosed()) {
                    boundary5 = boundary2;
                } else {
                    T t5 = boundary2.getTemporal();
                    t5 = this.getTimeLine().stepBackwards(t5);
                    boundary5 = Boundary.ofClosed(t5);
                }
                if (!this.isAfter(t2, boundary5.getTemporal())) {
                    arrayList.add(this.newInterval(boundary3, boundary5));
                }
            } else {
                Boundary<T> boundary6;
                if (boundary2.isOpen()) {
                    boundary6 = boundary2;
                } else {
                    T t6 = boundary2.getTemporal();
                    t6 = this.getTimeLine().stepForward(t6);
                    boundary6 = t6 == null ? Boundary.infiniteFuture() : Boundary.ofOpen(t6);
                }
                if (this.isBefore(t2, boundary6.getTemporal())) {
                    arrayList.add(this.newInterval(boundary3, boundary6));
                }
            }
        }
        return this.create(arrayList);
    }

    public IntervalCollection<T> withGaps() {
        ChronoInterval<T> chronoInterval;
        int n = this.intervals.size();
        if (n == 0) {
            return this;
        }
        if (n == 1) {
            List<ChronoInterval<T>> list = Collections.emptyList();
            return this.create(list);
        }
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>();
        T t2 = null;
        int n2 = n - 1;
        for (int i = 0; i < n2 && !(chronoInterval = this.intervals.get(i)).getEnd().isInfinite(); ++i) {
            T t3 = chronoInterval.getEnd().getTemporal();
            if (chronoInterval.getEnd().isClosed() && (t3 = this.getTimeLine().stepForward(t3)) == null) break;
            if (t2 == null || this.isAfter(t3, t2)) {
                t2 = t3;
            } else {
                t3 = t2;
            }
            T t4 = this.intervals.get(i + 1).getStart().getTemporal();
            if (t4 == null || !this.isAfter(t4, t3)) continue;
            IntervalEdge intervalEdge = IntervalEdge.OPEN;
            if (this.isCalendrical()) {
                intervalEdge = IntervalEdge.CLOSED;
                t4 = this.getTimeLine().stepBackwards(t4);
                if (t4 == null) continue;
            }
            Boundary<T> boundary = Boundary.ofClosed(t3);
            Boundary<T> boundary2 = Boundary.of(intervalEdge, t4);
            arrayList.add(this.newInterval(boundary, boundary2));
        }
        return this.create(arrayList);
    }

    public IntervalCollection<T> withBlocks() {
        Boundary boundary;
        Boundary<T> boundary2;
        if (this.intervals.size() < 2) {
            return this;
        }
        boolean bl = this.isCalendrical();
        IntervalEdge intervalEdge = bl ? IntervalEdge.CLOSED : IntervalEdge.OPEN;
        List<ChronoInterval<T>> list = this.withGaps().intervals;
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>();
        T t2 = this.getMinimum();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            T t3 = list.get(i).getStart().getTemporal();
            if (bl) {
                t3 = this.getTimeLine().stepBackwards(t3);
            }
            boundary2 = this.createStartBoundary(t2);
            boundary = Boundary.of(intervalEdge, t3);
            arrayList.add(this.newInterval(boundary2, boundary));
            Boundary<T> boundary3 = list.get(i).getEnd();
            t2 = boundary3.getTemporal();
            if (!boundary3.isClosed()) continue;
            t2 = this.getTimeLine().stepForward(t2);
        }
        T t4 = this.getMaximum();
        boundary2 = this.createStartBoundary(t2);
        if (t4 != null && !bl) {
            t4 = this.getTimeLine().stepForward(t4);
        }
        boundary = t4 == null ? Boundary.infiniteFuture() : Boundary.of(intervalEdge, t4);
        arrayList.add(this.newInterval(boundary2, boundary));
        return this.create(arrayList);
    }

    /*
     * WARNING - void declaration
     */
    public IntervalCollection<T> withSplits() {
        void var5_7;
        if (this.isDisjunct()) {
            return this;
        }
        ArrayList<Boundary<T>> arrayList = new ArrayList<Boundary<T>>();
        Boundary boundary = null;
        Boundary boundary2 = null;
        for (ChronoInterval<T> object2 : this.intervals) {
            int n;
            Boundary<T> boundary3 = object2.getStart();
            Boundary boundary4 = object2.getEnd();
            if (boundary3.isInfinite()) {
                boundary = Boundary.infinitePast();
            } else {
                n = this.searchFiniteBoundary(arrayList, boundary3);
                if (n < 0) {
                    arrayList.add(-n - 1, boundary3);
                }
            }
            if (boundary4.isInfinite()) {
                boundary2 = Boundary.infiniteFuture();
                continue;
            }
            if (boundary4.isClosed()) {
                T t2 = this.getTimeLine().stepForward(boundary4.getTemporal());
                if (t2 == null) {
                    boundary2 = Boundary.infiniteFuture();
                    continue;
                }
                boundary4 = Boundary.ofClosed(t2);
            } else {
                boundary4 = Boundary.ofClosed(boundary4.getTemporal());
            }
            if ((n = this.searchFiniteBoundary(arrayList, boundary4)) >= 0) continue;
            arrayList.add(-n - 1, boundary4);
        }
        ArrayList arrayList2 = new ArrayList();
        Boundary boundary5 = boundary;
        for (Boundary boundary4 : arrayList) {
            Object t3 = boundary4.getTemporal();
            boolean bl = this.encloses(t3);
            if (var5_7 != null) {
                if (this.isCalendrical()) {
                    t3 = this.getTimeLine().stepBackwards(t3);
                    if (t3 != null) {
                        arrayList2.add(this.newInterval((Boundary<T>)var5_7, Boundary.ofClosed(t3)));
                    }
                } else {
                    arrayList2.add(this.newInterval((Boundary<T>)var5_7, Boundary.ofOpen(t3)));
                }
            }
            if (bl) {
                Boundary boundary6 = boundary4;
                continue;
            }
            Object var5_9 = null;
        }
        if (var5_7 != null && boundary2 != null) {
            arrayList2.add(this.newInterval((Boundary<T>)var5_7, boundary2));
        }
        return this.create(arrayList2);
    }

    public IntervalCollection<T> withIntersection() {
        int n = this.intervals.size();
        if (n < 2) {
            return this;
        }
        return this.create(this.intersect(this.intervals));
    }

    public IntervalCollection<T> union(IntervalCollection<T> intervalCollection) {
        return this.plus(intervalCollection).withBlocks();
    }

    public IntervalCollection<T> intersect(IntervalCollection<T> intervalCollection) {
        if (this.isEmpty() || intervalCollection.isEmpty()) {
            List<ChronoInterval<T>> list = Collections.emptyList();
            return this.create(list);
        }
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>();
        for (ChronoInterval<T> chronoInterval : this.intervals) {
            for (ChronoInterval<T> chronoInterval2 : intervalCollection.intervals) {
                List<ChronoInterval<T>> list = new ArrayList<ChronoInterval<T>>(2);
                list.add(chronoInterval);
                list.add(chronoInterval2);
                list.sort(this.getComparator());
                if ((list = this.intersect(list)).isEmpty()) continue;
                arrayList.addAll(list);
            }
        }
        arrayList.sort(this.getComparator());
        return this.create(arrayList).withBlocks();
    }

    public IntervalCollection<T> xor(IntervalCollection<T> intervalCollection) {
        if (this.isEmpty()) {
            return intervalCollection;
        }
        if (intervalCollection.isEmpty()) {
            return this;
        }
        T t2 = this.getMinimum();
        T t3 = this.getMaximum();
        T t4 = intervalCollection.getMinimum();
        T t5 = intervalCollection.getMaximum();
        T t6 = t2 == null || t4 == null ? null : (T)(this.isAfter(t2, t4) ? t4 : t2);
        Object t7 = t3 == null || t5 == null ? null : (Object)(this.isBefore(t3, t5) ? t5 : t3);
        Boundary<Object> boundary = this.createStartBoundary(t6);
        Boundary<Object> boundary2 = t7 == null ? Boundary.infiniteFuture() : (this.isCalendrical() ? Boundary.ofClosed(t7) : ((t7 = this.getTimeLine().stepForward(t7)) == null ? Boundary.infiniteFuture() : Boundary.ofOpen(t7)));
        ChronoInterval<Object> chronoInterval = this.newInterval(boundary, boundary2);
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>();
        IntervalCollection<Object> intervalCollection2 = this.withComplement(chronoInterval).intersect(intervalCollection);
        IntervalCollection<Object> intervalCollection3 = intervalCollection.withComplement(chronoInterval).intersect(this);
        arrayList.addAll(intervalCollection2.getIntervals());
        arrayList.addAll(intervalCollection3.getIntervals());
        arrayList.sort(this.getComparator());
        return this.create(arrayList).withBlocks();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IntervalCollection) {
            IntervalCollection intervalCollection = (IntervalCollection)IntervalCollection.class.cast(object);
            return this.getTimeLine().equals(intervalCollection.getTimeLine()) && this.intervals.equals(intervalCollection.intervals);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.intervals.hashCode();
    }

    @Override
    public String toString() {
        int n = this.intervals.size();
        StringBuilder stringBuilder = new StringBuilder(n * 30);
        stringBuilder.append('{');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.intervals.get(i));
            if (i >= n - 1) continue;
            stringBuilder.append(',');
        }
        return stringBuilder.append('}').toString();
    }

    int getSize() {
        return this.intervals.size();
    }

    abstract Comparator<ChronoInterval<T>> getComparator();

    abstract IntervalCollection<T> create(List<ChronoInterval<T>> var1);

    abstract TimeLine<T> getTimeLine();

    boolean isAfter(T t2, T t3) {
        return this.getTimeLine().compare(t2, t3) > 0;
    }

    boolean isBefore(T t2, T t3) {
        return this.getTimeLine().compare(t2, t3) < 0;
    }

    abstract ChronoInterval<T> newInterval(Boundary<T> var1, Boundary<T> var2);

    boolean isCalendrical() {
        return this.getTimeLine().isCalendrical();
    }

    private ChronoInterval<T> adjust(ChronoInterval<T> chronoInterval) {
        Boundary<T> boundary = chronoInterval.getStart();
        if (boundary.isOpen() && !boundary.isInfinite()) {
            T t2 = this.getTimeLine().stepForward(boundary.getTemporal());
            if (t2 == null) {
                throw new IllegalArgumentException("Interval start with open maximum: " + chronoInterval);
            }
            boundary = Boundary.ofClosed(t2);
            return this.newInterval(boundary, chronoInterval.getEnd());
        }
        return chronoInterval;
    }

    private IntervalCollection<T> withFilter(ChronoInterval<T> chronoInterval) {
        if (chronoInterval.isEmpty()) {
            List<ChronoInterval<T>> list = Collections.emptyList();
            return this.create(list);
        }
        Boundary<T> boundary = chronoInterval.getStart();
        Boundary<T> boundary2 = chronoInterval.getEnd();
        if (this.isEmpty() || boundary.isInfinite() && boundary2.isInfinite()) {
            return this;
        }
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>();
        for (ChronoInterval<T> chronoInterval2 : this.intervals) {
            if (chronoInterval2.isFinite() && chronoInterval.contains(chronoInterval2.getStart().getTemporal()) && chronoInterval.contains(chronoInterval2.getEnd().getTemporal())) {
                arrayList.add(chronoInterval2);
                continue;
            }
            ArrayList<ChronoInterval<T>> arrayList2 = new ArrayList<ChronoInterval<T>>(2);
            arrayList2.add(chronoInterval);
            arrayList2.add(chronoInterval2);
            arrayList2.sort(this.getComparator());
            IntervalCollection<T> intervalCollection = this.create(arrayList2).withIntersection();
            if (intervalCollection.isEmpty()) continue;
            arrayList.add(intervalCollection.getIntervals().get(0));
        }
        return this.create(arrayList);
    }

    private Boundary<T> createStartBoundary(T t2) {
        if (t2 == null) {
            return Boundary.infinitePast();
        }
        return Boundary.ofClosed(t2);
    }

    private void addLeft(List<ChronoInterval<T>> list, T t2) {
        T t3 = this.getTimeLine().stepBackwards(t2);
        if (t3 != null) {
            Boundary<T> boundary = this.isCalendrical() ? Boundary.ofClosed(t3) : Boundary.ofOpen(t2);
            Boundary boundary2 = Boundary.infinitePast();
            list.add(this.newInterval(boundary2, boundary));
        }
    }

    private void addLeft(List<ChronoInterval<T>> list, T t2, T t3) {
        if (this.isBefore(t2, t3)) {
            Boundary<T> boundary = this.isCalendrical() ? Boundary.ofClosed(this.getTimeLine().stepBackwards(t3)) : Boundary.ofOpen(t3);
            Boundary<T> boundary2 = Boundary.ofClosed(t2);
            list.add(this.newInterval(boundary2, boundary));
        }
    }

    private List<ChronoInterval<T>> intersect(List<ChronoInterval<T>> list) {
        Object object;
        Boundary<Object> boundary;
        int n = list.size();
        if (n < 2) {
            return list;
        }
        T t2 = list.get(n - 1).getStart().getTemporal();
        T t3 = null;
        for (int i = 0; i < n; ++i) {
            boundary = list.get(i).getEnd();
            object = boundary.getTemporal();
            if (boundary.isInfinite()) continue;
            if (this.isCalendrical()) {
                if (boundary.isOpen()) {
                    object = this.getTimeLine().stepBackwards(object);
                }
            } else if (boundary.isClosed() && (object = this.getTimeLine().stepForward(object)) == null) continue;
            if (t3 != null && !this.isBefore(object, t3)) continue;
            t3 = object;
        }
        Boundary<T> boundary2 = null;
        boundary = null;
        if (t3 == null) {
            boundary2 = this.createStartBoundary(t2);
            boundary = Boundary.infiniteFuture();
        } else if (this.isCalendrical()) {
            if (!this.isBefore(t3, t2)) {
                boundary2 = this.createStartBoundary(t2);
                boundary = Boundary.ofClosed(t3);
            }
        } else if (this.isAfter(t3, t2)) {
            boundary2 = this.createStartBoundary(t2);
            boundary = Boundary.ofOpen(t3);
        }
        if (boundary2 == null || boundary == null) {
            return Collections.emptyList();
        }
        object = this.newInterval(boundary2, boundary);
        return Collections.singletonList(object);
    }

    private int searchFiniteBoundary(List<Boundary<T>> list, Boundary<T> boundary) {
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            Boundary<T> boundary2 = list.get(n3);
            T t2 = boundary2.getTemporal();
            T t3 = boundary.getTemporal();
            int n4 = this.getTimeLine().compare(t2, t3);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }
}

