/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.time4j.engine.Temporal;
import net.time4j.range.IntervalEdge;
import net.time4j.range.SPX;

public final class Boundary<T>
implements Serializable {
    private static final int NORMAL = 0;
    private static final int PAST = 1;
    private static final int FUTURE = 2;
    private static final Boundary INFINITE_PAST = new Boundary(false);
    private static final Boundary INFINITE_FUTURE = new Boundary(true);
    private static final long serialVersionUID = -8193246842948266154L;
    private final transient int mode;
    private final transient IntervalEdge edge;
    private final transient T temporal;

    private Boundary(boolean bl) {
        this.mode = bl ? 2 : 1;
        this.edge = IntervalEdge.OPEN;
        this.temporal = null;
    }

    private Boundary(IntervalEdge intervalEdge, T t2) {
        if (intervalEdge == null) {
            throw new NullPointerException("Missing boundary type.");
        }
        if (t2 == null) {
            throw new NullPointerException("Missing boundary time.");
        }
        this.mode = 0;
        this.edge = intervalEdge;
        this.temporal = t2;
    }

    public static <T> Boundary<T> infinitePast() {
        return INFINITE_PAST;
    }

    public static <T> Boundary<T> infiniteFuture() {
        return INFINITE_FUTURE;
    }

    public static <T> Boundary<T> ofOpen(T t2) {
        return new Boundary<T>(IntervalEdge.OPEN, t2);
    }

    public static <T> Boundary<T> ofClosed(T t2) {
        return new Boundary<T>(IntervalEdge.CLOSED, t2);
    }

    static <T> Boundary<T> of(IntervalEdge intervalEdge, T t2) {
        return new Boundary<T>(intervalEdge, t2);
    }

    public T getTemporal() {
        return this.temporal;
    }

    public boolean isOpen() {
        return this.edge == IntervalEdge.OPEN;
    }

    public boolean isClosed() {
        return this.edge == IntervalEdge.CLOSED;
    }

    public boolean isInfinite() {
        return this.temporal == null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Boundary) {
            Boundary boundary = (Boundary)Boundary.class.cast(object);
            if (this.edge != boundary.edge || this.mode != boundary.mode) {
                return false;
            }
            if (this.temporal == null) {
                return boundary.temporal == null;
            }
            return this.temporal.equals(boundary.temporal);
        }
        return false;
    }

    public int hashCode() {
        int n = 37 + (this.temporal != null ? this.temporal.hashCode() : 0);
        n = 83 * n + 5 * this.mode;
        return 83 * n + this.edge.hashCode();
    }

    public String toString() {
        if (this.mode == 1) {
            return "(-\u221e)";
        }
        if (this.mode == 2) {
            return "(+\u221e)";
        }
        boolean bl = this.isOpen();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(bl ? (char)'(' : '[');
        stringBuilder.append(this.temporal);
        stringBuilder.append(bl ? (char)')' : ']');
        return stringBuilder.toString();
    }

    IntervalEdge getEdge() {
        return this.edge;
    }

    static <T extends Temporal<? super T>> boolean isAfter(Boundary<T> boundary, Boundary<T> boundary2) {
        if (boundary.mode == 1) {
            return false;
        }
        if (boundary.mode == 2) {
            return boundary2.mode != 2;
        }
        if (boundary2.mode == 1) {
            return true;
        }
        if (boundary2.mode == 2) {
            return false;
        }
        return ((Temporal)boundary.temporal).isAfter(boundary2.temporal);
    }

    static <T extends Temporal<? super T>> boolean isSimultaneous(Boundary<T> boundary, Boundary<T> boundary2) {
        if (boundary.mode == 1) {
            return boundary2.mode == 1;
        }
        if (boundary.mode == 2) {
            return boundary2.mode == 2;
        }
        if (boundary2.mode == 1) {
            return false;
        }
        if (boundary2.mode == 2) {
            return false;
        }
        return ((Temporal)boundary.temporal).isSimultaneous(boundary2.temporal);
    }

    private Object writeReplace() {
        return new SPX(this, 57);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

