/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.Set;
import net.time4j.Moment;
import net.time4j.PlainTimestamp;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BridgeChronology;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.Chronology;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;
import net.time4j.format.expert.PatternType;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionStrategy;

final class StyleProcessor<T>
implements FormatProcessor<T> {
    private final ChronoFormatter<T> formatter;
    private final FormatStyle dateStyle;
    private final FormatStyle timeStyle;

    StyleProcessor(FormatStyle formatStyle, FormatStyle formatStyle2) {
        this(null, formatStyle, formatStyle2);
    }

    private StyleProcessor(ChronoFormatter<T> chronoFormatter, FormatStyle formatStyle, FormatStyle formatStyle2) {
        if (formatStyle == null || formatStyle2 == null) {
            throw new NullPointerException("Missing display style.");
        }
        this.dateStyle = formatStyle;
        this.timeStyle = formatStyle2;
        this.formatter = chronoFormatter;
    }

    @Override
    public int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        ChronoFormatter<T> chronoFormatter = this.getFormatter(attributeQuery, bl, chronoDisplay);
        Set<ElementPosition> set2 = chronoFormatter.print(chronoDisplay, appendable, attributeQuery, set != null);
        if (set != null) {
            assert (set2 != null);
            set.addAll(set2);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl) {
        ChronoFormatter<T> chronoFormatter = this.getFormatter(attributeQuery, bl, null);
        T t2 = chronoFormatter.parse(charSequence, parseLog, attributeQuery);
        if (!parseLog.isError() && t2 != null) {
            parsedEntity.setResult(t2);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof StyleProcessor) {
            StyleProcessor styleProcessor = (StyleProcessor)object;
            if (this.dateStyle == styleProcessor.dateStyle && this.timeStyle == styleProcessor.timeStyle) {
                if (this.formatter == null) {
                    return styleProcessor.formatter == null;
                }
                return this.formatter.equals(styleProcessor.formatter);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.formatter == null ? 0 : this.formatter.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[date-style=");
        stringBuilder.append((Object)this.dateStyle);
        stringBuilder.append(",time-style=");
        stringBuilder.append((Object)this.timeStyle);
        stringBuilder.append(",delegate=");
        stringBuilder.append(this.formatter);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<T> getElement() {
        return null;
    }

    @Override
    public FormatProcessor<T> withElement(ChronoElement<T> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<T> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n) {
        TransitionStrategy transitionStrategy = attributeQuery.get(Attributes.TRANSITION_STRATEGY, Timezone.DEFAULT_CONFLICT_STRATEGY);
        TZID tZID = attributeQuery.get(Attributes.TIMEZONE_ID, null);
        Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        ChronoFormatter<T> chronoFormatter2 = StyleProcessor.createFormatter(chronoFormatter.getChronology(), this.dateStyle, this.timeStyle, locale, attributeQuery.get(Attributes.FOUR_DIGIT_YEAR, Boolean.FALSE), tZID == null ? null : Timezone.of(tZID).with(transitionStrategy), null);
        return new StyleProcessor<T>(chronoFormatter2, this.dateStyle, this.timeStyle);
    }

    FormatStyle getDateStyle() {
        return this.dateStyle;
    }

    String getGeneratedPattern() {
        return this.formatter == null ? "" : this.formatter.getPattern();
    }

    private ChronoFormatter<T> getFormatter(AttributeQuery attributeQuery, boolean bl, ChronoDisplay chronoDisplay) {
        Object object;
        if (bl) {
            if (chronoDisplay == null) {
                return this.formatter;
            }
            if (chronoDisplay instanceof LocalizedPatternSupport && !(object = (LocalizedPatternSupport)LocalizedPatternSupport.class.cast(chronoDisplay)).useDynamicFormatPattern()) {
                return this.formatter;
            }
        }
        object = this.formatter.getAttributes();
        TransitionStrategy transitionStrategy = attributeQuery.get(Attributes.TRANSITION_STRATEGY, object.get(Attributes.TRANSITION_STRATEGY, Timezone.DEFAULT_CONFLICT_STRATEGY));
        TZID tZID = attributeQuery.get(Attributes.TIMEZONE_ID, object.get(Attributes.TIMEZONE_ID, null));
        Timezone timezone = tZID == null ? null : Timezone.of(tZID).with(transitionStrategy);
        return StyleProcessor.createFormatter(this.formatter.getChronology(), this.dateStyle, this.timeStyle, attributeQuery.get(Attributes.LANGUAGE, this.formatter.getLocale()), attributeQuery.get(Attributes.FOUR_DIGIT_YEAR, Boolean.FALSE), timezone, chronoDisplay);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> ChronoFormatter<T> createFormatter(Chronology<?> chronology, FormatStyle formatStyle, FormatStyle formatStyle2, Locale locale, boolean bl, Timezone timezone, ChronoDisplay chronoDisplay) {
        ChronoFormatter chronoFormatter;
        String string;
        if (chronology.equals(PlainTimestamp.axis())) {
            string = CalendarText.patternForTimestamp(formatStyle, formatStyle2, locale);
        } else if (chronology.equals(Moment.axis())) {
            string = CalendarText.patternForMoment(formatStyle, formatStyle2, locale);
        } else if (chronology.getChronoType() == CalendarDate.class) {
            chronoFormatter = chronology;
            while (chronoFormatter instanceof BridgeChronology) {
                chronoFormatter = ((Chronology)((Object)chronoFormatter)).preparser();
            }
            if (!LocalizedPatternSupport.class.isAssignableFrom(((Chronology)((Object)chronoFormatter)).getChronoType())) throw new UnsupportedOperationException("Localized format patterns not available: " + chronology);
            assert (formatStyle == formatStyle2);
            string = ((Chronology)((Object)chronoFormatter)).getFormatPattern(formatStyle, locale);
        } else if (chronoDisplay instanceof LocalizedPatternSupport) {
            assert (formatStyle == formatStyle2);
            string = ((LocalizedPatternSupport)LocalizedPatternSupport.class.cast(chronoDisplay)).getFormatPattern(formatStyle, locale);
        } else {
            if (!LocalizedPatternSupport.class.isAssignableFrom(chronology.getChronoType())) throw new UnsupportedOperationException("Localized format patterns not available: " + chronology);
            assert (formatStyle == formatStyle2);
            string = chronology.getFormatPattern(formatStyle, locale);
        }
        if (bl && string.contains("yy") && !string.contains("yyy")) {
            string = string.replace("yy", "yyyy");
        }
        if (chronology.getChronoType() == CalendarDate.class) {
            return ChronoFormatter.ofGenericCalendarPattern(string, locale);
        }
        chronoFormatter = ChronoFormatter.ofPattern(string, PatternType.CLDR, locale, chronology);
        if (timezone == null) return chronoFormatter;
        return chronoFormatter.with(timezone);
    }
}

