/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.time4j.engine.AbstractDuration;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimeMetric;
import net.time4j.engine.TimePoint;
import net.time4j.engine.TimeSpan;

public abstract class AbstractMetric<U extends ChronoUnit, P extends AbstractDuration<U>>
implements TimeMetric<U, P>,
Comparator<U> {
    private static final int MIO = 1000000;
    private static final double LENGTH_OF_FORTNIGHT = 1209600.0;
    private final List<U> sortedUnits;
    private final boolean normalizing;

    @SafeVarargs
    protected AbstractMetric(boolean bl, U ... UArray) {
        this(Arrays.asList(UArray), bl);
    }

    protected AbstractMetric(boolean bl, Collection<? extends U> collection) {
        this(new ArrayList<U>(collection), bl);
    }

    private AbstractMetric(List<U> list, boolean bl) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Missing units.");
        }
        list.sort(this);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ChronoUnit chronoUnit = (ChronoUnit)list.get(i);
            for (int j = i + 1; j < n; ++j) {
                if (!chronoUnit.equals(list.get(j))) continue;
                throw new IllegalArgumentException("Duplicate unit: " + chronoUnit);
            }
        }
        this.sortedUnits = Collections.unmodifiableList(list);
        this.normalizing = bl;
    }

    @Override
    public int compare(U u, U u2) {
        return Double.compare(u2.getLength(), u.getLength());
    }

    @Override
    public <T extends TimePoint<? super U, T>> P between(T t2, T t3) {
        return this.between(t2, t3, -1);
    }

    private <T extends TimePoint<? super U, T>> P between(T t2, T t3, int n) {
        Object object;
        if (t3.equals(t2)) {
            return this.createEmptyTimeSpan();
        }
        T t4 = t2;
        T t5 = t3;
        boolean bl = false;
        if (t4.compareTo(t5) > 0) {
            object = t4;
            t4 = t3;
            t5 = object;
            bl = true;
        }
        object = new ArrayList(10);
        Chronology chronology = t2.getChronology();
        int n2 = this.sortedUnits.size();
        block0: for (int i = 0; i < n2; ++i) {
            ChronoUnit chronoUnit;
            int n3;
            ChronoUnit chronoUnit2 = (ChronoUnit)this.sortedUnits.get(i);
            if (this.getLength((TimeAxis<? super U, T>)chronology, (U)chronoUnit2) < 1.0 && i < n2 - 1) continue;
            long l = 1L;
            for (n3 = i + 1; n3 < n2 && (l *= this.getFactor((TimeAxis<? super U, T>)chronology, (U)chronoUnit2, (U)(chronoUnit = (ChronoUnit)this.sortedUnits.get(n3)))) < 1000000L && ((TimeAxis)chronology).isConvertible(chronoUnit2, chronoUnit); ++n3) {
                chronoUnit2 = chronoUnit;
            }
            i = n3 - 1;
            long l2 = t4.until(t5, (ChronoUnit)chronoUnit2);
            if (l2 < 0L) {
                throw new IllegalStateException("Implementation error: Cannot compute timespan due to illegal negative timespan amounts.");
            }
            while (l2 > 0L) {
                T t6 = t4.plus(l2, (ChronoUnit)chronoUnit2);
                if (i > n || i == n2 - 1 || ((TimePoint)((TimePoint)t6).minus(l2, (ChronoUnit)chronoUnit2)).equals(t4)) {
                    t4 = t6;
                    object.add(this.resolve(TimeSpan.Item.of(l2, chronoUnit2)));
                    continue block0;
                }
                --l2;
            }
        }
        if (this.normalizing) {
            this.normalize((TimeAxis<? super U, T>)chronology, this.sortedUnits, (List<TimeSpan.Item<U>>)object);
        }
        return this.createTimeSpan((List<TimeSpan.Item<U>>)object, bl);
    }

    @Override
    public TimeMetric<U, P> reversible() {
        return new ReversalMetric(this);
    }

    protected abstract P createEmptyTimeSpan();

    protected abstract P createTimeSpan(List<TimeSpan.Item<U>> var1, boolean var2);

    protected TimeSpan.Item<U> resolve(TimeSpan.Item<U> item) {
        return item;
    }

    private <T extends TimePoint<? super U, T>> void normalize(TimeAxis<? super U, T> timeAxis, List<U> list, List<TimeSpan.Item<U>> list2) {
        Comparator<? super U> comparator = timeAxis.unitComparator();
        for (int i = list.size() - 1; i >= 0; --i) {
            long l;
            long l2;
            TimeSpan.Item<ChronoUnit> item;
            if (i <= 0) continue;
            ChronoUnit chronoUnit = (ChronoUnit)list.get(i);
            ChronoUnit chronoUnit2 = (ChronoUnit)list.get(i - 1);
            long l3 = this.getFactor(timeAxis, chronoUnit2, chronoUnit);
            if (l3 >= 1000000L || !timeAxis.isConvertible(chronoUnit2, chronoUnit) || (item = AbstractMetric.getItem(list2, chronoUnit)) == null || (l2 = (l = item.getAmount()) / l3) <= 0L) continue;
            long l4 = l % l3;
            if (l4 == 0L) {
                AbstractMetric.removeItem(list2, chronoUnit);
            } else {
                AbstractMetric.putItem(list2, comparator, l4, chronoUnit);
            }
            TimeSpan.Item<ChronoUnit> item2 = AbstractMetric.getItem(list2, chronoUnit2);
            if (item2 == null) {
                AbstractMetric.putItem(list2, comparator, l2, chronoUnit2);
                continue;
            }
            AbstractMetric.putItem(list2, comparator, Math.addExact(item2.getAmount(), l2), chronoUnit2);
        }
    }

    private static <U> TimeSpan.Item<U> getItem(List<TimeSpan.Item<U>> list, U u) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            TimeSpan.Item<U> item = list.get(i);
            if (!item.getUnit().equals(u)) continue;
            return item;
        }
        return null;
    }

    private static <U> void putItem(List<TimeSpan.Item<U>> list, Comparator<? super U> comparator, long l, U u) {
        TimeSpan.Item<U> item = TimeSpan.Item.of(l, u);
        int n = 0;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            U u2 = list.get(i).getUnit();
            if (u2.equals(u)) {
                list.set(i, item);
                return;
            }
            if (n != i || comparator.compare(u2, u) >= 0) continue;
            ++n;
        }
        list.add(n, item);
    }

    private static <U> void removeItem(List<TimeSpan.Item<U>> list, U u) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!list.get(i).getUnit().equals(u)) continue;
            list.remove(i);
            return;
        }
    }

    private <T extends TimePoint<? super U, T>> long getFactor(TimeAxis<? super U, T> timeAxis, U u, U u2) {
        double d = this.getLength(timeAxis, u);
        double d2 = this.getLength(timeAxis, u2);
        return Math.round(d / d2);
    }

    private <T extends TimePoint<? super U, T>> double getLength(TimeAxis<? super U, T> timeAxis, U u) {
        return timeAxis.getLength(u);
    }

    private static class ReversalMetric<U extends ChronoUnit, P extends AbstractDuration<U>>
    implements TimeMetric<U, P> {
        private final AbstractMetric<U, P> delegate;
        private final int monthIndex;

        private ReversalMetric(AbstractMetric<U, P> abstractMetric) {
            this.delegate = abstractMetric;
            int n = -1;
            for (int i = ((AbstractMetric)this.delegate).sortedUnits.size() - 1; i >= 0; --i) {
                ChronoUnit chronoUnit = (ChronoUnit)((AbstractMetric)this.delegate).sortedUnits.get(i);
                if (Double.compare(chronoUnit.getLength(), 1209600.0) <= 0) continue;
                n = i;
                break;
            }
            this.monthIndex = n;
        }

        @Override
        public <T extends TimePoint<? super U, T>> P between(T t2, T t3) {
            return (P)((AbstractMetric)this.delegate).between(t2, t3, this.monthIndex);
        }

        @Override
        public TimeMetric<U, P> reversible() {
            return this;
        }
    }
}

