/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.util.List;
import net.time4j.base.MathUtils;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;
import net.time4j.engine.TimeSpan;

public abstract class AbstractDuration<U extends ChronoUnit>
implements TimeSpan<U> {
    private static final int MIO = 1000000;

    @Override
    public boolean contains(U u) {
        for (TimeSpan.Item item : this.getTotalLength()) {
            if (!item.getUnit().equals(u)) continue;
            return item.getAmount() > 0L;
        }
        return false;
    }

    @Override
    public long getPartialAmount(U u) {
        for (TimeSpan.Item item : this.getTotalLength()) {
            if (!item.getUnit().equals(u)) continue;
            return item.getAmount();
        }
        return 0L;
    }

    public abstract AbstractDuration<U> inverse();

    @Override
    public boolean isPositive() {
        return !this.isNegative() && !this.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        List list = this.getTotalLength();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (list.get(i).getAmount() <= 0L) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "PT0S";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isNegative()) {
            stringBuilder.append('-');
        }
        stringBuilder.append('P');
        int n = this.getTotalLength().size();
        for (int i = 0; i < n; ++i) {
            TimeSpan.Item item = this.getTotalLength().get(i);
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(item.getAmount());
            stringBuilder.append('{');
            stringBuilder.append(item.getUnit());
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    @Override
    public final <T extends TimePoint<? super U, T>> T addTo(T t2) {
        return this.add(t2, this, false);
    }

    @Override
    public final <T extends TimePoint<? super U, T>> T subtractFrom(T t2) {
        return this.add(t2, this, true);
    }

    private <T extends TimePoint<? super U, T>> T add(T t2, TimeSpan<U> timeSpan, boolean bl) {
        T t3 = t2;
        Chronology chronology = t2.getChronology();
        List<TimeSpan.Item<U>> list = timeSpan.getTotalLength();
        boolean bl2 = timeSpan.isNegative();
        if (bl) {
            boolean bl3 = bl2 = !timeSpan.isNegative();
        }
        if (bl2) {
            int n = list.size() - 1;
            while (n >= 0) {
                int n2;
                TimeSpan.Item<U> item = list.get(n);
                ChronoUnit chronoUnit = (ChronoUnit)item.getUnit();
                long l = item.getAmount();
                for (n2 = n - 1; n2 >= 0; --n2) {
                    TimeSpan.Item<U> item2 = list.get(n2);
                    ChronoUnit chronoUnit2 = (ChronoUnit)item2.getUnit();
                    long l2 = item2.getAmount();
                    long l3 = AbstractDuration.getFactor(chronology, chronoUnit2, chronoUnit);
                    if (Double.isNaN(l3) || l2 >= Integer.MAX_VALUE || l3 <= 1L || l3 >= 1000000L || !((TimeAxis)chronology).isConvertible(chronoUnit2, chronoUnit)) break;
                    l = MathUtils.safeAdd(l, MathUtils.safeMultiply(l2, l3));
                }
                n = n2;
                t3 = t3.plus(MathUtils.safeNegate(l), (ChronoUnit)chronoUnit);
            }
        } else {
            int n = 0;
            int n3 = list.size();
            while (n < n3) {
                TimeSpan.Item<U> item;
                ChronoUnit chronoUnit;
                long l;
                int n4;
                TimeSpan.Item<U> item3 = list.get(n);
                ChronoUnit chronoUnit3 = (ChronoUnit)item3.getUnit();
                long l4 = item3.getAmount();
                for (n4 = n + 1; n4 < n3 && !Double.isNaN(l = AbstractDuration.getFactor(chronology, chronoUnit3, chronoUnit = (ChronoUnit)(item = list.get(n4)).getUnit())) && l4 < Integer.MAX_VALUE && l > 1L && l < 1000000L && ((TimeAxis)chronology).isConvertible(chronoUnit3, chronoUnit); ++n4) {
                    l4 = MathUtils.safeAdd(item.getAmount(), MathUtils.safeMultiply(l4, l));
                    chronoUnit3 = chronoUnit;
                }
                n = n4;
                t3 = t3.plus(l4, (ChronoUnit)chronoUnit3);
            }
        }
        return t3;
    }

    private static <U> long getFactor(TimeAxis<U, ?> timeAxis, U u, U u2) {
        return Math.round(timeAxis.getLength(u) / timeAxis.getLength(u2));
    }
}

