/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.clock;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ServiceLoader;
import net.time4j.Moment;
import net.time4j.SystemClock;
import net.time4j.clock.NetTimeConnector;
import net.time4j.clock.SntpConfiguration;
import net.time4j.clock.SntpMessage;
import net.time4j.scale.TimeScale;

public class SntpConnector
extends NetTimeConnector<SntpConfiguration> {
    private static final int MIO = 1000000;
    private volatile SntpMessage lastReply = null;

    public SntpConnector() {
        super(SntpConnector.initConfiguration());
    }

    public SntpConnector(SntpConfiguration sntpConfiguration) {
        super(sntpConfiguration);
    }

    public SntpConnector(String string) {
        super(new SimpleNtpConfiguration(string));
    }

    public long currentTimeInMillis() {
        if (!this.isRunning()) {
            Moment moment = this.currentTime();
            return moment.getPosixTime() * 1000L + (long)(moment.getNanosecond() / 1000000);
        }
        long l = SystemClock.MONOTONIC.currentTimeInMillis();
        return l + this.getLastOffset(l * 1000L) / 1000L;
    }

    public long currentTimeInMicros() {
        if (!this.isRunning()) {
            Moment moment = this.currentTime();
            return moment.getPosixTime() * 1000000L + (long)(moment.getNanosecond() / 1000);
        }
        long l = SystemClock.MONOTONIC.currentTimeInMicros();
        return l + this.getLastOffset(l);
    }

    public SntpMessage getLastReply() {
        return this.lastReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Moment doConnect() throws IOException {
        byte by;
        SntpConfiguration sntpConfiguration = (SntpConfiguration)this.getNetTimeConfiguration();
        int n = sntpConfiguration.getRequestCount();
        if (n <= 0) {
            return SystemClock.MONOTONIC.currentTime();
        }
        String string = sntpConfiguration.getTimeServerAddress();
        int n2 = sntpConfiguration.getTimeServerPort();
        int n3 = sntpConfiguration.getConnectionTimeout();
        boolean bl = sntpConfiguration.isNTP4();
        long l = sntpConfiguration.getRequestInterval() * 1000;
        long l2 = 0L;
        long l3 = 0L;
        try (DatagramSocket datagramSocket = null;){
            datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(n3 * 1000);
            for (int i = 1; i <= n; ++i) {
                SntpMessage sntpMessage;
                this.log(null, "Connecting NTP-Server, waiting for reply...");
                InetAddress inetAddress = InetAddress.getByName(string);
                SntpMessage sntpMessage2 = new SntpMessage(bl);
                double d = sntpMessage2.getTransmitTimestamp();
                by = sntpMessage2.getVersion();
                byte[] byArray = sntpMessage2.getBytes();
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n2);
                datagramSocket.send(datagramPacket);
                DatagramPacket datagramPacket2 = new DatagramPacket(byArray, byArray.length);
                datagramSocket.receive(datagramPacket2);
                double d2 = SntpMessage.getLocalTimestamp();
                this.lastReply = sntpMessage = new SntpMessage(datagramPacket2.getData(), d, by);
                if (this.isLogEnabled()) {
                    this.log("NTP-Server connected: ", sntpMessage.toString());
                }
                double d3 = (sntpMessage.getReceiveTimestamp() - sntpMessage.getOriginateTimestamp() + sntpMessage.getTransmitTimestamp() - d2) / 2.0;
                l2 = (long)((double)l2 + d3 * 1000000.0);
                l3 = l2 / (long)i;
                if (sntpMessage.getStratum() == 0) {
                    this.log("NTP-Server replied: ", "<kiss-o'-death>");
                    break;
                }
                if (i <= 1 || i >= n) continue;
                try {
                    Thread.sleep(l);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    this.log(null, "NTP-Connection interrupted.");
                    break;
                }
            }
        }
        long l4 = SystemClock.MONOTONIC.currentTimeInMicros() + l3;
        long l5 = l4 / 1000000L;
        int n4 = (int)(l4 % 1000000L * 1000L);
        by = this.lastReply.getLeapIndicator();
        if (by == 3) {
            throw new IOException("Alarm condition: NTP-Server is not synchronized with any clock source.");
        }
        if (by == 1) {
            this.log(null, "Positive leap second announced.");
        } else if (by == 2) {
            this.log(null, "Negative leap second announced.");
        }
        return Moment.of(l5, n4, TimeScale.POSIX);
    }

    @Override
    protected SntpConfiguration loadNetTimeConfiguration() {
        SntpConfiguration sntpConfiguration = (SntpConfiguration)super.loadNetTimeConfiguration();
        short s2 = sntpConfiguration.getRequestCount();
        int n = sntpConfiguration.getRequestInterval();
        if (s2 < 0 || s2 >= 1000) {
            throw new IllegalStateException("Wrong request count: " + s2);
        }
        if (n <= 0) {
            throw new IllegalStateException("Wrong request interval.");
        }
        return sntpConfiguration;
    }

    @Override
    protected Class<SntpConfiguration> getConfigurationType() {
        return SntpConfiguration.class;
    }

    private static SntpConfiguration initConfiguration() {
        ServiceLoader<SntpConfiguration> serviceLoader = ServiceLoader.load(SntpConfiguration.class);
        for (SntpConfiguration sntpConfiguration : serviceLoader) {
            if (sntpConfiguration == null) continue;
            return sntpConfiguration;
        }
        throw new IllegalStateException("SNTP-configuration not found.");
    }

    private static class SimpleNtpConfiguration
    implements SntpConfiguration {
        private final String server;

        SimpleNtpConfiguration(String string) {
            if (string == null) {
                throw new NullPointerException("Missing time server address.");
            }
            this.server = string;
        }

        @Override
        public String getTimeServerAddress() {
            return this.server;
        }

        @Override
        public int getTimeServerPort() {
            return 123;
        }

        @Override
        public int getConnectionTimeout() {
            return 60;
        }

        @Override
        public boolean isNTP4() {
            return true;
        }

        @Override
        public int getRequestInterval() {
            return 240;
        }

        @Override
        public short getRequestCount() {
            return 1;
        }

        @Override
        public int getClockShiftWindow() {
            return 0;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SimpleNtpConfiguration:[server=");
            stringBuilder.append(this.server);
            stringBuilder.append(",port=");
            stringBuilder.append(this.getTimeServerPort());
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

