/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.clock;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import net.time4j.Moment;
import net.time4j.TemporalType;
import net.time4j.base.MathUtils;
import net.time4j.clock.NetTimeConfiguration;
import net.time4j.clock.NetTimeConnector;

public class HttpClock
extends NetTimeConnector<NetTimeConfiguration> {
    public HttpClock(String string) {
        super(new SimpleHttpConfiguration(string));
    }

    @Override
    protected Moment doConnect() throws IOException, ParseException {
        Object c = this.getNetTimeConfiguration();
        URL uRL = new URL(c.getTimeServerAddress());
        int n = MathUtils.safeMultiply(c.getConnectionTimeout(), 1000);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(n);
        httpURLConnection.setReadTimeout(n);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestMethod("HEAD");
        int n2 = httpURLConnection.getResponseCode();
        if (n2 >= 200 && n2 <= 399) {
            return TemporalType.JAVA_UTIL_DATE.translate(new Date(httpURLConnection.getDate()));
        }
        throw new IOException("HTTP server status: " + n2);
    }

    @Override
    protected Class<NetTimeConfiguration> getConfigurationType() {
        return NetTimeConfiguration.class;
    }

    private static class SimpleHttpConfiguration
    implements NetTimeConfiguration {
        private final String server;

        SimpleHttpConfiguration(String string) {
            this.server = !string.startsWith("http") ? "http://" + string : string;
        }

        @Override
        public String getTimeServerAddress() {
            return this.server;
        }

        @Override
        public int getTimeServerPort() {
            return this.server.startsWith("https:") ? 443 : 80;
        }

        @Override
        public int getConnectionTimeout() {
            return 60;
        }

        @Override
        public int getClockShiftWindow() {
            return 0;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SimpleHttpConfiguration:[server=");
            stringBuilder.append(this.server);
            stringBuilder.append(",port=");
            stringBuilder.append(this.getTimeServerPort());
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

