/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.frenchrev;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import net.time4j.calendar.frenchrev.FrenchRepublicanCalendar;
import net.time4j.calendar.frenchrev.Sansculottides;

final class SPX
implements Externalizable {
    static final int FRENCH_REV = 18;
    private static final long serialVersionUID = 1L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n) {
        this.obj = object;
        this.type = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.type);
        switch (this.type) {
            case 18: {
                this.writeFrenchRev(objectOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unsupported calendar type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        switch (by) {
            case 18: {
                this.obj = this.readFrenchRev(objectInput);
                break;
            }
            default: {
                throw new InvalidObjectException("Unknown calendar type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }

    private void writeFrenchRev(ObjectOutput objectOutput) throws IOException {
        FrenchRepublicanCalendar frenchRepublicanCalendar = (FrenchRepublicanCalendar)this.obj;
        objectOutput.writeInt(frenchRepublicanCalendar.getYear());
        objectOutput.writeShort(frenchRepublicanCalendar.getDayOfYear());
    }

    private FrenchRepublicanCalendar readFrenchRev(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        short s2 = objectInput.readShort();
        if (s2 <= 360) {
            int n2 = (s2 - 1) / 30 + 1;
            int n3 = (s2 - 1) % 30 + 1;
            return FrenchRepublicanCalendar.of(n, n2, n3);
        }
        Sansculottides sansculottides = Sansculottides.valueOf(s2 - 360);
        return FrenchRepublicanCalendar.of(n, sansculottides);
    }
}

