/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.base;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.time4j.calendar.service.GenericCalendarProviderSPI;
import net.time4j.calendar.service.GenericTextProviderSPI;
import net.time4j.calendar.service.KoreanExtension;
import net.time4j.engine.CalendarProvider;
import net.time4j.engine.ChronoExtension;
import net.time4j.format.TextProvider;
import net.time4j.format.internal.IsoTextProviderSPI;
import net.time4j.history.internal.HistoricExtension;
import net.time4j.tz.ZoneModelProvider;
import net.time4j.tz.ZoneNameProvider;
import net.time4j.tz.spi.MilZoneProviderSPI;
import net.time4j.tz.spi.WinZoneProviderSPI;
import net.time4j.tz.spi.ZoneNameProviderSPI;
import net.time4j.tz.threeten.JdkZoneProviderSPI;

public abstract class ResourceLoader {
    public static final String EXTERNAL_RESOURCE_LOADER = "net.time4j.base.ResourceLoader";
    public static final String USE_OF_CLASSLOADER_ONLY = "net.time4j.base.useClassloaderOnly";
    private static final boolean ANDROID = "Dalvik".equalsIgnoreCase(System.getProperty("java.vm.name"));
    private static final ResourceLoader INSTANCE;
    private static final boolean ENFORCE_USE_OF_CLASSLOADER;
    private static final Map<Class<?>, List<Object>> REGISTERED_SERVICES;

    protected ResourceLoader() {
    }

    public static ResourceLoader getInstance() {
        return INSTANCE;
    }

    public abstract URI locate(String var1, Class<?> var2, String var3);

    public abstract InputStream load(URI var1, boolean var2);

    public final InputStream load(Class<?> clazz, String string, boolean bl) throws IOException {
        if (ANDROID) {
            throw new FileNotFoundException(string);
        }
        URL uRL = clazz.getClassLoader().getResource(string);
        if (uRL == null) {
            throw new FileNotFoundException(string);
        }
        if (bl) {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.connect();
            return uRLConnection.getInputStream();
        }
        return uRL.openStream();
    }

    public abstract <S> Iterable<S> services(Class<S> var1);

    public synchronized <S> void registerService(Class<S> clazz, S s2) {
        if (this.getClass() != StdResourceLoader.class) {
            throw new IllegalStateException("Can only be called on standard resource loader.");
        }
        List<Object> list = REGISTERED_SERVICES.get(clazz);
        if (list == null) {
            list = new CopyOnWriteArrayList<Object>();
        }
        if (list.contains(s2)) {
            throw new IllegalStateException("Service already registered: " + s2);
        }
        list.add(s2);
        REGISTERED_SERVICES.put(clazz, list);
    }

    static {
        ENFORCE_USE_OF_CLASSLOADER = !ANDROID && Boolean.getBoolean(USE_OF_CLASSLOADER_ONLY);
        REGISTERED_SERVICES = new ConcurrentHashMap();
        String string = System.getProperty(EXTERNAL_RESOURCE_LOADER);
        if (string == null) {
            INSTANCE = new StdResourceLoader();
        } else {
            try {
                INSTANCE = (ResourceLoader)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new AssertionError((Object)("Wrong configuration of external resource loader: " + exception.getMessage()));
            }
        }
    }

    private static class StdResourceLoader
    extends ResourceLoader {
        StdResourceLoader() {
            if (ANDROID) {
                throw new IllegalStateException("The module time4j-android is not active. Check your configuration.");
            }
        }

        @Override
        public URI locate(String string, Class<?> clazz, String string2) {
            String string3 = null;
            try {
                CodeSource codeSource;
                ProtectionDomain protectionDomain = clazz.getProtectionDomain();
                CodeSource codeSource2 = codeSource = protectionDomain == null ? null : protectionDomain.getCodeSource();
                if (codeSource != null) {
                    string3 = codeSource.getLocation().toExternalForm();
                    if (string3.endsWith(".jar")) {
                        string3 = "jar:" + string3 + "!/";
                    }
                    string3 = string3 + string2;
                    return new URI(string3.replace('\\', '/'));
                }
            }
            catch (SecurityException securityException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                System.err.println("Warning: malformed resource path = " + string3);
            }
            return null;
        }

        @Override
        public InputStream load(URI uRI, boolean bl) {
            if (uRI == null || ENFORCE_USE_OF_CLASSLOADER) {
                return null;
            }
            try {
                URL uRL = uRI.toURL();
                if (bl) {
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setUseCaches(false);
                    uRLConnection.connect();
                    return uRLConnection.getInputStream();
                }
                return uRL.openStream();
            }
            catch (IOException | RuntimeException exception) {
                if (uRI.toString().contains(".repository")) {
                    System.err.println("Warning: Loading of resource " + uRI + " failed (" + exception.getMessage() + "). Consider setting the system property \"" + ResourceLoader.USE_OF_CLASSLOADER_ONLY + "\" for reducing overhead.");
                    exception.printStackTrace(System.err);
                }
                return null;
            }
        }

        @Override
        public <S> Iterable<S> services(Class<S> clazz) {
            LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
            List list = (List)REGISTERED_SERVICES.get(clazz);
            if (list != null) {
                for (Iterator iterator : list) {
                    linkedHashSet.add(clazz.cast(iterator));
                }
            }
            for (Iterator iterator : ServiceLoader.load(clazz, clazz.getClassLoader())) {
                linkedHashSet.add(iterator);
            }
            List list2 = (List)InternalServices.MAP.get(clazz);
            if (list2 != null) {
                Iterator iterator;
                iterator = list2.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    linkedHashSet.add(clazz.cast(e));
                }
            }
            return linkedHashSet;
        }
    }

    private static class InternalServices {
        private static final Map<Class<?>, List<?>> MAP;

        private InternalServices() {
        }

        static {
            HashMap<Class<ZoneNameProvider>, List<Object>> hashMap = new HashMap<Class<ZoneNameProvider>, List<Object>>();
            hashMap.put(CalendarProvider.class, Collections.singletonList(new GenericCalendarProviderSPI()));
            hashMap.put(ChronoExtension.class, Arrays.asList(new HistoricExtension(), new KoreanExtension()));
            hashMap.put(TextProvider.class, Arrays.asList(IsoTextProviderSPI.SINGLETON, new GenericTextProviderSPI()));
            hashMap.put(ZoneModelProvider.class, Arrays.asList(new JdkZoneProviderSPI(), new WinZoneProviderSPI(), new MilZoneProviderSPI()));
            hashMap.put(ZoneNameProvider.class, Collections.singletonList(new ZoneNameProviderSPI()));
            MAP = Collections.unmodifiableMap(hashMap);
        }
    }
}

