/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.IsoDateUnit;
import net.time4j.OverflowUnit;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.Weekcycle;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.TimePoint;
import net.time4j.engine.UnitRule;

public enum CalendarUnit implements IsoDateUnit
{
    MILLENNIA{

        @Override
        public char getSymbol() {
            return 'I';
        }

        @Override
        public double getLength() {
            return 3.1556952E10;
        }
    }
    ,
    CENTURIES{

        @Override
        public char getSymbol() {
            return 'C';
        }

        @Override
        public double getLength() {
            return 3.1556952E9;
        }
    }
    ,
    DECADES{

        @Override
        public char getSymbol() {
            return 'E';
        }

        @Override
        public double getLength() {
            return 3.1556952E8;
        }
    }
    ,
    YEARS{

        @Override
        public char getSymbol() {
            return 'Y';
        }

        @Override
        public double getLength() {
            return 3.1556952E7;
        }
    }
    ,
    QUARTERS{

        @Override
        public char getSymbol() {
            return 'Q';
        }

        @Override
        public double getLength() {
            return 7889238.0;
        }
    }
    ,
    MONTHS{

        @Override
        public char getSymbol() {
            return 'M';
        }

        @Override
        public double getLength() {
            return 2629746.0;
        }
    }
    ,
    WEEKS{

        @Override
        public char getSymbol() {
            return 'W';
        }

        @Override
        public double getLength() {
            return 604800.0;
        }
    }
    ,
    DAYS{

        @Override
        public char getSymbol() {
            return 'D';
        }

        @Override
        public double getLength() {
            return 86400.0;
        }
    };

    private final IsoDateUnit eof = new OverflowUnit(this, 2);
    private final IsoDateUnit kld = new OverflowUnit(this, 5);
    private final IsoDateUnit ui = new OverflowUnit(this, 4);
    private final IsoDateUnit nvd = new OverflowUnit(this, 1);
    private final IsoDateUnit co = new OverflowUnit(this, 3);
    private final IsoDateUnit joda = new OverflowUnit(this, 6);

    public <T extends TimePoint<? super CalendarUnit, T>> long between(T t2, T t3) {
        return t2.until(t3, (CalendarUnit)this);
    }

    @Override
    public boolean isCalendrical() {
        return true;
    }

    public IsoDateUnit nextValidDate() {
        switch (this) {
            case WEEKS: 
            case DAYS: {
                return this;
            }
        }
        return this.nvd;
    }

    public IsoDateUnit withCarryOver() {
        switch (this) {
            case WEEKS: 
            case DAYS: {
                return this;
            }
        }
        return this.co;
    }

    public IsoDateUnit unlessInvalid() {
        switch (this) {
            case WEEKS: 
            case DAYS: {
                return this;
            }
        }
        return this.ui;
    }

    public IsoDateUnit atEndOfMonth() {
        switch (this) {
            case WEEKS: 
            case DAYS: {
                throw new UnsupportedOperationException("Original unit is not month-based: " + this.name());
            }
        }
        return this.eof;
    }

    public IsoDateUnit keepingEndOfMonth() {
        switch (this) {
            case WEEKS: 
            case DAYS: {
                throw new UnsupportedOperationException("Original unit is not month-based: " + this.name());
            }
        }
        return this.kld;
    }

    public IsoDateUnit withJodaMetric() {
        switch (this) {
            case WEEKS: 
            case DAYS: {
                return this;
            }
        }
        return this.joda;
    }

    public static IsoDateUnit weekBasedYears() {
        return Weekcycle.YEARS;
    }

    static class Rule<T extends ChronoEntity<T>>
    implements UnitRule<T> {
        private final CalendarUnit unit;
        private final int policy;

        Rule(CalendarUnit calendarUnit) {
            this(calendarUnit, 0);
        }

        Rule(CalendarUnit calendarUnit, int n) {
            this.unit = calendarUnit;
            this.policy = n;
        }

        @Override
        public T addTo(T t2, long l) {
            PlainDate plainDate = ((ChronoEntity)t2).get(PlainDate.CALENDAR_DATE);
            plainDate = PlainDate.doAdd(this.unit, plainDate, l, this.policy);
            return ((ChronoEntity)t2).with(PlainDate.CALENDAR_DATE, (PlainDate)plainDate);
        }

        @Override
        public long between(T t2, T t3) {
            long l;
            PlainDate plainDate = ((ChronoEntity)t2).get(PlainDate.CALENDAR_DATE);
            PlainDate plainDate2 = ((ChronoEntity)t3).get(PlainDate.CALENDAR_DATE);
            switch (this.unit) {
                case MILLENNIA: {
                    l = this.monthDelta(plainDate, plainDate2) / 12000L;
                    break;
                }
                case CENTURIES: {
                    l = this.monthDelta(plainDate, plainDate2) / 1200L;
                    break;
                }
                case DECADES: {
                    l = this.monthDelta(plainDate, plainDate2) / 120L;
                    break;
                }
                case YEARS: {
                    l = this.monthDelta(plainDate, plainDate2) / 12L;
                    break;
                }
                case QUARTERS: {
                    l = this.monthDelta(plainDate, plainDate2) / 3L;
                    break;
                }
                case MONTHS: {
                    l = this.monthDelta(plainDate, plainDate2);
                    break;
                }
                case WEEKS: {
                    l = Rule.dayDelta(plainDate, plainDate2) / 7L;
                    break;
                }
                case DAYS: {
                    l = Rule.dayDelta(plainDate, plainDate2);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.unit.name());
                }
            }
            if (l != 0L && ((ChronoEntity)t2).contains(PlainTime.WALL_TIME) && ((ChronoEntity)t3).contains(PlainTime.WALL_TIME)) {
                TimePoint timePoint;
                boolean bl;
                if (this.unit == DAYS) {
                    bl = true;
                } else {
                    timePoint = plainDate.plus(l, this.unit);
                    boolean bl2 = bl = ((PlainDate)timePoint).compareByTime(plainDate2) == 0;
                }
                if (bl) {
                    timePoint = ((ChronoEntity)t2).get(PlainTime.WALL_TIME);
                    PlainTime plainTime = ((ChronoEntity)t3).get(PlainTime.WALL_TIME);
                    if (l > 0L && ((PlainTime)timePoint).isAfter(plainTime)) {
                        --l;
                    } else if (l < 0L && ((PlainTime)timePoint).isBefore(plainTime)) {
                        ++l;
                    }
                }
            }
            return l;
        }

        private long monthDelta(PlainDate plainDate, PlainDate plainDate2) {
            long l = plainDate2.getEpochMonths() - plainDate.getEpochMonths();
            if (this.policy == 5 || this.policy == 2 || this.policy == 6) {
                CalendarUnit calendarUnit = MONTHS;
                if (l > 0L && PlainDate.doAdd(calendarUnit, plainDate, l, this.policy).isAfter(plainDate2)) {
                    --l;
                } else if (l < 0L && PlainDate.doAdd(calendarUnit, plainDate, l, this.policy).isBefore(plainDate2)) {
                    ++l;
                }
            } else if (l > 0L && plainDate2.getDayOfMonth() < plainDate.getDayOfMonth()) {
                --l;
            } else if (l < 0L && plainDate2.getDayOfMonth() > plainDate.getDayOfMonth()) {
                ++l;
            }
            return l;
        }

        private static long dayDelta(PlainDate plainDate, PlainDate plainDate2) {
            if (plainDate.getYear() == plainDate2.getYear()) {
                return plainDate2.getDayOfYear() - plainDate.getDayOfYear();
            }
            return plainDate2.getDaysSinceUTC() - plainDate.getDaysSinceUTC();
        }
    }
}

