/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.ResourceBundle;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.util.LiquibaseUtil;
import liquibase.util.SystemUtil;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class Banner {
    private String version = LiquibaseUtil.getBuildVersionInfo();
    private String build;
    private String built = LiquibaseUtil.getBuildTime();
    private String javaVersion;
    private String path;
    private String licensee;
    private String licenseEndDate;

    public Banner() {
        this.build = LiquibaseUtil.getBuildNumber();
        this.javaVersion = SystemUtil.getJavaVersion();
    }

    public String toString() {
        StringBuilder banner = new StringBuilder();
        if (GlobalConfiguration.SHOW_BANNER.getCurrentValue().booleanValue()) {
            Class<CommandLineUtils> commandLinUtilsClass = CommandLineUtils.class;
            InputStream inputStream = commandLinUtilsClass.getResourceAsStream("/liquibase/banner.txt");
            try {
                banner.append(IOUtils.toString(inputStream, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                Scope.getCurrentScope().getLog(commandLinUtilsClass).fine("Unable to locate banner file.");
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
        banner.append(String.format(coreBundle.getString("starting.liquibase.at.timestamp"), dateFormat.format(calendar.getTime()), this.javaVersion));
        if (StringUtils.isNotEmpty(this.version) && StringUtils.isNotEmpty(this.built)) {
            this.version = this.version + " #" + this.build;
            banner.append(String.format(coreBundle.getString("liquibase.version.builddate"), this.version, this.built));
        }
        return banner.toString();
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getBuild() {
        return this.build;
    }

    @Generated
    public String getBuilt() {
        return this.built;
    }

    @Generated
    public String getJavaVersion() {
        return this.javaVersion;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getLicensee() {
        return this.licensee;
    }

    @Generated
    public String getLicenseEndDate() {
        return this.licenseEndDate;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setBuild(String build) {
        this.build = build;
    }

    @Generated
    public void setBuilt(String built) {
        this.built = built;
    }

    @Generated
    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setLicensee(String licensee) {
        this.licensee = licensee;
    }

    @Generated
    public void setLicenseEndDate(String licenseEndDate) {
        this.licenseEndDate = licenseEndDate;
    }
}

