/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.wktparser;

import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.InvalidToken;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.Token;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.TokenSource;
import java.util.BitSet;
import java.util.EnumSet;

public class WLexer
extends TokenSource {
    LexicalState lexicalState = LexicalState.values()[0];
    EnumSet<Token.TokenType> activeTokenTypes = EnumSet.allOf(Token.TokenType.class);
    static final EnumSet<Token.TokenType> regularTokens = EnumSet.of(Token.TokenType.EOF, new Token.TokenType[]{Token.TokenType.LB, Token.TokenType.RB, Token.TokenType.COMMA, Token.TokenType.ZaM, Token.TokenType.POINT, Token.TokenType.MULTIPOINT, Token.TokenType.LINESTRING, Token.TokenType.MULTILINESTRING, Token.TokenType.POLYGON, Token.TokenType.MULTIPOLYGON, Token.TokenType.TRIANGLE, Token.TokenType.TIN, Token.TokenType.POLYHEDRALSURFACE, Token.TokenType.GEOMETRYCOLLECTION, Token.TokenType.DOUBLE, Token.TokenType.ZoM});
    private static final EnumSet<Token.TokenType> unparsedTokens = EnumSet.noneOf(Token.TokenType.class);
    static final EnumSet<Token.TokenType> skippedTokens = EnumSet.of(Token.TokenType._TOKEN_1, Token.TokenType._TOKEN_2, Token.TokenType._TOKEN_3, Token.TokenType._TOKEN_4);
    private static final EnumSet<Token.TokenType> moreTokens = EnumSet.noneOf(Token.TokenType.class);
    private static NfaFunction[] nfaFunctions;

    public WLexer(CharSequence input) {
        this("input", input);
    }

    public WLexer(String inputSource, CharSequence input) {
        this(inputSource, input, LexicalState.DEFAULT, 1, 1);
    }

    public WLexer(String inputSource, CharSequence input, LexicalState lexState, int startingLine, int startingColumn) {
        super(inputSource, input, startingLine, startingColumn, 1, true, true, false, "");
        if (this.lexicalState != null) {
            this.switchTo(lexState);
        }
    }

    public Token getNextToken(Token tok) {
        if (tok == null) {
            tok = this.tokenizeAt(0);
            this.cacheToken(tok);
            return tok;
        }
        Token cachedToken = tok.nextCachedToken();
        if (cachedToken != null && this.activeTokenTypes != null && !this.activeTokenTypes.contains(cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        if (cachedToken == null) {
            Token token = this.tokenizeAt(tok.getEndOffset());
            this.cacheToken(token);
            return token;
        }
        return cachedToken;
    }

    static MatchInfo getMatchInfo(CharSequence input, int position, EnumSet<Token.TokenType> activeTokenTypes, NfaFunction[] nfaFunctions) {
        if (position >= input.length()) {
            return new MatchInfo(Token.TokenType.EOF, 0);
        }
        int start = position;
        int matchLength = 0;
        Token.TokenType matchedType = Token.TokenType.INVALID;
        BitSet currentStates = new BitSet(125);
        BitSet nextStates = new BitSet(125);
        do {
            int curChar;
            if (position > start) {
                BitSet temp = currentStates;
                currentStates = nextStates;
                nextStates = temp;
                nextStates.clear();
            } else {
                currentStates.set(0);
            }
            if (position >= input.length()) break;
            if ((curChar = Character.codePointAt(input, position++)) > 65535) {
                ++position;
            }
            int nextActive = currentStates.nextSetBit(0);
            while (nextActive != -1) {
                Token.TokenType returnedType = nfaFunctions[nextActive].apply(curChar, nextStates, activeTokenTypes);
                if (returnedType != null && (position - start > matchLength || returnedType.ordinal() < matchedType.ordinal())) {
                    matchedType = returnedType;
                    matchLength = position - start;
                }
                nextActive = currentStates.nextSetBit(nextActive + 1);
            }
        } while (position < input.length() && !nextStates.isEmpty());
        return new MatchInfo(matchedType, matchLength);
    }

    final Token tokenizeAt(int position) {
        int tokenBeginOffset = position;
        boolean inMore = false;
        StringBuilder invalidChars = null;
        Token matchedToken = null;
        Token.TokenType matchedType = null;
        while (matchedToken == null) {
            if (!inMore) {
                tokenBeginOffset = position;
            }
            MatchInfo matchInfo = WLexer.getMatchInfo(this, position, this.activeTokenTypes, nfaFunctions);
            matchedType = matchInfo.matchedType;
            inMore = moreTokens.contains(matchedType);
            position += matchInfo.matchLength;
            if (matchedType == Token.TokenType.INVALID) {
                if (invalidChars == null) {
                    invalidChars = new StringBuilder();
                }
                int cp = Character.codePointAt(this, tokenBeginOffset);
                invalidChars.appendCodePoint(cp);
                ++position;
                if (cp <= 65535) continue;
                ++position;
                continue;
            }
            if (invalidChars != null) {
                return new InvalidToken(this, tokenBeginOffset - invalidChars.length(), tokenBeginOffset);
            }
            if (skippedTokens.contains(matchedType)) {
                this.skipTokens(tokenBeginOffset, position);
                continue;
            }
            if (!regularTokens.contains(matchedType) && !unparsedTokens.contains(matchedType)) continue;
            matchedToken = Token.newToken(matchedType, this, tokenBeginOffset, position);
            matchedToken.setUnparsed(!regularTokens.contains(matchedType));
        }
        return matchedToken;
    }

    public boolean switchTo(LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(Token t2, LexicalState state) {
        this.uncacheTokens(t2);
        if (state != null) {
            this.switchTo(state);
        }
    }

    void reset(Token t2) {
        this.reset(t2, null);
    }

    void cacheToken(Token tok) {
        this.cacheTokenAt(tok, tok.getBeginOffset());
    }

    static {
        DEFAULT.NFA_FUNCTIONS_init();
    }

    public static enum LexicalState {
        DEFAULT;

    }

    static class MatchInfo {
        Token.TokenType matchedType;
        int matchLength;

        MatchInfo(Token.TokenType matchedType, int matchLength) {
            this.matchedType = matchedType;
            this.matchLength = matchLength;
        }
    }

    static interface NfaFunction {
        public Token.TokenType apply(int var1, BitSet var2, EnumSet<Token.TokenType> var3);
    }

    private static class DEFAULT {
        private DEFAULT() {
        }

        private static Token.TokenType getNfaIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(63);
            } else if (ch == 46) {
                nextStates.set(29);
            } else if (ch == 71 || ch == 103) {
                nextStates.set(64);
            } else if (ch == 76 || ch == 108) {
                nextStates.set(3);
            } else if (ch == 77 || ch == 109) {
                nextStates.set(20);
                nextStates.set(34);
                nextStates.set(48);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(14);
                nextStates.set(59);
                nextStates.set(81);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(12);
                nextStates.set(97);
            } else if (ch == 90 || ch == 122) {
                nextStates.set(33);
            }
            if (ch == 77 || ch == 109) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ZoM)) {
                    type = Token.TokenType.ZoM;
                }
            } else if (ch == 90 || ch == 122) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ZoM)) {
                    type = Token.TokenType.ZoM;
                }
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(1);
                if (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE)) {
                    type = Token.TokenType.DOUBLE;
                }
            } else if (ch == 44) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COMMA)) {
                    type = Token.TokenType.COMMA;
                }
            } else if (ch == 41) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RB)) {
                    type = Token.TokenType.RB;
                }
            } else if (ch == 40) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LB)) {
                    type = Token.TokenType.LB;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_4)) {
                    type = Token.TokenType._TOKEN_4;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_3)) {
                    type = Token.TokenType._TOKEN_3;
                }
            } else if (ch == 9) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_2)) {
                    type = Token.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_1))) {
                type = Token.TokenType._TOKEN_1;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(2);
                if (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE)) {
                    type = Token.TokenType.DOUBLE;
                }
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(1);
                if (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE)) {
                    type = Token.TokenType.DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(2);
                if (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE)) {
                    type = Token.TokenType.DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(4);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(5);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(6);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(7);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(8);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(9);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(10);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(11);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 71 && ch != 103 || validTypes != null && !validTypes.contains(Token.TokenType.LINESTRING))) {
                type = Token.TokenType.LINESTRING;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(13);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 78 && ch != 110 || validTypes != null && !validTypes.contains(Token.TokenType.TIN))) {
                type = Token.TokenType.TIN;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(15);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(16);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 89 || ch == 121) {
                nextStates.set(17);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 71 || ch == 103) {
                nextStates.set(18);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(19);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 78 && ch != 110 || validTypes != null && !validTypes.contains(Token.TokenType.POLYGON))) {
                type = Token.TokenType.POLYGON;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(21);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(22);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(23);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(24);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(25);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(26);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(27);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(28);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 84 && ch != 116 || validTypes != null && !validTypes.contains(Token.TokenType.MULTIPOINT))) {
                type = Token.TokenType.MULTIPOINT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(30);
                if (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE)) {
                    type = Token.TokenType.DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaIndex30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(31);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(30);
                if (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE)) {
                    type = Token.TokenType.DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaIndex31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(32);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(32);
                if (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE)) {
                    type = Token.TokenType.DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaIndex32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(32);
                if (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE)) {
                    type = Token.TokenType.DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaIndex33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 77 && ch != 109 || validTypes != null && !validTypes.contains(Token.TokenType.ZaM))) {
                type = Token.TokenType.ZaM;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(35);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(36);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(37);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(38);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(39);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(40);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(41);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(42);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(43);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(44);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(45);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex45(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(46);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex46(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(47);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex47(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 71 && ch != 103 || validTypes != null && !validTypes.contains(Token.TokenType.MULTILINESTRING))) {
                type = Token.TokenType.MULTILINESTRING;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex48(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(49);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex49(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(50);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex50(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(51);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex51(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(52);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex52(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(53);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex53(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(54);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex54(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(55);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex55(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 89 || ch == 121) {
                nextStates.set(56);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex56(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 71 || ch == 103) {
                nextStates.set(57);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex57(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(58);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex58(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 78 && ch != 110 || validTypes != null && !validTypes.contains(Token.TokenType.MULTIPOLYGON))) {
                type = Token.TokenType.MULTIPOLYGON;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex59(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(60);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex60(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(61);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex61(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(62);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex62(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 84 && ch != 116 || validTypes != null && !validTypes.contains(Token.TokenType.POINT))) {
                type = Token.TokenType.POINT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex63(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(1);
                if (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE)) {
                    type = Token.TokenType.DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaIndex64(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(65);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex65(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(66);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex66(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77 || ch == 109) {
                nextStates.set(67);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex67(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(68);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex68(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(69);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex69(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(70);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex70(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 89 || ch == 121) {
                nextStates.set(71);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex71(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(72);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex72(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(73);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex73(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(74);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex74(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(75);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex75(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(76);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex76(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(77);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex77(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(78);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex78(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(79);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex79(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(80);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex80(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 78 && ch != 110 || validTypes != null && !validTypes.contains(Token.TokenType.GEOMETRYCOLLECTION))) {
                type = Token.TokenType.GEOMETRYCOLLECTION;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex81(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(82);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex82(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(83);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex83(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 89 || ch == 121) {
                nextStates.set(84);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex84(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 72 || ch == 104) {
                nextStates.set(85);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex85(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(86);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex86(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(87);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex87(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(88);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex88(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(89);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex89(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(90);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex90(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(91);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex91(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(92);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex92(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(93);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex93(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 70 || ch == 102) {
                nextStates.set(94);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex94(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(95);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex95(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(96);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex96(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 69 && ch != 101 || validTypes != null && !validTypes.contains(Token.TokenType.POLYHEDRALSURFACE))) {
                type = Token.TokenType.POLYHEDRALSURFACE;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex97(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(98);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex98(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(99);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex99(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(100);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex100(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(101);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex101(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 71 || ch == 103) {
                nextStates.set(102);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex102(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(103);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex103(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 69 && ch != 101 || validTypes != null && !validTypes.contains(Token.TokenType.TRIANGLE))) {
                type = Token.TokenType.TRIANGLE;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            nfaFunctions = new NfaFunction[]{DEFAULT::getNfaIndex0, DEFAULT::getNfaIndex1, DEFAULT::getNfaIndex2, DEFAULT::getNfaIndex3, DEFAULT::getNfaIndex4, DEFAULT::getNfaIndex5, DEFAULT::getNfaIndex6, DEFAULT::getNfaIndex7, DEFAULT::getNfaIndex8, DEFAULT::getNfaIndex9, DEFAULT::getNfaIndex10, DEFAULT::getNfaIndex11, DEFAULT::getNfaIndex12, DEFAULT::getNfaIndex13, DEFAULT::getNfaIndex14, DEFAULT::getNfaIndex15, DEFAULT::getNfaIndex16, DEFAULT::getNfaIndex17, DEFAULT::getNfaIndex18, DEFAULT::getNfaIndex19, DEFAULT::getNfaIndex20, DEFAULT::getNfaIndex21, DEFAULT::getNfaIndex22, DEFAULT::getNfaIndex23, DEFAULT::getNfaIndex24, DEFAULT::getNfaIndex25, DEFAULT::getNfaIndex26, DEFAULT::getNfaIndex27, DEFAULT::getNfaIndex28, DEFAULT::getNfaIndex29, DEFAULT::getNfaIndex30, DEFAULT::getNfaIndex31, DEFAULT::getNfaIndex32, DEFAULT::getNfaIndex33, DEFAULT::getNfaIndex34, DEFAULT::getNfaIndex35, DEFAULT::getNfaIndex36, DEFAULT::getNfaIndex37, DEFAULT::getNfaIndex38, DEFAULT::getNfaIndex39, DEFAULT::getNfaIndex40, DEFAULT::getNfaIndex41, DEFAULT::getNfaIndex42, DEFAULT::getNfaIndex43, DEFAULT::getNfaIndex44, DEFAULT::getNfaIndex45, DEFAULT::getNfaIndex46, DEFAULT::getNfaIndex47, DEFAULT::getNfaIndex48, DEFAULT::getNfaIndex49, DEFAULT::getNfaIndex50, DEFAULT::getNfaIndex51, DEFAULT::getNfaIndex52, DEFAULT::getNfaIndex53, DEFAULT::getNfaIndex54, DEFAULT::getNfaIndex55, DEFAULT::getNfaIndex56, DEFAULT::getNfaIndex57, DEFAULT::getNfaIndex58, DEFAULT::getNfaIndex59, DEFAULT::getNfaIndex60, DEFAULT::getNfaIndex61, DEFAULT::getNfaIndex62, DEFAULT::getNfaIndex63, DEFAULT::getNfaIndex64, DEFAULT::getNfaIndex65, DEFAULT::getNfaIndex66, DEFAULT::getNfaIndex67, DEFAULT::getNfaIndex68, DEFAULT::getNfaIndex69, DEFAULT::getNfaIndex70, DEFAULT::getNfaIndex71, DEFAULT::getNfaIndex72, DEFAULT::getNfaIndex73, DEFAULT::getNfaIndex74, DEFAULT::getNfaIndex75, DEFAULT::getNfaIndex76, DEFAULT::getNfaIndex77, DEFAULT::getNfaIndex78, DEFAULT::getNfaIndex79, DEFAULT::getNfaIndex80, DEFAULT::getNfaIndex81, DEFAULT::getNfaIndex82, DEFAULT::getNfaIndex83, DEFAULT::getNfaIndex84, DEFAULT::getNfaIndex85, DEFAULT::getNfaIndex86, DEFAULT::getNfaIndex87, DEFAULT::getNfaIndex88, DEFAULT::getNfaIndex89, DEFAULT::getNfaIndex90, DEFAULT::getNfaIndex91, DEFAULT::getNfaIndex92, DEFAULT::getNfaIndex93, DEFAULT::getNfaIndex94, DEFAULT::getNfaIndex95, DEFAULT::getNfaIndex96, DEFAULT::getNfaIndex97, DEFAULT::getNfaIndex98, DEFAULT::getNfaIndex99, DEFAULT::getNfaIndex100, DEFAULT::getNfaIndex101, DEFAULT::getNfaIndex102, DEFAULT::getNfaIndex103};
        }
    }
}

