/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.user;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserData {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserData.class);
    public static final int MAX_PASSWORD_LENGTH = 128;
    public static final int MAX_USERNAME_LENGTH = 128;
    public final String userName;
    public final String userPass;
    public final Set<String> roles = new LinkedHashSet<String>();

    public UserData(String userName, String userPass) {
        this(userName, 128, userPass, 128);
    }

    public UserData(String userName, int maxNameLength, String userPass, int maxPassLength) {
        if (userName != null && userName.length() > maxNameLength) {
            LOGGER.error("Username too long, aborting.");
            throw new IllegalArgumentException("Username too long.");
        }
        if (userPass != null && userPass.length() > maxPassLength) {
            LOGGER.error("Password too long, aborting.");
            throw new IllegalArgumentException("Password too long.");
        }
        this.userName = userName;
        this.userPass = userPass;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isEmpty() {
        return this.userName == null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserData other = (UserData)obj;
        if (!Objects.equals(this.userName, other.userName)) {
            return false;
        }
        return Objects.equals(this.userPass, other.userPass);
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.userName);
        hash = 71 * hash + Objects.hashCode(this.userPass);
        return hash;
    }
}

