/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.queryparser;

import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.InvalidToken;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.Token;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.TokenSource;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.EnumSet;

public class QLexer
extends TokenSource {
    LexicalState lexicalState = LexicalState.values()[0];
    EnumSet<Token.TokenType> activeTokenTypes = EnumSet.allOf(Token.TokenType.class);
    static final EnumSet<Token.TokenType> regularTokens = EnumSet.of(Token.TokenType.EOF, new Token.TokenType[]{Token.TokenType.T_O_ID, Token.TokenType.T_OPTIONS_SEPARATOR, Token.TokenType.T_O_METADATA, Token.TokenType.T_O_SKIPFILTER, Token.TokenType.T_O_COUNT, Token.TokenType.T_O_TOP, Token.TokenType.T_O_SKIP, Token.TokenType.T_O_SELECT, Token.TokenType.T_O_FILTER, Token.TokenType.T_O_EXPAND, Token.TokenType.T_O_ORDERBY, Token.TokenType.T_SUBQUERY_OPTIONS_SEPARATOR, Token.TokenType.T_VALUE_SEPARATOR, Token.TokenType.T_DISTINCT, Token.TokenType.T_PATH_SEPARATOR, Token.TokenType.T_O_ASC, Token.TokenType.T_O_DESC, Token.TokenType.T_IT, Token.TokenType.T_COLON, Token.TokenType.T_LB, Token.TokenType.T_RB, Token.TokenType.T_QO_EQ, Token.TokenType.T_QO_NE, Token.TokenType.T_QO_GT, Token.TokenType.T_QO_GE, Token.TokenType.T_QO_LT, Token.TokenType.T_QO_LE, Token.TokenType.T_QO_IN, Token.TokenType.T_QO_AND, Token.TokenType.T_QO_NOT, Token.TokenType.T_QO_OR, Token.TokenType.T_QO_ADD, Token.TokenType.T_QO_SUB, Token.TokenType.T_QO_MUL, Token.TokenType.T_QO_DIV, Token.TokenType.T_QO_MOD, Token.TokenType.T_NULL, Token.TokenType.T_STRING, Token.TokenType.T_O_FORMAT, Token.TokenType.T_CHARSEQ_FORMAT, Token.TokenType.T_CHARSEQ_METADATA, Token.TokenType.T_BOOL, Token.TokenType.T_LONG, Token.TokenType.T_ARRAYINDEX, Token.TokenType.T_CHARSEQ, Token.TokenType.T_ANY, Token.TokenType.T_QF_SUBSTRINGOF, Token.TokenType.T_QF_ENDSWITH, Token.TokenType.T_QF_STARTSWITH, Token.TokenType.T_QF_LENGTH, Token.TokenType.T_QF_INDEXOF, Token.TokenType.T_QF_SUBSTRING, Token.TokenType.T_QF_TOLOWER, Token.TokenType.T_QF_TOUPPER, Token.TokenType.T_QF_TRIM, Token.TokenType.T_QF_CONCAT, Token.TokenType.T_QF_YEAR, Token.TokenType.T_QF_MONTH, Token.TokenType.T_QF_DAY, Token.TokenType.T_QF_HOUR, Token.TokenType.T_QF_MINUTE, Token.TokenType.T_QF_SECOND, Token.TokenType.T_QF_FRACTIONALSECONDS, Token.TokenType.T_QF_DATE, Token.TokenType.T_QF_TIME, Token.TokenType.T_QF_TOTALOFFSETMINUTES, Token.TokenType.T_QF_NOW, Token.TokenType.T_QF_MINDATETIME, Token.TokenType.T_QF_MAXDATETIME, Token.TokenType.T_QF_BEFORE, Token.TokenType.T_QF_AFTER, Token.TokenType.T_QF_MEETS, Token.TokenType.T_QF_DURING, Token.TokenType.T_QF_OVERLAPS, Token.TokenType.T_QF_STARTS, Token.TokenType.T_QF_FINISHES, Token.TokenType.T_QF_ROUND, Token.TokenType.T_QF_FLOOR, Token.TokenType.T_QF_CEILING, Token.TokenType.T_QF_GEO_DISTANCE, Token.TokenType.T_QF_GEO_LENGTH, Token.TokenType.T_QF_GEO_INTERSECTS, Token.TokenType.T_QF_ST_EQUALS, Token.TokenType.T_QF_ST_DISJOINT, Token.TokenType.T_QF_ST_TOUCHES, Token.TokenType.T_QF_ST_WITHIN, Token.TokenType.T_QF_ST_OVERLAPS, Token.TokenType.T_QF_ST_CROSSES, Token.TokenType.T_QF_ST_INTERSECTS, Token.TokenType.T_QF_ST_CONTAINS, Token.TokenType.T_QF_ST_RELATE, Token.TokenType.T_QF_PRINCIPAL_NAME, Token.TokenType.T_STR_LIT, Token.TokenType.T_GEO_STR_LIT, Token.TokenType.T_DURATION, Token.TokenType.T_DATE, Token.TokenType.T_TIME, Token.TokenType.T_DATETIME, Token.TokenType.T_DATETIMEINTERVAL, Token.TokenType.T_DOUBLE});
    private static final EnumSet<Token.TokenType> unparsedTokens = EnumSet.noneOf(Token.TokenType.class);
    static final EnumSet<Token.TokenType> skippedTokens = EnumSet.of(Token.TokenType._TOKEN_1, Token.TokenType._TOKEN_2, Token.TokenType._TOKEN_3, Token.TokenType._TOKEN_4);
    private static final EnumSet<Token.TokenType> moreTokens = EnumSet.noneOf(Token.TokenType.class);
    private static final EnumMap<LexicalState, NfaFunction[]> functionTableMap = new EnumMap(LexicalState.class);

    public QLexer(CharSequence input) {
        this("input", input);
    }

    public QLexer(String inputSource, CharSequence input) {
        this(inputSource, input, LexicalState.DEFAULT, 1, 1);
    }

    public QLexer(String inputSource, CharSequence input, LexicalState lexState, int startingLine, int startingColumn) {
        super(inputSource, input, startingLine, startingColumn, 1, true, true, false, "");
        if (this.lexicalState != null) {
            this.switchTo(lexState);
        }
    }

    public Token getNextToken(Token tok) {
        if (tok == null) {
            tok = this.tokenizeAt(0);
            this.cacheToken(tok);
            return tok;
        }
        Token cachedToken = tok.nextCachedToken();
        if (cachedToken != null && this.activeTokenTypes != null && !this.activeTokenTypes.contains(cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        if (cachedToken == null) {
            Token token = this.tokenizeAt(tok.getEndOffset());
            this.cacheToken(token);
            return token;
        }
        return cachedToken;
    }

    static MatchInfo getMatchInfo(CharSequence input, int position, EnumSet<Token.TokenType> activeTokenTypes, NfaFunction[] nfaFunctions) {
        if (position >= input.length()) {
            return new MatchInfo(Token.TokenType.EOF, 0);
        }
        int start = position;
        int matchLength = 0;
        Token.TokenType matchedType = Token.TokenType.INVALID;
        BitSet currentStates = new BitSet(464);
        BitSet nextStates = new BitSet(464);
        do {
            int curChar;
            if (position > start) {
                BitSet temp = currentStates;
                currentStates = nextStates;
                nextStates = temp;
                nextStates.clear();
            } else {
                currentStates.set(0);
            }
            if (position >= input.length()) break;
            if ((curChar = Character.codePointAt(input, position++)) > 65535) {
                ++position;
            }
            int nextActive = currentStates.nextSetBit(0);
            while (nextActive != -1) {
                Token.TokenType returnedType = nfaFunctions[nextActive].apply(curChar, nextStates, activeTokenTypes);
                if (returnedType != null && (position - start > matchLength || returnedType.ordinal() < matchedType.ordinal())) {
                    matchedType = returnedType;
                    matchLength = position - start;
                }
                nextActive = currentStates.nextSetBit(nextActive + 1);
            }
        } while (position < input.length() && !nextStates.isEmpty());
        return new MatchInfo(matchedType, matchLength);
    }

    final Token tokenizeAt(int position) {
        int tokenBeginOffset = position;
        boolean inMore = false;
        StringBuilder invalidChars = null;
        Token matchedToken = null;
        Token.TokenType matchedType = null;
        while (matchedToken == null) {
            NfaFunction[] nfaFunctions = functionTableMap.get((Object)this.lexicalState);
            if (!inMore) {
                tokenBeginOffset = position;
            }
            MatchInfo matchInfo = QLexer.getMatchInfo(this, position, this.activeTokenTypes, nfaFunctions);
            matchedType = matchInfo.matchedType;
            inMore = moreTokens.contains(matchedType);
            position += matchInfo.matchLength;
            if (matchedType == Token.TokenType.INVALID) {
                if (invalidChars == null) {
                    invalidChars = new StringBuilder();
                }
                int cp = Character.codePointAt(this, tokenBeginOffset);
                invalidChars.appendCodePoint(cp);
                ++position;
                if (cp <= 65535) continue;
                ++position;
                continue;
            }
            if (invalidChars != null) {
                return new InvalidToken(this, tokenBeginOffset - invalidChars.length(), tokenBeginOffset);
            }
            if (skippedTokens.contains(matchedType)) {
                this.skipTokens(tokenBeginOffset, position);
                continue;
            }
            if (!regularTokens.contains(matchedType) && !unparsedTokens.contains(matchedType)) continue;
            matchedToken = Token.newToken(matchedType, this, tokenBeginOffset, position);
            matchedToken.setUnparsed(!regularTokens.contains(matchedType));
        }
        return matchedToken;
    }

    public boolean switchTo(LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(Token t2, LexicalState state) {
        this.uncacheTokens(t2);
        if (state != null) {
            this.switchTo(state);
        }
    }

    void reset(Token t2) {
        this.reset(t2, null);
    }

    void cacheToken(Token tok) {
        this.cacheTokenAt(tok, tok.getBeginOffset());
    }

    static {
        DEFAULT.NFA_FUNCTIONS_init();
        LS_REF.NFA_FUNCTIONS_init();
        LS_QUERY.NFA_FUNCTIONS_init();
        LS_SUBQUERY.NFA_FUNCTIONS_init();
        LS_FILTER.NFA_FUNCTIONS_init();
        LS_CONSTANTS.NFA_FUNCTIONS_init();
        LS_PLAIN_PATH.NFA_FUNCTIONS_init();
        LS_ORDERBYS.NFA_FUNCTIONS_init();
        LS_ORDERBY.NFA_FUNCTIONS_init();
        LS_ANYSTRING.NFA_FUNCTIONS_init();
        LS_FORMAT.NFA_FUNCTIONS_init();
        LS_METADATA.NFA_FUNCTIONS_init();
        LS_COUNT.NFA_FUNCTIONS_init();
        LS_TOP.NFA_FUNCTIONS_init();
        LS_SKIP.NFA_FUNCTIONS_init();
        LS_EXPAND.NFA_FUNCTIONS_init();
        LS_SELECT.NFA_FUNCTIONS_init();
    }

    public static enum LexicalState {
        DEFAULT,
        LS_REF,
        LS_QUERY,
        LS_SUBQUERY,
        LS_FILTER,
        LS_CONSTANTS,
        LS_PLAIN_PATH,
        LS_ORDERBYS,
        LS_ORDERBY,
        LS_ANYSTRING,
        LS_FORMAT,
        LS_METADATA,
        LS_COUNT,
        LS_TOP,
        LS_SKIP,
        LS_EXPAND,
        LS_SELECT;

    }

    static class MatchInfo {
        Token.TokenType matchedType;
        int matchLength;

        MatchInfo(Token.TokenType matchedType, int matchLength) {
            this.matchedType = matchedType;
            this.matchLength = matchLength;
        }
    }

    static interface NfaFunction {
        public Token.TokenType apply(int var1, BitSet var2, EnumSet<Token.TokenType> var3);
    }

    private static class DEFAULT {
        private DEFAULT() {
        }

        private static Token.TokenType getNfaIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 9) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_4)) {
                    type = Token.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_3)) {
                    type = Token.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_2)) {
                    type = Token.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_1))) {
                type = Token.TokenType._TOKEN_1;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions2 = new NfaFunction[]{DEFAULT::getNfaIndex0};
            functionTableMap.put(LexicalState.DEFAULT, functions2);
        }
    }

    private static class LS_REF {
        private LS_REF() {
        }

        private static Token.TokenType getNfaNameLS_REFIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 36) {
                nextStates.set(1);
            } else if (ch == 9) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_4)) {
                    type = Token.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_3)) {
                    type = Token.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_2)) {
                    type = Token.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_1))) {
                type = Token.TokenType._TOKEN_1;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_REFIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(2);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_REFIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(3);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_REFIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_ID))) {
                type = Token.TokenType.T_O_ID;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions2 = new NfaFunction[]{LS_REF::getNfaNameLS_REFIndex0, LS_REF::getNfaNameLS_REFIndex1, LS_REF::getNfaNameLS_REFIndex2, LS_REF::getNfaNameLS_REFIndex3};
            functionTableMap.put(LexicalState.LS_REF, functions2);
        }
    }

    private static class LS_QUERY {
        private LS_QUERY() {
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 36) {
                nextStates.set(1);
                nextStates.set(14);
                nextStates.set(20);
                nextStates.set(35);
                nextStates.set(42);
                nextStates.set(50);
                nextStates.set(57);
                nextStates.set(61);
                nextStates.set(66);
                nextStates.set(77);
            } else if (ch == 38) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_OPTIONS_SEPARATOR)) {
                    type = Token.TokenType.T_OPTIONS_SEPARATOR;
                }
            } else if (ch == 9) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_4)) {
                    type = Token.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_3)) {
                    type = Token.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_2)) {
                    type = Token.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_1))) {
                type = Token.TokenType._TOKEN_1;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 70 || ch == 102) {
                nextStates.set(8);
            } else if (ch == 82 || ch == 114) {
                nextStates.set(2);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(3);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(4);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(5);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(6);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(7);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 70 || ch == 102) {
                nextStates.set(8);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(9);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(10);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77 || ch == 109) {
                nextStates.set(11);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(12);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(13);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_FORMAT))) {
                type = Token.TokenType.T_O_FORMAT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(15);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(16);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(17);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(18);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(19);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_COUNT))) {
                type = Token.TokenType.T_O_COUNT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(21);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(22);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(23);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(24);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(25);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(26);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77 || ch == 109) {
                nextStates.set(27);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(28);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(29);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(30);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(31);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(32);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(33);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(34);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_METADATA))) {
                type = Token.TokenType.T_O_METADATA;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(36);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 88 || ch == 120) {
                nextStates.set(37);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(38);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(39);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(40);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(41);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_EXPAND))) {
                type = Token.TokenType.T_O_EXPAND;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(43);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(44);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(45);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex45(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(46);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex46(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(47);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex47(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 66 || ch == 98) {
                nextStates.set(48);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex48(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 89 || ch == 121) {
                nextStates.set(49);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex49(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_ORDERBY))) {
                type = Token.TokenType.T_O_ORDERBY;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex50(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(51);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex51(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(52);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex52(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(53);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex53(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(54);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex54(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(55);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex55(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(56);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex56(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_SELECT))) {
                type = Token.TokenType.T_O_SELECT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex57(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(58);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex58(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(59);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex59(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(60);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex60(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_TOP))) {
                type = Token.TokenType.T_O_TOP;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex61(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(62);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex62(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75 || ch == 107) {
                nextStates.set(63);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex63(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(64);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex64(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(65);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex65(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_SKIP))) {
                type = Token.TokenType.T_O_SKIP;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex66(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(67);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex67(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75 || ch == 107) {
                nextStates.set(68);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex68(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(69);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex69(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(70);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex70(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 70 || ch == 102) {
                nextStates.set(71);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex71(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(72);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex72(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(73);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex73(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(74);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex74(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(75);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex75(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(76);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex76(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_SKIPFILTER))) {
                type = Token.TokenType.T_O_SKIPFILTER;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex77(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 70 || ch == 102) {
                nextStates.set(78);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex78(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(79);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex79(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(80);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex80(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(81);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex81(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(82);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex82(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(83);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_QUERYIndex83(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_FILTER))) {
                type = Token.TokenType.T_O_FILTER;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions2 = new NfaFunction[]{LS_QUERY::getNfaNameLS_QUERYIndex0, LS_QUERY::getNfaNameLS_QUERYIndex1, LS_QUERY::getNfaNameLS_QUERYIndex2, LS_QUERY::getNfaNameLS_QUERYIndex3, LS_QUERY::getNfaNameLS_QUERYIndex4, LS_QUERY::getNfaNameLS_QUERYIndex5, LS_QUERY::getNfaNameLS_QUERYIndex6, LS_QUERY::getNfaNameLS_QUERYIndex7, LS_QUERY::getNfaNameLS_QUERYIndex8, LS_QUERY::getNfaNameLS_QUERYIndex9, LS_QUERY::getNfaNameLS_QUERYIndex10, LS_QUERY::getNfaNameLS_QUERYIndex11, LS_QUERY::getNfaNameLS_QUERYIndex12, LS_QUERY::getNfaNameLS_QUERYIndex13, LS_QUERY::getNfaNameLS_QUERYIndex14, LS_QUERY::getNfaNameLS_QUERYIndex15, LS_QUERY::getNfaNameLS_QUERYIndex16, LS_QUERY::getNfaNameLS_QUERYIndex17, LS_QUERY::getNfaNameLS_QUERYIndex18, LS_QUERY::getNfaNameLS_QUERYIndex19, LS_QUERY::getNfaNameLS_QUERYIndex20, LS_QUERY::getNfaNameLS_QUERYIndex21, LS_QUERY::getNfaNameLS_QUERYIndex22, LS_QUERY::getNfaNameLS_QUERYIndex23, LS_QUERY::getNfaNameLS_QUERYIndex24, LS_QUERY::getNfaNameLS_QUERYIndex25, LS_QUERY::getNfaNameLS_QUERYIndex26, LS_QUERY::getNfaNameLS_QUERYIndex27, LS_QUERY::getNfaNameLS_QUERYIndex28, LS_QUERY::getNfaNameLS_QUERYIndex29, LS_QUERY::getNfaNameLS_QUERYIndex30, LS_QUERY::getNfaNameLS_QUERYIndex31, LS_QUERY::getNfaNameLS_QUERYIndex32, LS_QUERY::getNfaNameLS_QUERYIndex33, LS_QUERY::getNfaNameLS_QUERYIndex34, LS_QUERY::getNfaNameLS_QUERYIndex35, LS_QUERY::getNfaNameLS_QUERYIndex36, LS_QUERY::getNfaNameLS_QUERYIndex37, LS_QUERY::getNfaNameLS_QUERYIndex38, LS_QUERY::getNfaNameLS_QUERYIndex39, LS_QUERY::getNfaNameLS_QUERYIndex40, LS_QUERY::getNfaNameLS_QUERYIndex41, LS_QUERY::getNfaNameLS_QUERYIndex42, LS_QUERY::getNfaNameLS_QUERYIndex43, LS_QUERY::getNfaNameLS_QUERYIndex44, LS_QUERY::getNfaNameLS_QUERYIndex45, LS_QUERY::getNfaNameLS_QUERYIndex46, LS_QUERY::getNfaNameLS_QUERYIndex47, LS_QUERY::getNfaNameLS_QUERYIndex48, LS_QUERY::getNfaNameLS_QUERYIndex49, LS_QUERY::getNfaNameLS_QUERYIndex50, LS_QUERY::getNfaNameLS_QUERYIndex51, LS_QUERY::getNfaNameLS_QUERYIndex52, LS_QUERY::getNfaNameLS_QUERYIndex53, LS_QUERY::getNfaNameLS_QUERYIndex54, LS_QUERY::getNfaNameLS_QUERYIndex55, LS_QUERY::getNfaNameLS_QUERYIndex56, LS_QUERY::getNfaNameLS_QUERYIndex57, LS_QUERY::getNfaNameLS_QUERYIndex58, LS_QUERY::getNfaNameLS_QUERYIndex59, LS_QUERY::getNfaNameLS_QUERYIndex60, LS_QUERY::getNfaNameLS_QUERYIndex61, LS_QUERY::getNfaNameLS_QUERYIndex62, LS_QUERY::getNfaNameLS_QUERYIndex63, LS_QUERY::getNfaNameLS_QUERYIndex64, LS_QUERY::getNfaNameLS_QUERYIndex65, LS_QUERY::getNfaNameLS_QUERYIndex66, LS_QUERY::getNfaNameLS_QUERYIndex67, LS_QUERY::getNfaNameLS_QUERYIndex68, LS_QUERY::getNfaNameLS_QUERYIndex69, LS_QUERY::getNfaNameLS_QUERYIndex70, LS_QUERY::getNfaNameLS_QUERYIndex71, LS_QUERY::getNfaNameLS_QUERYIndex72, LS_QUERY::getNfaNameLS_QUERYIndex73, LS_QUERY::getNfaNameLS_QUERYIndex74, LS_QUERY::getNfaNameLS_QUERYIndex75, LS_QUERY::getNfaNameLS_QUERYIndex76, LS_QUERY::getNfaNameLS_QUERYIndex77, LS_QUERY::getNfaNameLS_QUERYIndex78, LS_QUERY::getNfaNameLS_QUERYIndex79, LS_QUERY::getNfaNameLS_QUERYIndex80, LS_QUERY::getNfaNameLS_QUERYIndex81, LS_QUERY::getNfaNameLS_QUERYIndex82, LS_QUERY::getNfaNameLS_QUERYIndex83};
            functionTableMap.put(LexicalState.LS_QUERY, functions2);
        }
    }

    private static class LS_SUBQUERY {
        private LS_SUBQUERY() {
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 36) {
                nextStates.set(1);
                nextStates.set(8);
                nextStates.set(15);
                nextStates.set(21);
                nextStates.set(29);
                nextStates.set(34);
                nextStates.set(41);
            } else if (ch == 59) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_SUBQUERY_OPTIONS_SEPARATOR)) {
                    type = Token.TokenType.T_SUBQUERY_OPTIONS_SEPARATOR;
                }
            } else if (ch == 9) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_4)) {
                    type = Token.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_3)) {
                    type = Token.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_2)) {
                    type = Token.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_1))) {
                type = Token.TokenType._TOKEN_1;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(2);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(3);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(4);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(5);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(6);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(7);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_SELECT))) {
                type = Token.TokenType.T_O_SELECT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 70 || ch == 102) {
                nextStates.set(9);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(10);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(11);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(12);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(13);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(14);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_FILTER))) {
                type = Token.TokenType.T_O_FILTER;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(16);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(17);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(18);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(19);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(20);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_COUNT))) {
                type = Token.TokenType.T_O_COUNT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(22);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(23);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(24);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(25);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(26);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 66 || ch == 98) {
                nextStates.set(27);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 89 || ch == 121) {
                nextStates.set(28);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_ORDERBY))) {
                type = Token.TokenType.T_O_ORDERBY;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(30);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 75 || ch == 107) {
                nextStates.set(31);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(32);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(33);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_SKIP))) {
                type = Token.TokenType.T_O_SKIP;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(35);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 88 || ch == 120) {
                nextStates.set(36);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(37);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(38);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(39);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(40);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_EXPAND))) {
                type = Token.TokenType.T_O_EXPAND;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(42);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(43);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(44);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SUBQUERYIndex44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 61 && (validTypes == null || validTypes.contains(Token.TokenType.T_O_TOP))) {
                type = Token.TokenType.T_O_TOP;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions2 = new NfaFunction[]{LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex0, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex1, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex2, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex3, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex4, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex5, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex6, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex7, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex8, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex9, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex10, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex11, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex12, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex13, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex14, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex15, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex16, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex17, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex18, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex19, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex20, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex21, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex22, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex23, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex24, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex25, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex26, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex27, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex28, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex29, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex30, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex31, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex32, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex33, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex34, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex35, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex36, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex37, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex38, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex39, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex40, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex41, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex42, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex43, LS_SUBQUERY::getNfaNameLS_SUBQUERYIndex44};
            functionTableMap.put(LexicalState.LS_SUBQUERY, functions2);
        }
    }

    private static class LS_FILTER {
        private LS_FILTER() {
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(1);
                nextStates.set(62);
                nextStates.set(308);
            } else if (ch == 66 || ch == 98) {
                nextStates.set(335);
            } else if (ch == 67 || ch == 99) {
                nextStates.set(30);
                nextStates.set(164);
            } else if (ch == 68 || ch == 100) {
                nextStates.set(17);
                nextStates.set(83);
                nextStates.set(176);
                nextStates.set(220);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(8);
                nextStates.set(82);
            } else if (ch == 70 || ch == 102) {
                nextStates.set(178);
                nextStates.set(197);
                nextStates.set(301);
            } else if (ch == 71 || ch == 103) {
                nextStates.set(7);
                nextStates.set(16);
                nextStates.set(20);
                nextStates.set(276);
                nextStates.set(341);
            } else if (ch == 72 || ch == 104) {
                nextStates.set(112);
            } else if (ch == 73 || ch == 105) {
                nextStates.set(324);
                nextStates.set(382);
            } else if (ch == 76 || ch == 108) {
                nextStates.set(170);
                nextStates.set(357);
                nextStates.set(396);
            } else if (ch == 77 || ch == 109) {
                nextStates.set(99);
                nextStates.set(214);
                nextStates.set(256);
                nextStates.set(299);
                nextStates.set(306);
                nextStates.set(358);
                nextStates.set(383);
            } else if (ch == 78 || ch == 110) {
                nextStates.set(46);
                nextStates.set(89);
                nextStates.set(394);
            } else if (ch == 79 || ch == 111) {
                nextStates.set(64);
                nextStates.set(104);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(369);
            } else if (ch == 82 || ch == 114) {
                nextStates.set(159);
            } else if (ch == 83 || ch == 115) {
                nextStates.set(37);
                nextStates.set(49);
                nextStates.set(72);
                nextStates.set(90);
                nextStates.set(116);
                nextStates.set(122);
                nextStates.set(132);
                nextStates.set(150);
                nextStates.set(186);
                nextStates.set(246);
                nextStates.set(261);
                nextStates.set(270);
                nextStates.set(288);
                nextStates.set(313);
                nextStates.set(355);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(3);
                nextStates.set(105);
                nextStates.set(143);
                nextStates.set(224);
                nextStates.set(228);
            } else if (ch == 89 || ch == 121) {
                nextStates.set(331);
            } else if (ch == 41) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_RB)) {
                    type = Token.TokenType.T_RB;
                }
            } else if (ch == 40) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_LB)) {
                    type = Token.TokenType.T_LB;
                }
            } else if (ch == 44) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_VALUE_SEPARATOR)) {
                    type = Token.TokenType.T_VALUE_SEPARATOR;
                }
            } else if (ch == 9) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_4)) {
                    type = Token.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_3)) {
                    type = Token.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_2)) {
                    type = Token.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_1))) {
                type = Token.TokenType._TOKEN_1;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(2);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 68 && ch != 100 || validTypes != null && !validTypes.contains(Token.TokenType.T_QO_ADD))) {
                type = Token.TokenType.T_QO_ADD;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(4);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77 || ch == 109) {
                nextStates.set(5);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(6);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_TIME))) {
                type = Token.TokenType.T_QF_TIME;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 69 && ch != 101 || validTypes != null && !validTypes.contains(Token.TokenType.T_QO_GE))) {
                type = Token.TokenType.T_QO_GE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(9);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(10);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(11);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 87 || ch == 119) {
                nextStates.set(12);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(13);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(14);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 72 || ch == 104) {
                nextStates.set(15);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_ENDSWITH))) {
                type = Token.TokenType.T_QF_ENDSWITH;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 84 && ch != 116 || validTypes != null && !validTypes.contains(Token.TokenType.T_QO_GT))) {
                type = Token.TokenType.T_QO_GT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(18);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 89 || ch == 121) {
                nextStates.set(19);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_DAY))) {
                type = Token.TokenType.T_QF_DAY;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(21);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(22);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(23);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(24);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(25);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(26);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 71 || ch == 103) {
                nextStates.set(27);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(28);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 72 || ch == 104) {
                nextStates.set(29);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_GEO_LENGTH))) {
                type = Token.TokenType.T_QF_GEO_LENGTH;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(31);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(32);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(33);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(34);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(35);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 71 || ch == 103) {
                nextStates.set(36);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_CEILING))) {
                type = Token.TokenType.T_QF_CEILING;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(38);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 66 || ch == 98) {
                nextStates.set(39);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(40);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(41);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(42);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(43);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(44);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 71 || ch == 103) {
                nextStates.set(45);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex45(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_SUBSTRING))) {
                type = Token.TokenType.T_QF_SUBSTRING;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex46(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(47);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex47(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 87 || ch == 119) {
                nextStates.set(48);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex48(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_NOW))) {
                type = Token.TokenType.T_QF_NOW;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex49(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(50);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex50(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(51);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex51(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(52);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex52(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(53);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex53(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(54);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex54(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(55);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex55(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(56);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex56(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(57);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex57(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(58);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex58(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(59);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex59(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(60);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex60(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(61);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex61(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_ST_INTERSECTS))) {
                type = Token.TokenType.T_QF_ST_INTERSECTS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex62(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(63);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex63(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 68 && ch != 100 || validTypes != null && !validTypes.contains(Token.TokenType.T_QO_AND))) {
                type = Token.TokenType.T_QO_AND;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex64(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 86 || ch == 118) {
                nextStates.set(65);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex65(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(66);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex66(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(67);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex67(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(68);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex68(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(69);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex69(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(70);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex70(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(71);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex71(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_OVERLAPS))) {
                type = Token.TokenType.T_QF_OVERLAPS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex72(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(73);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex73(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(74);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex74(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(75);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex75(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(76);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex76(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(77);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex77(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 87 || ch == 119) {
                nextStates.set(78);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex78(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(79);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex79(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(80);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex80(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 72 || ch == 104) {
                nextStates.set(81);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex81(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_STARTSWITH))) {
                type = Token.TokenType.T_QF_STARTSWITH;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex82(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 81 && ch != 113 || validTypes != null && !validTypes.contains(Token.TokenType.T_QO_EQ))) {
                type = Token.TokenType.T_QO_EQ;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex83(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(84);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex84(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(85);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex85(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(86);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex86(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(87);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex87(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 71 || ch == 103) {
                nextStates.set(88);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex88(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_DURING))) {
                type = Token.TokenType.T_QF_DURING;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex89(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 69 && ch != 101 || validTypes != null && !validTypes.contains(Token.TokenType.T_QO_NE))) {
                type = Token.TokenType.T_QO_NE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex90(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(91);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex91(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(92);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex92(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(93);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex93(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(94);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex94(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(95);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex95(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(96);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex96(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(97);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex97(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(98);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex98(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_ST_RELATE))) {
                type = Token.TokenType.T_QF_ST_RELATE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex99(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(100);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex100(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(101);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex101(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(102);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex102(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 72 || ch == 104) {
                nextStates.set(103);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex103(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_MONTH))) {
                type = Token.TokenType.T_QF_MONTH;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex104(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 82 && ch != 114 || validTypes != null && !validTypes.contains(Token.TokenType.T_QO_OR))) {
                type = Token.TokenType.T_QO_OR;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex105(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(106);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex106(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(107);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex107(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(108);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex108(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 87 || ch == 119) {
                nextStates.set(109);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex109(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(110);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex110(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(111);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex111(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_TOLOWER))) {
                type = Token.TokenType.T_QF_TOLOWER;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex112(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(113);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex113(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(114);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex114(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(115);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex115(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_HOUR))) {
                type = Token.TokenType.T_QF_HOUR;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex116(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(117);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex117(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(118);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex118(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(119);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex119(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(120);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex120(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(121);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex121(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_SECOND))) {
                type = Token.TokenType.T_QF_SECOND;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex122(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(123);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex123(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(124);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex124(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(125);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex125(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(126);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex126(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(127);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex127(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(128);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex128(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(129);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex129(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(130);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex130(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(131);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex131(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_ST_CROSSES))) {
                type = Token.TokenType.T_QF_ST_CROSSES;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex132(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(133);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex133(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(134);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex134(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(135);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex135(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 86 || ch == 118) {
                nextStates.set(136);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex136(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(137);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex137(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(138);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex138(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(139);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex139(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(140);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex140(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(141);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex141(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(142);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex142(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_ST_OVERLAPS))) {
                type = Token.TokenType.T_QF_ST_OVERLAPS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex143(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(144);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex144(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(145);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex145(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(146);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex146(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(147);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex147(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(148);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex148(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(149);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex149(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_TOUPPER))) {
                type = Token.TokenType.T_QF_TOUPPER;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex150(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(151);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex151(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(152);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex152(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 87 || ch == 119) {
                nextStates.set(153);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex153(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(154);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex154(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(155);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex155(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 72 || ch == 104) {
                nextStates.set(156);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex156(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(157);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex157(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(158);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex158(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_ST_WITHIN))) {
                type = Token.TokenType.T_QF_ST_WITHIN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex159(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(160);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex160(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(161);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex161(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(162);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex162(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(163);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex163(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_ROUND))) {
                type = Token.TokenType.T_QF_ROUND;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex164(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(165);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex165(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(166);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex166(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(167);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex167(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(168);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex168(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(169);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex169(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_CONCAT))) {
                type = Token.TokenType.T_QF_CONCAT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex170(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(171);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex171(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(172);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex172(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 71 || ch == 103) {
                nextStates.set(173);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex173(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(174);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex174(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 72 || ch == 104) {
                nextStates.set(175);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex175(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_LENGTH))) {
                type = Token.TokenType.T_QF_LENGTH;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex176(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(177);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex177(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 86 && ch != 118 || validTypes != null && !validTypes.contains(Token.TokenType.T_QO_DIV))) {
                type = Token.TokenType.T_QO_DIV;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex178(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(179);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex179(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(180);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex180(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(181);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex181(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(182);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex182(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 72 || ch == 104) {
                nextStates.set(183);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex183(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(184);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex184(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(185);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex185(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_FINISHES))) {
                type = Token.TokenType.T_QF_FINISHES;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex186(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(187);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex187(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(188);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex188(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(189);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex189(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(190);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex190(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(191);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex191(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 74 || ch == 106) {
                nextStates.set(192);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex192(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(193);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex193(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(194);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex194(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(195);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex195(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(196);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex196(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_ST_DISJOINT))) {
                type = Token.TokenType.T_QF_ST_DISJOINT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex197(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(198);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex198(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(199);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex199(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(200);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex200(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(201);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex201(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(202);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex202(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(203);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex203(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(204);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex204(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(205);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex205(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(206);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex206(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(207);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex207(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(208);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex208(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(209);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex209(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(210);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex210(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(211);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex211(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(212);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex212(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(213);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex213(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_FRACTIONALSECONDS))) {
                type = Token.TokenType.T_QF_FRACTIONALSECONDS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex214(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(215);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex215(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(216);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex216(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(217);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex217(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(218);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex218(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(219);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex219(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_MINUTE))) {
                type = Token.TokenType.T_QF_MINUTE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex220(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(221);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex221(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(222);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex222(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(223);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex223(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_DATE))) {
                type = Token.TokenType.T_QF_DATE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex224(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(225);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex225(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(226);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex226(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77 || ch == 109) {
                nextStates.set(227);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex227(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_TRIM))) {
                type = Token.TokenType.T_QF_TRIM;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex228(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(229);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex229(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(230);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex230(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(231);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex231(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(232);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex232(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(233);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex233(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 70 || ch == 102) {
                nextStates.set(234);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex234(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 70 || ch == 102) {
                nextStates.set(235);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex235(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(236);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex236(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(237);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex237(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(238);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex238(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77 || ch == 109) {
                nextStates.set(239);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex239(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(240);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex240(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(241);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex241(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(242);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex242(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(243);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex243(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(244);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex244(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(245);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex245(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_TOTALOFFSETMINUTES))) {
                type = Token.TokenType.T_QF_TOTALOFFSETMINUTES;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex246(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(247);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex247(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(248);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex248(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(249);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex249(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(250);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex250(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(251);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex251(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(252);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex252(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 72 || ch == 104) {
                nextStates.set(253);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex253(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(254);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex254(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(255);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex255(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_ST_TOUCHES))) {
                type = Token.TokenType.T_QF_ST_TOUCHES;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex256(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(257);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex257(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(258);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex258(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(259);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex259(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(260);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex260(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_MEETS))) {
                type = Token.TokenType.T_QF_MEETS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex261(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(262);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex262(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(263);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex263(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(264);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex264(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 81 || ch == 113) {
                nextStates.set(265);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex265(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(266);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex266(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(267);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex267(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(268);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex268(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(269);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex269(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_ST_EQUALS))) {
                type = Token.TokenType.T_QF_ST_EQUALS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex270(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(271);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex271(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(272);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex272(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(273);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex273(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(274);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex274(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(275);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex275(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_STARTS))) {
                type = Token.TokenType.T_QF_STARTS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex276(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(277);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex277(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(278);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex278(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(279);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex279(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(280);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex280(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(281);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex281(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(282);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex282(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(283);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex283(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(284);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex284(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(285);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex285(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(286);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex286(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(287);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex287(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_GEO_DISTANCE))) {
                type = Token.TokenType.T_QF_GEO_DISTANCE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex288(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(289);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex289(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 95) {
                nextStates.set(290);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex290(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(291);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex291(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(292);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex292(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(293);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex293(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(294);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex294(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(295);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex295(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(296);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex296(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(297);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex297(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(298);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex298(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_ST_CONTAINS))) {
                type = Token.TokenType.T_QF_ST_CONTAINS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex299(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(300);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex300(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 68 && ch != 100 || validTypes != null && !validTypes.contains(Token.TokenType.T_QO_MOD))) {
                type = Token.TokenType.T_QO_MOD;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex301(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(302);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex302(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(303);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex303(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(304);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex304(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(305);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex305(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_FLOOR))) {
                type = Token.TokenType.T_QF_FLOOR;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex306(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(307);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex307(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(Token.TokenType.T_QO_MUL))) {
                type = Token.TokenType.T_QO_MUL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex308(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 70 || ch == 102) {
                nextStates.set(309);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex309(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(310);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex310(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(311);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex311(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(312);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex312(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_AFTER))) {
                type = Token.TokenType.T_QF_AFTER;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex313(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(314);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex314(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 66 || ch == 98) {
                nextStates.set(315);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex315(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(316);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex316(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(317);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex317(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(318);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex318(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(319);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex319(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(320);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex320(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 71 || ch == 103) {
                nextStates.set(321);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex321(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(322);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex322(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 70 || ch == 102) {
                nextStates.set(323);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex323(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_SUBSTRINGOF))) {
                type = Token.TokenType.T_QF_SUBSTRINGOF;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex324(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(325);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex325(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(326);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex326(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(327);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex327(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 88 || ch == 120) {
                nextStates.set(328);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex328(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(329);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex329(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 70 || ch == 102) {
                nextStates.set(330);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex330(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_INDEXOF))) {
                type = Token.TokenType.T_QF_INDEXOF;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex331(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(332);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex332(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(333);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex333(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(334);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex334(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_YEAR))) {
                type = Token.TokenType.T_QF_YEAR;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex335(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(336);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex336(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 70 || ch == 102) {
                nextStates.set(337);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex337(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(338);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex338(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(339);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex339(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(340);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex340(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_BEFORE))) {
                type = Token.TokenType.T_QF_BEFORE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex341(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(342);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex342(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(343);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex343(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(344);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex344(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(345);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex345(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(346);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex346(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(347);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex347(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(348);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex348(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(349);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex349(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(350);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex350(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(351);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex351(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(352);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex352(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(353);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex353(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(354);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex354(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_GEO_INTERSECTS))) {
                type = Token.TokenType.T_QF_GEO_INTERSECTS;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex355(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(356);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex356(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 66 && ch != 98 || validTypes != null && !validTypes.contains(Token.TokenType.T_QO_SUB))) {
                type = Token.TokenType.T_QO_SUB;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex357(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 69 && ch != 101 || validTypes != null && !validTypes.contains(Token.TokenType.T_QO_LE))) {
                type = Token.TokenType.T_QO_LE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex358(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(359);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex359(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 88 || ch == 120) {
                nextStates.set(360);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex360(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(361);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex361(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(362);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex362(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(363);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex363(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(364);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex364(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(365);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex365(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(366);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex366(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77 || ch == 109) {
                nextStates.set(367);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex367(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(368);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex368(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_MAXDATETIME))) {
                type = Token.TokenType.T_QF_MAXDATETIME;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex369(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(370);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex370(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(371);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex371(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(372);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex372(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(373);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex373(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(374);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex374(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(375);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex375(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(376);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex376(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(377);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex377(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(378);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex378(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(379);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex379(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77 || ch == 109) {
                nextStates.set(380);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex380(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(381);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex381(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_PRINCIPAL_NAME))) {
                type = Token.TokenType.T_QF_PRINCIPAL_NAME;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex382(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 78 && ch != 110 || validTypes != null && !validTypes.contains(Token.TokenType.T_QO_IN))) {
                type = Token.TokenType.T_QO_IN;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex383(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(384);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex384(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(385);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex385(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(386);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex386(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(387);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex387(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(388);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex388(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(389);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex389(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(390);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex390(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(391);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex391(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77 || ch == 109) {
                nextStates.set(392);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex392(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(393);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex393(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_QF_MINDATETIME))) {
                type = Token.TokenType.T_QF_MINDATETIME;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex394(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(395);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex395(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 84 && ch != 116 || validTypes != null && !validTypes.contains(Token.TokenType.T_QO_NOT))) {
                type = Token.TokenType.T_QO_NOT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_FILTERIndex396(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 84 && ch != 116 || validTypes != null && !validTypes.contains(Token.TokenType.T_QO_LT))) {
                type = Token.TokenType.T_QO_LT;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions2 = new NfaFunction[]{LS_FILTER::getNfaNameLS_FILTERIndex0, LS_FILTER::getNfaNameLS_FILTERIndex1, LS_FILTER::getNfaNameLS_FILTERIndex2, LS_FILTER::getNfaNameLS_FILTERIndex3, LS_FILTER::getNfaNameLS_FILTERIndex4, LS_FILTER::getNfaNameLS_FILTERIndex5, LS_FILTER::getNfaNameLS_FILTERIndex6, LS_FILTER::getNfaNameLS_FILTERIndex7, LS_FILTER::getNfaNameLS_FILTERIndex8, LS_FILTER::getNfaNameLS_FILTERIndex9, LS_FILTER::getNfaNameLS_FILTERIndex10, LS_FILTER::getNfaNameLS_FILTERIndex11, LS_FILTER::getNfaNameLS_FILTERIndex12, LS_FILTER::getNfaNameLS_FILTERIndex13, LS_FILTER::getNfaNameLS_FILTERIndex14, LS_FILTER::getNfaNameLS_FILTERIndex15, LS_FILTER::getNfaNameLS_FILTERIndex16, LS_FILTER::getNfaNameLS_FILTERIndex17, LS_FILTER::getNfaNameLS_FILTERIndex18, LS_FILTER::getNfaNameLS_FILTERIndex19, LS_FILTER::getNfaNameLS_FILTERIndex20, LS_FILTER::getNfaNameLS_FILTERIndex21, LS_FILTER::getNfaNameLS_FILTERIndex22, LS_FILTER::getNfaNameLS_FILTERIndex23, LS_FILTER::getNfaNameLS_FILTERIndex24, LS_FILTER::getNfaNameLS_FILTERIndex25, LS_FILTER::getNfaNameLS_FILTERIndex26, LS_FILTER::getNfaNameLS_FILTERIndex27, LS_FILTER::getNfaNameLS_FILTERIndex28, LS_FILTER::getNfaNameLS_FILTERIndex29, LS_FILTER::getNfaNameLS_FILTERIndex30, LS_FILTER::getNfaNameLS_FILTERIndex31, LS_FILTER::getNfaNameLS_FILTERIndex32, LS_FILTER::getNfaNameLS_FILTERIndex33, LS_FILTER::getNfaNameLS_FILTERIndex34, LS_FILTER::getNfaNameLS_FILTERIndex35, LS_FILTER::getNfaNameLS_FILTERIndex36, LS_FILTER::getNfaNameLS_FILTERIndex37, LS_FILTER::getNfaNameLS_FILTERIndex38, LS_FILTER::getNfaNameLS_FILTERIndex39, LS_FILTER::getNfaNameLS_FILTERIndex40, LS_FILTER::getNfaNameLS_FILTERIndex41, LS_FILTER::getNfaNameLS_FILTERIndex42, LS_FILTER::getNfaNameLS_FILTERIndex43, LS_FILTER::getNfaNameLS_FILTERIndex44, LS_FILTER::getNfaNameLS_FILTERIndex45, LS_FILTER::getNfaNameLS_FILTERIndex46, LS_FILTER::getNfaNameLS_FILTERIndex47, LS_FILTER::getNfaNameLS_FILTERIndex48, LS_FILTER::getNfaNameLS_FILTERIndex49, LS_FILTER::getNfaNameLS_FILTERIndex50, LS_FILTER::getNfaNameLS_FILTERIndex51, LS_FILTER::getNfaNameLS_FILTERIndex52, LS_FILTER::getNfaNameLS_FILTERIndex53, LS_FILTER::getNfaNameLS_FILTERIndex54, LS_FILTER::getNfaNameLS_FILTERIndex55, LS_FILTER::getNfaNameLS_FILTERIndex56, LS_FILTER::getNfaNameLS_FILTERIndex57, LS_FILTER::getNfaNameLS_FILTERIndex58, LS_FILTER::getNfaNameLS_FILTERIndex59, LS_FILTER::getNfaNameLS_FILTERIndex60, LS_FILTER::getNfaNameLS_FILTERIndex61, LS_FILTER::getNfaNameLS_FILTERIndex62, LS_FILTER::getNfaNameLS_FILTERIndex63, LS_FILTER::getNfaNameLS_FILTERIndex64, LS_FILTER::getNfaNameLS_FILTERIndex65, LS_FILTER::getNfaNameLS_FILTERIndex66, LS_FILTER::getNfaNameLS_FILTERIndex67, LS_FILTER::getNfaNameLS_FILTERIndex68, LS_FILTER::getNfaNameLS_FILTERIndex69, LS_FILTER::getNfaNameLS_FILTERIndex70, LS_FILTER::getNfaNameLS_FILTERIndex71, LS_FILTER::getNfaNameLS_FILTERIndex72, LS_FILTER::getNfaNameLS_FILTERIndex73, LS_FILTER::getNfaNameLS_FILTERIndex74, LS_FILTER::getNfaNameLS_FILTERIndex75, LS_FILTER::getNfaNameLS_FILTERIndex76, LS_FILTER::getNfaNameLS_FILTERIndex77, LS_FILTER::getNfaNameLS_FILTERIndex78, LS_FILTER::getNfaNameLS_FILTERIndex79, LS_FILTER::getNfaNameLS_FILTERIndex80, LS_FILTER::getNfaNameLS_FILTERIndex81, LS_FILTER::getNfaNameLS_FILTERIndex82, LS_FILTER::getNfaNameLS_FILTERIndex83, LS_FILTER::getNfaNameLS_FILTERIndex84, LS_FILTER::getNfaNameLS_FILTERIndex85, LS_FILTER::getNfaNameLS_FILTERIndex86, LS_FILTER::getNfaNameLS_FILTERIndex87, LS_FILTER::getNfaNameLS_FILTERIndex88, LS_FILTER::getNfaNameLS_FILTERIndex89, LS_FILTER::getNfaNameLS_FILTERIndex90, LS_FILTER::getNfaNameLS_FILTERIndex91, LS_FILTER::getNfaNameLS_FILTERIndex92, LS_FILTER::getNfaNameLS_FILTERIndex93, LS_FILTER::getNfaNameLS_FILTERIndex94, LS_FILTER::getNfaNameLS_FILTERIndex95, LS_FILTER::getNfaNameLS_FILTERIndex96, LS_FILTER::getNfaNameLS_FILTERIndex97, LS_FILTER::getNfaNameLS_FILTERIndex98, LS_FILTER::getNfaNameLS_FILTERIndex99, LS_FILTER::getNfaNameLS_FILTERIndex100, LS_FILTER::getNfaNameLS_FILTERIndex101, LS_FILTER::getNfaNameLS_FILTERIndex102, LS_FILTER::getNfaNameLS_FILTERIndex103, LS_FILTER::getNfaNameLS_FILTERIndex104, LS_FILTER::getNfaNameLS_FILTERIndex105, LS_FILTER::getNfaNameLS_FILTERIndex106, LS_FILTER::getNfaNameLS_FILTERIndex107, LS_FILTER::getNfaNameLS_FILTERIndex108, LS_FILTER::getNfaNameLS_FILTERIndex109, LS_FILTER::getNfaNameLS_FILTERIndex110, LS_FILTER::getNfaNameLS_FILTERIndex111, LS_FILTER::getNfaNameLS_FILTERIndex112, LS_FILTER::getNfaNameLS_FILTERIndex113, LS_FILTER::getNfaNameLS_FILTERIndex114, LS_FILTER::getNfaNameLS_FILTERIndex115, LS_FILTER::getNfaNameLS_FILTERIndex116, LS_FILTER::getNfaNameLS_FILTERIndex117, LS_FILTER::getNfaNameLS_FILTERIndex118, LS_FILTER::getNfaNameLS_FILTERIndex119, LS_FILTER::getNfaNameLS_FILTERIndex120, LS_FILTER::getNfaNameLS_FILTERIndex121, LS_FILTER::getNfaNameLS_FILTERIndex122, LS_FILTER::getNfaNameLS_FILTERIndex123, LS_FILTER::getNfaNameLS_FILTERIndex124, LS_FILTER::getNfaNameLS_FILTERIndex125, LS_FILTER::getNfaNameLS_FILTERIndex126, LS_FILTER::getNfaNameLS_FILTERIndex127, LS_FILTER::getNfaNameLS_FILTERIndex128, LS_FILTER::getNfaNameLS_FILTERIndex129, LS_FILTER::getNfaNameLS_FILTERIndex130, LS_FILTER::getNfaNameLS_FILTERIndex131, LS_FILTER::getNfaNameLS_FILTERIndex132, LS_FILTER::getNfaNameLS_FILTERIndex133, LS_FILTER::getNfaNameLS_FILTERIndex134, LS_FILTER::getNfaNameLS_FILTERIndex135, LS_FILTER::getNfaNameLS_FILTERIndex136, LS_FILTER::getNfaNameLS_FILTERIndex137, LS_FILTER::getNfaNameLS_FILTERIndex138, LS_FILTER::getNfaNameLS_FILTERIndex139, LS_FILTER::getNfaNameLS_FILTERIndex140, LS_FILTER::getNfaNameLS_FILTERIndex141, LS_FILTER::getNfaNameLS_FILTERIndex142, LS_FILTER::getNfaNameLS_FILTERIndex143, LS_FILTER::getNfaNameLS_FILTERIndex144, LS_FILTER::getNfaNameLS_FILTERIndex145, LS_FILTER::getNfaNameLS_FILTERIndex146, LS_FILTER::getNfaNameLS_FILTERIndex147, LS_FILTER::getNfaNameLS_FILTERIndex148, LS_FILTER::getNfaNameLS_FILTERIndex149, LS_FILTER::getNfaNameLS_FILTERIndex150, LS_FILTER::getNfaNameLS_FILTERIndex151, LS_FILTER::getNfaNameLS_FILTERIndex152, LS_FILTER::getNfaNameLS_FILTERIndex153, LS_FILTER::getNfaNameLS_FILTERIndex154, LS_FILTER::getNfaNameLS_FILTERIndex155, LS_FILTER::getNfaNameLS_FILTERIndex156, LS_FILTER::getNfaNameLS_FILTERIndex157, LS_FILTER::getNfaNameLS_FILTERIndex158, LS_FILTER::getNfaNameLS_FILTERIndex159, LS_FILTER::getNfaNameLS_FILTERIndex160, LS_FILTER::getNfaNameLS_FILTERIndex161, LS_FILTER::getNfaNameLS_FILTERIndex162, LS_FILTER::getNfaNameLS_FILTERIndex163, LS_FILTER::getNfaNameLS_FILTERIndex164, LS_FILTER::getNfaNameLS_FILTERIndex165, LS_FILTER::getNfaNameLS_FILTERIndex166, LS_FILTER::getNfaNameLS_FILTERIndex167, LS_FILTER::getNfaNameLS_FILTERIndex168, LS_FILTER::getNfaNameLS_FILTERIndex169, LS_FILTER::getNfaNameLS_FILTERIndex170, LS_FILTER::getNfaNameLS_FILTERIndex171, LS_FILTER::getNfaNameLS_FILTERIndex172, LS_FILTER::getNfaNameLS_FILTERIndex173, LS_FILTER::getNfaNameLS_FILTERIndex174, LS_FILTER::getNfaNameLS_FILTERIndex175, LS_FILTER::getNfaNameLS_FILTERIndex176, LS_FILTER::getNfaNameLS_FILTERIndex177, LS_FILTER::getNfaNameLS_FILTERIndex178, LS_FILTER::getNfaNameLS_FILTERIndex179, LS_FILTER::getNfaNameLS_FILTERIndex180, LS_FILTER::getNfaNameLS_FILTERIndex181, LS_FILTER::getNfaNameLS_FILTERIndex182, LS_FILTER::getNfaNameLS_FILTERIndex183, LS_FILTER::getNfaNameLS_FILTERIndex184, LS_FILTER::getNfaNameLS_FILTERIndex185, LS_FILTER::getNfaNameLS_FILTERIndex186, LS_FILTER::getNfaNameLS_FILTERIndex187, LS_FILTER::getNfaNameLS_FILTERIndex188, LS_FILTER::getNfaNameLS_FILTERIndex189, LS_FILTER::getNfaNameLS_FILTERIndex190, LS_FILTER::getNfaNameLS_FILTERIndex191, LS_FILTER::getNfaNameLS_FILTERIndex192, LS_FILTER::getNfaNameLS_FILTERIndex193, LS_FILTER::getNfaNameLS_FILTERIndex194, LS_FILTER::getNfaNameLS_FILTERIndex195, LS_FILTER::getNfaNameLS_FILTERIndex196, LS_FILTER::getNfaNameLS_FILTERIndex197, LS_FILTER::getNfaNameLS_FILTERIndex198, LS_FILTER::getNfaNameLS_FILTERIndex199, LS_FILTER::getNfaNameLS_FILTERIndex200, LS_FILTER::getNfaNameLS_FILTERIndex201, LS_FILTER::getNfaNameLS_FILTERIndex202, LS_FILTER::getNfaNameLS_FILTERIndex203, LS_FILTER::getNfaNameLS_FILTERIndex204, LS_FILTER::getNfaNameLS_FILTERIndex205, LS_FILTER::getNfaNameLS_FILTERIndex206, LS_FILTER::getNfaNameLS_FILTERIndex207, LS_FILTER::getNfaNameLS_FILTERIndex208, LS_FILTER::getNfaNameLS_FILTERIndex209, LS_FILTER::getNfaNameLS_FILTERIndex210, LS_FILTER::getNfaNameLS_FILTERIndex211, LS_FILTER::getNfaNameLS_FILTERIndex212, LS_FILTER::getNfaNameLS_FILTERIndex213, LS_FILTER::getNfaNameLS_FILTERIndex214, LS_FILTER::getNfaNameLS_FILTERIndex215, LS_FILTER::getNfaNameLS_FILTERIndex216, LS_FILTER::getNfaNameLS_FILTERIndex217, LS_FILTER::getNfaNameLS_FILTERIndex218, LS_FILTER::getNfaNameLS_FILTERIndex219, LS_FILTER::getNfaNameLS_FILTERIndex220, LS_FILTER::getNfaNameLS_FILTERIndex221, LS_FILTER::getNfaNameLS_FILTERIndex222, LS_FILTER::getNfaNameLS_FILTERIndex223, LS_FILTER::getNfaNameLS_FILTERIndex224, LS_FILTER::getNfaNameLS_FILTERIndex225, LS_FILTER::getNfaNameLS_FILTERIndex226, LS_FILTER::getNfaNameLS_FILTERIndex227, LS_FILTER::getNfaNameLS_FILTERIndex228, LS_FILTER::getNfaNameLS_FILTERIndex229, LS_FILTER::getNfaNameLS_FILTERIndex230, LS_FILTER::getNfaNameLS_FILTERIndex231, LS_FILTER::getNfaNameLS_FILTERIndex232, LS_FILTER::getNfaNameLS_FILTERIndex233, LS_FILTER::getNfaNameLS_FILTERIndex234, LS_FILTER::getNfaNameLS_FILTERIndex235, LS_FILTER::getNfaNameLS_FILTERIndex236, LS_FILTER::getNfaNameLS_FILTERIndex237, LS_FILTER::getNfaNameLS_FILTERIndex238, LS_FILTER::getNfaNameLS_FILTERIndex239, LS_FILTER::getNfaNameLS_FILTERIndex240, LS_FILTER::getNfaNameLS_FILTERIndex241, LS_FILTER::getNfaNameLS_FILTERIndex242, LS_FILTER::getNfaNameLS_FILTERIndex243, LS_FILTER::getNfaNameLS_FILTERIndex244, LS_FILTER::getNfaNameLS_FILTERIndex245, LS_FILTER::getNfaNameLS_FILTERIndex246, LS_FILTER::getNfaNameLS_FILTERIndex247, LS_FILTER::getNfaNameLS_FILTERIndex248, LS_FILTER::getNfaNameLS_FILTERIndex249, LS_FILTER::getNfaNameLS_FILTERIndex250, LS_FILTER::getNfaNameLS_FILTERIndex251, LS_FILTER::getNfaNameLS_FILTERIndex252, LS_FILTER::getNfaNameLS_FILTERIndex253, LS_FILTER::getNfaNameLS_FILTERIndex254, LS_FILTER::getNfaNameLS_FILTERIndex255, LS_FILTER::getNfaNameLS_FILTERIndex256, LS_FILTER::getNfaNameLS_FILTERIndex257, LS_FILTER::getNfaNameLS_FILTERIndex258, LS_FILTER::getNfaNameLS_FILTERIndex259, LS_FILTER::getNfaNameLS_FILTERIndex260, LS_FILTER::getNfaNameLS_FILTERIndex261, LS_FILTER::getNfaNameLS_FILTERIndex262, LS_FILTER::getNfaNameLS_FILTERIndex263, LS_FILTER::getNfaNameLS_FILTERIndex264, LS_FILTER::getNfaNameLS_FILTERIndex265, LS_FILTER::getNfaNameLS_FILTERIndex266, LS_FILTER::getNfaNameLS_FILTERIndex267, LS_FILTER::getNfaNameLS_FILTERIndex268, LS_FILTER::getNfaNameLS_FILTERIndex269, LS_FILTER::getNfaNameLS_FILTERIndex270, LS_FILTER::getNfaNameLS_FILTERIndex271, LS_FILTER::getNfaNameLS_FILTERIndex272, LS_FILTER::getNfaNameLS_FILTERIndex273, LS_FILTER::getNfaNameLS_FILTERIndex274, LS_FILTER::getNfaNameLS_FILTERIndex275, LS_FILTER::getNfaNameLS_FILTERIndex276, LS_FILTER::getNfaNameLS_FILTERIndex277, LS_FILTER::getNfaNameLS_FILTERIndex278, LS_FILTER::getNfaNameLS_FILTERIndex279, LS_FILTER::getNfaNameLS_FILTERIndex280, LS_FILTER::getNfaNameLS_FILTERIndex281, LS_FILTER::getNfaNameLS_FILTERIndex282, LS_FILTER::getNfaNameLS_FILTERIndex283, LS_FILTER::getNfaNameLS_FILTERIndex284, LS_FILTER::getNfaNameLS_FILTERIndex285, LS_FILTER::getNfaNameLS_FILTERIndex286, LS_FILTER::getNfaNameLS_FILTERIndex287, LS_FILTER::getNfaNameLS_FILTERIndex288, LS_FILTER::getNfaNameLS_FILTERIndex289, LS_FILTER::getNfaNameLS_FILTERIndex290, LS_FILTER::getNfaNameLS_FILTERIndex291, LS_FILTER::getNfaNameLS_FILTERIndex292, LS_FILTER::getNfaNameLS_FILTERIndex293, LS_FILTER::getNfaNameLS_FILTERIndex294, LS_FILTER::getNfaNameLS_FILTERIndex295, LS_FILTER::getNfaNameLS_FILTERIndex296, LS_FILTER::getNfaNameLS_FILTERIndex297, LS_FILTER::getNfaNameLS_FILTERIndex298, LS_FILTER::getNfaNameLS_FILTERIndex299, LS_FILTER::getNfaNameLS_FILTERIndex300, LS_FILTER::getNfaNameLS_FILTERIndex301, LS_FILTER::getNfaNameLS_FILTERIndex302, LS_FILTER::getNfaNameLS_FILTERIndex303, LS_FILTER::getNfaNameLS_FILTERIndex304, LS_FILTER::getNfaNameLS_FILTERIndex305, LS_FILTER::getNfaNameLS_FILTERIndex306, LS_FILTER::getNfaNameLS_FILTERIndex307, LS_FILTER::getNfaNameLS_FILTERIndex308, LS_FILTER::getNfaNameLS_FILTERIndex309, LS_FILTER::getNfaNameLS_FILTERIndex310, LS_FILTER::getNfaNameLS_FILTERIndex311, LS_FILTER::getNfaNameLS_FILTERIndex312, LS_FILTER::getNfaNameLS_FILTERIndex313, LS_FILTER::getNfaNameLS_FILTERIndex314, LS_FILTER::getNfaNameLS_FILTERIndex315, LS_FILTER::getNfaNameLS_FILTERIndex316, LS_FILTER::getNfaNameLS_FILTERIndex317, LS_FILTER::getNfaNameLS_FILTERIndex318, LS_FILTER::getNfaNameLS_FILTERIndex319, LS_FILTER::getNfaNameLS_FILTERIndex320, LS_FILTER::getNfaNameLS_FILTERIndex321, LS_FILTER::getNfaNameLS_FILTERIndex322, LS_FILTER::getNfaNameLS_FILTERIndex323, LS_FILTER::getNfaNameLS_FILTERIndex324, LS_FILTER::getNfaNameLS_FILTERIndex325, LS_FILTER::getNfaNameLS_FILTERIndex326, LS_FILTER::getNfaNameLS_FILTERIndex327, LS_FILTER::getNfaNameLS_FILTERIndex328, LS_FILTER::getNfaNameLS_FILTERIndex329, LS_FILTER::getNfaNameLS_FILTERIndex330, LS_FILTER::getNfaNameLS_FILTERIndex331, LS_FILTER::getNfaNameLS_FILTERIndex332, LS_FILTER::getNfaNameLS_FILTERIndex333, LS_FILTER::getNfaNameLS_FILTERIndex334, LS_FILTER::getNfaNameLS_FILTERIndex335, LS_FILTER::getNfaNameLS_FILTERIndex336, LS_FILTER::getNfaNameLS_FILTERIndex337, LS_FILTER::getNfaNameLS_FILTERIndex338, LS_FILTER::getNfaNameLS_FILTERIndex339, LS_FILTER::getNfaNameLS_FILTERIndex340, LS_FILTER::getNfaNameLS_FILTERIndex341, LS_FILTER::getNfaNameLS_FILTERIndex342, LS_FILTER::getNfaNameLS_FILTERIndex343, LS_FILTER::getNfaNameLS_FILTERIndex344, LS_FILTER::getNfaNameLS_FILTERIndex345, LS_FILTER::getNfaNameLS_FILTERIndex346, LS_FILTER::getNfaNameLS_FILTERIndex347, LS_FILTER::getNfaNameLS_FILTERIndex348, LS_FILTER::getNfaNameLS_FILTERIndex349, LS_FILTER::getNfaNameLS_FILTERIndex350, LS_FILTER::getNfaNameLS_FILTERIndex351, LS_FILTER::getNfaNameLS_FILTERIndex352, LS_FILTER::getNfaNameLS_FILTERIndex353, LS_FILTER::getNfaNameLS_FILTERIndex354, LS_FILTER::getNfaNameLS_FILTERIndex355, LS_FILTER::getNfaNameLS_FILTERIndex356, LS_FILTER::getNfaNameLS_FILTERIndex357, LS_FILTER::getNfaNameLS_FILTERIndex358, LS_FILTER::getNfaNameLS_FILTERIndex359, LS_FILTER::getNfaNameLS_FILTERIndex360, LS_FILTER::getNfaNameLS_FILTERIndex361, LS_FILTER::getNfaNameLS_FILTERIndex362, LS_FILTER::getNfaNameLS_FILTERIndex363, LS_FILTER::getNfaNameLS_FILTERIndex364, LS_FILTER::getNfaNameLS_FILTERIndex365, LS_FILTER::getNfaNameLS_FILTERIndex366, LS_FILTER::getNfaNameLS_FILTERIndex367, LS_FILTER::getNfaNameLS_FILTERIndex368, LS_FILTER::getNfaNameLS_FILTERIndex369, LS_FILTER::getNfaNameLS_FILTERIndex370, LS_FILTER::getNfaNameLS_FILTERIndex371, LS_FILTER::getNfaNameLS_FILTERIndex372, LS_FILTER::getNfaNameLS_FILTERIndex373, LS_FILTER::getNfaNameLS_FILTERIndex374, LS_FILTER::getNfaNameLS_FILTERIndex375, LS_FILTER::getNfaNameLS_FILTERIndex376, LS_FILTER::getNfaNameLS_FILTERIndex377, LS_FILTER::getNfaNameLS_FILTERIndex378, LS_FILTER::getNfaNameLS_FILTERIndex379, LS_FILTER::getNfaNameLS_FILTERIndex380, LS_FILTER::getNfaNameLS_FILTERIndex381, LS_FILTER::getNfaNameLS_FILTERIndex382, LS_FILTER::getNfaNameLS_FILTERIndex383, LS_FILTER::getNfaNameLS_FILTERIndex384, LS_FILTER::getNfaNameLS_FILTERIndex385, LS_FILTER::getNfaNameLS_FILTERIndex386, LS_FILTER::getNfaNameLS_FILTERIndex387, LS_FILTER::getNfaNameLS_FILTERIndex388, LS_FILTER::getNfaNameLS_FILTERIndex389, LS_FILTER::getNfaNameLS_FILTERIndex390, LS_FILTER::getNfaNameLS_FILTERIndex391, LS_FILTER::getNfaNameLS_FILTERIndex392, LS_FILTER::getNfaNameLS_FILTERIndex393, LS_FILTER::getNfaNameLS_FILTERIndex394, LS_FILTER::getNfaNameLS_FILTERIndex395, LS_FILTER::getNfaNameLS_FILTERIndex396};
            functionTableMap.put(LexicalState.LS_FILTER, functions2);
        }
    }

    private static class LS_CONSTANTS {
        private LS_CONSTANTS() {
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 39) {
                nextStates.set(40);
            } else if (ch == 43 || ch == 45) {
                nextStates.set(209);
                nextStates.set(210);
                nextStates.set(212);
                nextStates.set(220);
                nextStates.set(274);
                nextStates.set(285);
            } else if (ch == 48) {
                nextStates.set(1);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(160);
                nextStates.set(161);
                nextStates.set(211);
            }
            if (ch == 49) {
                nextStates.set(284);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(10);
                nextStates.set(42);
                nextStates.set(179);
                nextStates.set(218);
                nextStates.set(275);
            }
            if (ch == 50) {
                nextStates.set(273);
            } else if (ch == 68 || ch == 100) {
                nextStates.set(221);
            } else if (ch == 70 || ch == 102) {
                nextStates.set(280);
            } else if (ch == 71 || ch == 103) {
                nextStates.set(169);
            } else if (ch == 78 || ch == 110) {
                nextStates.set(286);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(43);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(277);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(213);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_LONG)) {
                    type = Token.TokenType.T_LONG;
                }
            } else if (ch == 41) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_RB)) {
                    type = Token.TokenType.T_RB;
                }
            } else if (ch == 40) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_LB)) {
                    type = Token.TokenType.T_LB;
                }
            } else if (ch == 44) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_VALUE_SEPARATOR)) {
                    type = Token.TokenType.T_VALUE_SEPARATOR;
                }
            } else if (ch == 9) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_4)) {
                    type = Token.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_3)) {
                    type = Token.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_2)) {
                    type = Token.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_1))) {
                type = Token.TokenType._TOKEN_1;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(2);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 58) {
                nextStates.set(3);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 53) {
                nextStates.set(4);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(5);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_TIME)) {
                    type = Token.TokenType.T_TIME;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 58) {
                nextStates.set(6);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 53) {
                nextStates.set(7);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(8);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_TIME)) {
                    type = Token.TokenType.T_TIME;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 44) {
                nextStates.set(9);
            } else if (ch == 46) {
                nextStates.set(9);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(9);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_TIME)) {
                    type = Token.TokenType.T_TIME;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(11);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(12);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(11);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48) {
                nextStates.set(39);
            } else if (ch == 49) {
                nextStates.set(13);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 50) {
                nextStates.set(14);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(15);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 50) {
                nextStates.set(16);
            } else if (ch == 51) {
                nextStates.set(38);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(17);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(18);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48) {
                nextStates.set(37);
            } else if (ch == 49) {
                nextStates.set(36);
            } else if (ch == 50) {
                nextStates.set(19);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 51) {
                nextStates.set(20);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 58) {
                nextStates.set(21);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 53) {
                nextStates.set(22);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(23);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(29);
            } else if (ch == 58) {
                nextStates.set(24);
            } else if (!(ch != 90 && ch != 122 || validTypes != null && !validTypes.contains(Token.TokenType.T_DATETIME))) {
                type = Token.TokenType.T_DATETIME;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 53) {
                nextStates.set(25);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(26);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(29);
            } else if (ch == 44) {
                nextStates.set(27);
            } else if (ch == 46) {
                nextStates.set(27);
            } else if (!(ch != 90 && ch != 122 || validTypes != null && !validTypes.contains(Token.TokenType.T_DATETIME))) {
                type = Token.TokenType.T_DATETIME;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(28);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(29);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(28);
            } else if (!(ch != 90 && ch != 122 || validTypes != null && !validTypes.contains(Token.TokenType.T_DATETIME))) {
                type = Token.TokenType.T_DATETIME;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48) {
                nextStates.set(35);
            } else if (ch == 49) {
                nextStates.set(30);
            } else if (ch == 50) {
                nextStates.set(34);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(31);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 58) {
                nextStates.set(32);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 53) {
                nextStates.set(33);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 && (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIME))) {
                type = Token.TokenType.T_DATETIME;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 51) {
                nextStates.set(31);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(31);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(20);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(20);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48 || ch == 49) {
                nextStates.set(17);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(14);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(40);
            } else if (ch == 39) {
                nextStates.set(41);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_STR_LIT)) {
                    type = Token.TokenType.T_STR_LIT;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 39) {
                nextStates.set(40);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(42);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_LONG)) {
                    type = Token.TokenType.T_LONG;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(147);
                nextStates.set(150);
                nextStates.set(153);
                nextStates.set(159);
            } else if (ch == 47) {
                nextStates.set(56);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(148);
                nextStates.set(154);
                nextStates.set(146);
                nextStates.set(151);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(44);
                nextStates.set(47);
                nextStates.set(157);
                nextStates.set(155);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(50);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(45);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex45(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(45);
            } else if (ch == 87 || ch == 119) {
                nextStates.set(46);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex46(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(147);
            } else if (ch == 47) {
                nextStates.set(56);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(146);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(47);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(50);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex47(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(48);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex48(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(48);
            } else if (ch == 68 || ch == 100) {
                nextStates.set(49);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex49(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 47) {
                nextStates.set(56);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(50);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex50(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(145);
                nextStates.set(140);
                nextStates.set(53);
            } else if (ch == 47) {
                nextStates.set(56);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(51);
                nextStates.set(138);
                nextStates.set(54);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(143);
                nextStates.set(141);
                nextStates.set(136);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex51(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77 || ch == 109) {
                nextStates.set(52);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex52(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(53);
            } else if (ch == 47) {
                nextStates.set(56);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(54);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(136);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex53(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(54);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(136);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex54(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(131);
            } else if (ch == 83 || ch == 115) {
                nextStates.set(55);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex55(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 47) {
                nextStates.set(56);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex56(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(129);
                nextStates.set(130);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(57);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(127);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(86);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex57(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(58);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex58(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48) {
                nextStates.set(59);
            } else if (ch == 49) {
                nextStates.set(85);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex59(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(60);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex60(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(61);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex61(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 50) {
                nextStates.set(84);
            } else if (ch == 51) {
                nextStates.set(62);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex62(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48 || ch == 49) {
                nextStates.set(63);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex63(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(64);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex64(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48) {
                nextStates.set(82);
            } else if (ch == 49) {
                nextStates.set(83);
            } else if (ch == 50) {
                nextStates.set(65);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex65(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 51) {
                nextStates.set(66);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex66(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 58) {
                nextStates.set(67);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex67(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 53) {
                nextStates.set(68);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex68(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(69);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex69(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(70);
            } else if (ch == 58) {
                nextStates.set(77);
            } else if (!(ch != 90 && ch != 122 || validTypes != null && !validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL))) {
                type = Token.TokenType.T_DATETIMEINTERVAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex70(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48) {
                nextStates.set(75);
            } else if (ch == 49) {
                nextStates.set(71);
            } else if (ch == 50) {
                nextStates.set(76);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex71(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(72);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex72(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 58) {
                nextStates.set(73);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex73(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 53) {
                nextStates.set(74);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex74(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 && (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL))) {
                type = Token.TokenType.T_DATETIMEINTERVAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex75(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(72);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex76(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 51) {
                nextStates.set(72);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex77(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 53) {
                nextStates.set(78);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex78(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(79);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex79(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(70);
            } else if (ch == 44) {
                nextStates.set(80);
            } else if (ch == 46) {
                nextStates.set(80);
            } else if (!(ch != 90 && ch != 122 || validTypes != null && !validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL))) {
                type = Token.TokenType.T_DATETIMEINTERVAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex80(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(81);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex81(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(70);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(81);
            } else if (!(ch != 90 && ch != 122 || validTypes != null && !validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL))) {
                type = Token.TokenType.T_DATETIMEINTERVAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex82(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(66);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex83(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(66);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex84(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(63);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex85(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 50) {
                nextStates.set(60);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex86(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(119);
                nextStates.set(115);
                nextStates.set(125);
                nextStates.set(117);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(87);
                nextStates.set(118);
                nextStates.set(126);
                nextStates.set(116);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(112);
                nextStates.set(122);
                nextStates.set(120);
                nextStates.set(89);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(92);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex87(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77 || ch == 109) {
                nextStates.set(88);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex88(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(117);
                nextStates.set(115);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(118);
                nextStates.set(116);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(89);
                nextStates.set(112);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(92);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex89(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(90);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex90(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(90);
            } else if (ch == 68 || ch == 100) {
                nextStates.set(91);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex91(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(92);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex92(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(100);
                nextStates.set(102);
                nextStates.set(111);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(107);
                nextStates.set(106);
                nextStates.set(101);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(93);
                nextStates.set(103);
                nextStates.set(109);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex93(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(94);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex94(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(95);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(94);
            } else if (!(ch != 83 && ch != 115 || validTypes != null && !validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL))) {
                type = Token.TokenType.T_DATETIMEINTERVAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex95(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(99);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(96);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(97);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex96(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 83 && ch != 115 || validTypes != null && !validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL))) {
                type = Token.TokenType.T_DATETIMEINTERVAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex97(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(98);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex98(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(98);
            } else if (!(ch != 83 && ch != 115 || validTypes != null && !validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL))) {
                type = Token.TokenType.T_DATETIMEINTERVAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex99(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(96);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(97);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex100(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(101);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(93);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex101(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(95);
            } else if (!(ch != 83 && ch != 115 || validTypes != null && !validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL))) {
                type = Token.TokenType.T_DATETIMEINTERVAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex102(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(106);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(103);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex103(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(104);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex104(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(104);
            } else if (ch == 77 || ch == 109) {
                nextStates.set(105);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex105(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(100);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(101);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(93);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex106(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77 || ch == 109) {
                nextStates.set(105);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex107(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 72 || ch == 104) {
                nextStates.set(108);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex108(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(100);
                nextStates.set(102);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(106);
                nextStates.set(101);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(93);
                nextStates.set(103);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex109(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(110);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex110(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(110);
            } else if (ch == 72 || ch == 104) {
                nextStates.set(108);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex111(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(107);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(109);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex112(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(113);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex113(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(113);
            } else if (ch == 87 || ch == 119) {
                nextStates.set(114);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex114(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(115);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(116);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(89);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(92);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex115(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(116);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(89);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex116(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(91);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex117(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(118);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(112);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex118(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 87 || ch == 119) {
                nextStates.set(114);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex119(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(87);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(120);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex120(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(121);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex121(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(121);
            } else if (ch == 77 || ch == 109) {
                nextStates.set(88);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex122(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(123);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex123(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(123);
            } else if (ch == 89 || ch == 121) {
                nextStates.set(124);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex124(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(119);
                nextStates.set(117);
                nextStates.set(115);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(87);
                nextStates.set(118);
                nextStates.set(116);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(89);
                nextStates.set(112);
                nextStates.set(120);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(92);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex125(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(126);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(122);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex126(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 89 || ch == 121) {
                nextStates.set(124);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex127(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(128);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex128(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(58);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(128);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex129(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(86);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DATETIMEINTERVAL)) {
                    type = Token.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex130(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(57);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(127);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex131(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(132);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(135);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(133);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex132(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(135);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(133);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex133(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(134);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex134(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(134);
            } else if (ch == 83 || ch == 115) {
                nextStates.set(55);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex135(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(55);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex136(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(137);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex137(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(131);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(137);
            } else if (ch == 83 || ch == 115) {
                nextStates.set(55);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex138(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 72 || ch == 104) {
                nextStates.set(139);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex139(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(140);
                nextStates.set(53);
            } else if (ch == 47) {
                nextStates.set(56);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(51);
                nextStates.set(54);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(141);
                nextStates.set(136);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex140(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(51);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(141);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex141(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(142);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex142(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(142);
            } else if (ch == 77 || ch == 109) {
                nextStates.set(52);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex143(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(144);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex144(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(144);
            } else if (ch == 72 || ch == 104) {
                nextStates.set(139);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex145(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(138);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(143);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex146(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(49);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex147(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(146);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(47);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex148(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 89 || ch == 121) {
                nextStates.set(149);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex149(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(150);
                nextStates.set(153);
                nextStates.set(147);
            } else if (ch == 47) {
                nextStates.set(56);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(154);
                nextStates.set(146);
                nextStates.set(151);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(44);
                nextStates.set(47);
                nextStates.set(155);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(50);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex150(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(151);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(155);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex151(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77 || ch == 109) {
                nextStates.set(152);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex152(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(153);
                nextStates.set(147);
            } else if (ch == 47) {
                nextStates.set(56);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(154);
                nextStates.set(146);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(44);
                nextStates.set(47);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(50);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex153(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(154);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(44);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex154(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 87 || ch == 119) {
                nextStates.set(46);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex155(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(156);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex156(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(156);
            } else if (ch == 77 || ch == 109) {
                nextStates.set(152);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex157(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(158);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex158(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(158);
            } else if (ch == 89 || ch == 121) {
                nextStates.set(149);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex159(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(148);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(157);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex160(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(12);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex161(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(162);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex162(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48) {
                nextStates.set(163);
            } else if (ch == 49) {
                nextStates.set(168);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex163(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(164);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex164(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(165);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex165(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 50) {
                nextStates.set(167);
            } else if (ch == 51) {
                nextStates.set(166);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex166(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 48 && ch != 49 || validTypes != null && !validTypes.contains(Token.TokenType.T_DATE))) {
                type = Token.TokenType.T_DATE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex167(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 && (validTypes == null || validTypes.contains(Token.TokenType.T_DATE))) {
                type = Token.TokenType.T_DATE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex168(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 50) {
                nextStates.set(164);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex169(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(170);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex170(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(171);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex171(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 71 || ch == 103) {
                nextStates.set(172);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex172(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(173);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex173(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(174);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex174(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(175);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex175(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 72 || ch == 104) {
                nextStates.set(176);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex176(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 89 || ch == 121) {
                nextStates.set(177);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex177(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 39) {
                nextStates.set(178);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex178(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(178);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.T_GEO_STR_LIT))) {
                type = Token.TokenType.T_GEO_STR_LIT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex179(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(180);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex180(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(181);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(180);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex181(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48) {
                nextStates.set(208);
            } else if (ch == 49) {
                nextStates.set(182);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex182(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 50) {
                nextStates.set(183);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex183(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(184);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex184(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 50) {
                nextStates.set(207);
            } else if (ch == 51) {
                nextStates.set(185);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex185(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48 || ch == 49) {
                nextStates.set(186);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex186(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(187);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex187(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48) {
                nextStates.set(188);
            } else if (ch == 49) {
                nextStates.set(205);
            } else if (ch == 50) {
                nextStates.set(206);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex188(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(189);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex189(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 58) {
                nextStates.set(190);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex190(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 53) {
                nextStates.set(191);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex191(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(192);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex192(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(193);
            } else if (ch == 58) {
                nextStates.set(200);
            } else if (ch == 90 || ch == 122) {
                nextStates.set(55);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex193(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48) {
                nextStates.set(194);
            } else if (ch == 49) {
                nextStates.set(199);
            } else if (ch == 50) {
                nextStates.set(198);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex194(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(195);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex195(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 58) {
                nextStates.set(196);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex196(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 53) {
                nextStates.set(197);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex197(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(55);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex198(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 51) {
                nextStates.set(195);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex199(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(195);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex200(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 53) {
                nextStates.set(201);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex201(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(202);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex202(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(193);
            } else if (ch == 44) {
                nextStates.set(203);
            } else if (ch == 46) {
                nextStates.set(203);
            } else if (ch == 90 || ch == 122) {
                nextStates.set(55);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex203(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(204);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex204(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(193);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(204);
            } else if (ch == 90 || ch == 122) {
                nextStates.set(55);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex205(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(189);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex206(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 51) {
                nextStates.set(189);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex207(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(186);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex208(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(183);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex209(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 49 && ch <= 57) {
                nextStates.set(42);
            }
            if (ch >= 48 && ch <= 57 && (validTypes == null || validTypes.contains(Token.TokenType.T_LONG))) {
                type = Token.TokenType.T_LONG;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex210(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(211);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(179);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex211(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(181);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex212(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 49 && ch <= 57) {
                nextStates.set(218);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(213);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DOUBLE)) {
                    type = Token.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex213(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(214);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(216);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex214(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(215);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DOUBLE)) {
                    type = Token.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex215(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(216);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(215);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DOUBLE)) {
                    type = Token.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex216(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(217);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(217);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DOUBLE)) {
                    type = Token.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex217(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(217);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DOUBLE)) {
                    type = Token.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex218(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(219);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DOUBLE)) {
                    type = Token.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex219(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(214);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(216);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(219);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DOUBLE)) {
                    type = Token.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex220(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(43);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex221(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(222);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex222(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(223);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex223(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(224);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex224(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(225);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex225(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(226);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex226(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 79 || ch == 111) {
                nextStates.set(227);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex227(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(228);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex228(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 39) {
                nextStates.set(229);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex229(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(230);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(231);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex230(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 80 || ch == 112) {
                nextStates.set(231);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex231(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(268);
                nextStates.set(263);
                nextStates.set(272);
                nextStates.set(262);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(232);
                nextStates.set(269);
                nextStates.set(234);
                nextStates.set(267);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(270);
                nextStates.set(257);
                nextStates.set(264);
                nextStates.set(260);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(236);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.T_DURATION))) {
                type = Token.TokenType.T_DURATION;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex232(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 89 || ch == 121) {
                nextStates.set(233);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex233(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(263);
                nextStates.set(268);
                nextStates.set(262);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(234);
                nextStates.set(267);
                nextStates.set(269);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(257);
                nextStates.set(264);
                nextStates.set(260);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(236);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.T_DURATION))) {
                type = Token.TokenType.T_DURATION;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex234(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(235);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex235(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(236);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.T_DURATION))) {
                type = Token.TokenType.T_DURATION;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex236(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(237);
                nextStates.set(241);
                nextStates.set(245);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(256);
                nextStates.set(246);
                nextStates.set(255);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(242);
                nextStates.set(238);
                nextStates.set(253);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.T_DURATION))) {
                type = Token.TokenType.T_DURATION;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex237(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(256);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(238);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex238(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(239);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex239(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(239);
            } else if (ch == 72 || ch == 104) {
                nextStates.set(240);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex240(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(241);
                nextStates.set(245);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(246);
                nextStates.set(255);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(242);
                nextStates.set(253);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.T_DURATION))) {
                type = Token.TokenType.T_DURATION;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex241(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(255);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(242);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex242(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(243);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex243(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(243);
            } else if (ch == 77 || ch == 109) {
                nextStates.set(244);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex244(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(245);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(246);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(253);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.T_DURATION))) {
                type = Token.TokenType.T_DURATION;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex245(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(246);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(253);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex246(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(247);
            } else if (ch == 83 || ch == 115) {
                nextStates.set(250);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex247(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(252);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(251);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(248);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex248(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(249);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex249(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(249);
            } else if (ch == 83 || ch == 115) {
                nextStates.set(250);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex250(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.T_DURATION))) {
                type = Token.TokenType.T_DURATION;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex251(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(250);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex252(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(251);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(248);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex253(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(254);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex254(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(247);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(254);
            } else if (ch == 83 || ch == 115) {
                nextStates.set(250);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex255(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77 || ch == 109) {
                nextStates.set(244);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex256(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 72 || ch == 104) {
                nextStates.set(240);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex257(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(258);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex258(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(258);
            } else if (ch == 87 || ch == 119) {
                nextStates.set(259);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex259(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(262);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(234);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(260);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(236);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.T_DURATION))) {
                type = Token.TokenType.T_DURATION;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex260(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(261);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex261(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(261);
            } else if (ch == 68 || ch == 100) {
                nextStates.set(235);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex262(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(234);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(260);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex263(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(269);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(264);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex264(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(265);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex265(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(265);
            } else if (ch == 77 || ch == 109) {
                nextStates.set(266);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex266(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(268);
                nextStates.set(262);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(234);
                nextStates.set(267);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(257);
                nextStates.set(260);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(236);
            } else if (ch == 39 && (validTypes == null || validTypes.contains(Token.TokenType.T_DURATION))) {
                type = Token.TokenType.T_DURATION;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex267(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 87 || ch == 119) {
                nextStates.set(259);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex268(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(267);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(257);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex269(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 77 || ch == 109) {
                nextStates.set(266);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex270(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(271);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex271(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(271);
            } else if (ch == 89 || ch == 121) {
                nextStates.set(233);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex272(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(232);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(270);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex273(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 51) {
                nextStates.set(2);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex274(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(161);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(275);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex275(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(276);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex276(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(162);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(276);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex277(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(278);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex278(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(279);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex279(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 69 && ch != 101 || validTypes != null && !validTypes.contains(Token.TokenType.T_BOOL))) {
                type = Token.TokenType.T_BOOL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex280(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(281);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex281(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(282);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex282(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(283);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex283(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 69 && ch != 101 || validTypes != null && !validTypes.contains(Token.TokenType.T_BOOL))) {
                type = Token.TokenType.T_BOOL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex284(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(2);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex285(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(160);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(10);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex286(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(287);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex287(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(288);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_CONSTANTSIndex288(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 76 && ch != 108 || validTypes != null && !validTypes.contains(Token.TokenType.T_NULL))) {
                type = Token.TokenType.T_NULL;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions2 = new NfaFunction[]{LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex0, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex1, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex2, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex3, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex4, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex5, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex6, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex7, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex8, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex9, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex10, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex11, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex12, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex13, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex14, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex15, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex16, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex17, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex18, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex19, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex20, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex21, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex22, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex23, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex24, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex25, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex26, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex27, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex28, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex29, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex30, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex31, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex32, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex33, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex34, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex35, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex36, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex37, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex38, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex39, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex40, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex41, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex42, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex43, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex44, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex45, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex46, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex47, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex48, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex49, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex50, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex51, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex52, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex53, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex54, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex55, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex56, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex57, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex58, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex59, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex60, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex61, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex62, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex63, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex64, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex65, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex66, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex67, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex68, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex69, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex70, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex71, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex72, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex73, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex74, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex75, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex76, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex77, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex78, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex79, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex80, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex81, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex82, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex83, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex84, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex85, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex86, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex87, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex88, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex89, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex90, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex91, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex92, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex93, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex94, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex95, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex96, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex97, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex98, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex99, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex100, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex101, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex102, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex103, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex104, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex105, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex106, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex107, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex108, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex109, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex110, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex111, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex112, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex113, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex114, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex115, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex116, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex117, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex118, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex119, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex120, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex121, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex122, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex123, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex124, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex125, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex126, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex127, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex128, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex129, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex130, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex131, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex132, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex133, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex134, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex135, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex136, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex137, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex138, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex139, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex140, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex141, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex142, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex143, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex144, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex145, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex146, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex147, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex148, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex149, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex150, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex151, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex152, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex153, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex154, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex155, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex156, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex157, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex158, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex159, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex160, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex161, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex162, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex163, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex164, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex165, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex166, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex167, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex168, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex169, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex170, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex171, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex172, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex173, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex174, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex175, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex176, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex177, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex178, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex179, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex180, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex181, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex182, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex183, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex184, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex185, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex186, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex187, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex188, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex189, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex190, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex191, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex192, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex193, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex194, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex195, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex196, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex197, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex198, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex199, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex200, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex201, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex202, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex203, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex204, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex205, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex206, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex207, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex208, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex209, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex210, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex211, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex212, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex213, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex214, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex215, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex216, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex217, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex218, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex219, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex220, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex221, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex222, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex223, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex224, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex225, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex226, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex227, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex228, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex229, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex230, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex231, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex232, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex233, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex234, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex235, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex236, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex237, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex238, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex239, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex240, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex241, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex242, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex243, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex244, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex245, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex246, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex247, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex248, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex249, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex250, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex251, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex252, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex253, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex254, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex255, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex256, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex257, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex258, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex259, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex260, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex261, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex262, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex263, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex264, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex265, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex266, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex267, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex268, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex269, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex270, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex271, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex272, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex273, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex274, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex275, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex276, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex277, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex278, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex279, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex280, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex281, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex282, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex283, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex284, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex285, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex286, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex287, LS_CONSTANTS::getNfaNameLS_CONSTANTSIndex288};
            functionTableMap.put(LexicalState.LS_CONSTANTS, functions2);
        }
    }

    private static class LS_PLAIN_PATH {
        private LS_PLAIN_PATH() {
        }

        private static Token.TokenType getNfaNameLS_PLAIN_PATHIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 36) {
                nextStates.set(5);
            } else if (ch == 65 || ch == 97) {
                nextStates.set(1);
            } else if (ch == 91) {
                nextStates.set(7);
            }
            if (ch == 45 || ch == 46 || ch >= 48 && ch <= 57 || ch >= 64 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(4);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_CHARSEQ)) {
                    type = Token.TokenType.T_CHARSEQ;
                }
            } else if (ch == 41) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_RB)) {
                    type = Token.TokenType.T_RB;
                }
            } else if (ch == 40) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_LB)) {
                    type = Token.TokenType.T_LB;
                }
            } else if (ch == 58) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_COLON)) {
                    type = Token.TokenType.T_COLON;
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_PATH_SEPARATOR)) {
                    type = Token.TokenType.T_PATH_SEPARATOR;
                }
            } else if (ch == 9) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_4)) {
                    type = Token.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_3)) {
                    type = Token.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_2)) {
                    type = Token.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_1))) {
                type = Token.TokenType._TOKEN_1;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_PLAIN_PATHIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(2);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_PLAIN_PATHIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 89 || ch == 121) {
                nextStates.set(3);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_PLAIN_PATHIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.T_ANY))) {
                type = Token.TokenType.T_ANY;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_PLAIN_PATHIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45 || ch == 46 || ch >= 48 && ch <= 57 || ch >= 64 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(4);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_CHARSEQ)) {
                    type = Token.TokenType.T_CHARSEQ;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_PLAIN_PATHIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(6);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_PLAIN_PATHIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 84 && ch != 116 || validTypes != null && !validTypes.contains(Token.TokenType.T_IT))) {
                type = Token.TokenType.T_IT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_PLAIN_PATHIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(11);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(10);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(8);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_PLAIN_PATHIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(9);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_PLAIN_PATHIndex9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(9);
            } else if (ch == 93 && (validTypes == null || validTypes.contains(Token.TokenType.T_ARRAYINDEX))) {
                type = Token.TokenType.T_ARRAYINDEX;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_PLAIN_PATHIndex10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 93 && (validTypes == null || validTypes.contains(Token.TokenType.T_ARRAYINDEX))) {
                type = Token.TokenType.T_ARRAYINDEX;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_PLAIN_PATHIndex11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(10);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(8);
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions2 = new NfaFunction[]{LS_PLAIN_PATH::getNfaNameLS_PLAIN_PATHIndex0, LS_PLAIN_PATH::getNfaNameLS_PLAIN_PATHIndex1, LS_PLAIN_PATH::getNfaNameLS_PLAIN_PATHIndex2, LS_PLAIN_PATH::getNfaNameLS_PLAIN_PATHIndex3, LS_PLAIN_PATH::getNfaNameLS_PLAIN_PATHIndex4, LS_PLAIN_PATH::getNfaNameLS_PLAIN_PATHIndex5, LS_PLAIN_PATH::getNfaNameLS_PLAIN_PATHIndex6, LS_PLAIN_PATH::getNfaNameLS_PLAIN_PATHIndex7, LS_PLAIN_PATH::getNfaNameLS_PLAIN_PATHIndex8, LS_PLAIN_PATH::getNfaNameLS_PLAIN_PATHIndex9, LS_PLAIN_PATH::getNfaNameLS_PLAIN_PATHIndex10, LS_PLAIN_PATH::getNfaNameLS_PLAIN_PATHIndex11};
            functionTableMap.put(LexicalState.LS_PLAIN_PATH, functions2);
        }
    }

    private static class LS_ORDERBYS {
        private LS_ORDERBYS() {
        }

        private static Token.TokenType getNfaNameLS_ORDERBYSIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 44) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_VALUE_SEPARATOR)) {
                    type = Token.TokenType.T_VALUE_SEPARATOR;
                }
            } else if (ch == 9) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_4)) {
                    type = Token.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_3)) {
                    type = Token.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_2)) {
                    type = Token.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_1))) {
                type = Token.TokenType._TOKEN_1;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions2 = new NfaFunction[]{LS_ORDERBYS::getNfaNameLS_ORDERBYSIndex0};
            functionTableMap.put(LexicalState.LS_ORDERBYS, functions2);
        }
    }

    private static class LS_ORDERBY {
        private LS_ORDERBY() {
        }

        private static Token.TokenType getNfaNameLS_ORDERBYIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(4);
            } else if (ch == 68 || ch == 100) {
                nextStates.set(1);
            } else if (ch == 9) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_4)) {
                    type = Token.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_3)) {
                    type = Token.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_2)) {
                    type = Token.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_1))) {
                type = Token.TokenType._TOKEN_1;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_ORDERBYIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(2);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_ORDERBYIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(3);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_ORDERBYIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 67 && ch != 99 || validTypes != null && !validTypes.contains(Token.TokenType.T_O_DESC))) {
                type = Token.TokenType.T_O_DESC;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_ORDERBYIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(5);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_ORDERBYIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 67 && ch != 99 || validTypes != null && !validTypes.contains(Token.TokenType.T_O_ASC))) {
                type = Token.TokenType.T_O_ASC;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions2 = new NfaFunction[]{LS_ORDERBY::getNfaNameLS_ORDERBYIndex0, LS_ORDERBY::getNfaNameLS_ORDERBYIndex1, LS_ORDERBY::getNfaNameLS_ORDERBYIndex2, LS_ORDERBY::getNfaNameLS_ORDERBYIndex3, LS_ORDERBY::getNfaNameLS_ORDERBYIndex4, LS_ORDERBY::getNfaNameLS_ORDERBYIndex5};
            functionTableMap.put(LexicalState.LS_ORDERBY, functions2);
        }
    }

    private static class LS_ANYSTRING {
        private LS_ANYSTRING() {
        }

        private static Token.TokenType getNfaNameLS_ANYSTRINGIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 37 || ch >= 39) {
                nextStates.set(0);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_STRING)) {
                    type = Token.TokenType.T_STRING;
                }
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions2 = new NfaFunction[]{LS_ANYSTRING::getNfaNameLS_ANYSTRINGIndex0};
            functionTableMap.put(LexicalState.LS_ANYSTRING, functions2);
        }
    }

    private static class LS_FORMAT {
        private LS_FORMAT() {
        }

        private static Token.TokenType getNfaNameLS_FORMATIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 37 || ch >= 45 && ch <= 59 || ch == 61 || ch >= 64 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(0);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_CHARSEQ_FORMAT)) {
                    type = Token.TokenType.T_CHARSEQ_FORMAT;
                }
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions2 = new NfaFunction[]{LS_FORMAT::getNfaNameLS_FORMATIndex0};
            functionTableMap.put(LexicalState.LS_FORMAT, functions2);
        }
    }

    private static class LS_METADATA {
        private LS_METADATA() {
        }

        private static Token.TokenType getNfaNameLS_METADATAIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122) {
                nextStates.set(0);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_CHARSEQ_METADATA)) {
                    type = Token.TokenType.T_CHARSEQ_METADATA;
                }
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions2 = new NfaFunction[]{LS_METADATA::getNfaNameLS_METADATAIndex0};
            functionTableMap.put(LexicalState.LS_METADATA, functions2);
        }
    }

    private static class LS_COUNT {
        private LS_COUNT() {
        }

        private static Token.TokenType getNfaNameLS_COUNTIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 70 || ch == 102) {
                nextStates.set(1);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(5);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_COUNTIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(2);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_COUNTIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76 || ch == 108) {
                nextStates.set(3);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_COUNTIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(4);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_COUNTIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 69 && ch != 101 || validTypes != null && !validTypes.contains(Token.TokenType.T_BOOL))) {
                type = Token.TokenType.T_BOOL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_COUNTIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 82 || ch == 114) {
                nextStates.set(6);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_COUNTIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 85 || ch == 117) {
                nextStates.set(7);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_COUNTIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (!(ch != 69 && ch != 101 || validTypes != null && !validTypes.contains(Token.TokenType.T_BOOL))) {
                type = Token.TokenType.T_BOOL;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions2 = new NfaFunction[]{LS_COUNT::getNfaNameLS_COUNTIndex0, LS_COUNT::getNfaNameLS_COUNTIndex1, LS_COUNT::getNfaNameLS_COUNTIndex2, LS_COUNT::getNfaNameLS_COUNTIndex3, LS_COUNT::getNfaNameLS_COUNTIndex4, LS_COUNT::getNfaNameLS_COUNTIndex5, LS_COUNT::getNfaNameLS_COUNTIndex6, LS_COUNT::getNfaNameLS_COUNTIndex7};
            functionTableMap.put(LexicalState.LS_COUNT, functions2);
        }
    }

    private static class LS_TOP {
        private LS_TOP() {
        }

        private static Token.TokenType getNfaNameLS_TOPIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(1);
            } else if (ch >= 49 && ch <= 57) {
                nextStates.set(2);
            }
            if (ch >= 48 && ch <= 57 && (validTypes == null || validTypes.contains(Token.TokenType.T_LONG))) {
                type = Token.TokenType.T_LONG;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_TOPIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 49 && ch <= 57) {
                nextStates.set(2);
            }
            if (ch >= 48 && ch <= 57 && (validTypes == null || validTypes.contains(Token.TokenType.T_LONG))) {
                type = Token.TokenType.T_LONG;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_TOPIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(2);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_LONG)) {
                    type = Token.TokenType.T_LONG;
                }
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions2 = new NfaFunction[]{LS_TOP::getNfaNameLS_TOPIndex0, LS_TOP::getNfaNameLS_TOPIndex1, LS_TOP::getNfaNameLS_TOPIndex2};
            functionTableMap.put(LexicalState.LS_TOP, functions2);
        }
    }

    private static class LS_SKIP {
        private LS_SKIP() {
        }

        private static Token.TokenType getNfaNameLS_SKIPIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(1);
            } else if (ch >= 49 && ch <= 57) {
                nextStates.set(2);
            }
            if (ch >= 48 && ch <= 57 && (validTypes == null || validTypes.contains(Token.TokenType.T_LONG))) {
                type = Token.TokenType.T_LONG;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SKIPIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 49 && ch <= 57) {
                nextStates.set(2);
            }
            if (ch >= 48 && ch <= 57 && (validTypes == null || validTypes.contains(Token.TokenType.T_LONG))) {
                type = Token.TokenType.T_LONG;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SKIPIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(2);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_LONG)) {
                    type = Token.TokenType.T_LONG;
                }
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions2 = new NfaFunction[]{LS_SKIP::getNfaNameLS_SKIPIndex0, LS_SKIP::getNfaNameLS_SKIPIndex1, LS_SKIP::getNfaNameLS_SKIPIndex2};
            functionTableMap.put(LexicalState.LS_SKIP, functions2);
        }
    }

    private static class LS_EXPAND {
        private LS_EXPAND() {
        }

        private static Token.TokenType getNfaNameLS_EXPANDIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 41) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_RB)) {
                    type = Token.TokenType.T_RB;
                }
            } else if (ch == 40) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_LB)) {
                    type = Token.TokenType.T_LB;
                }
            } else if (ch == 44 && (validTypes == null || validTypes.contains(Token.TokenType.T_VALUE_SEPARATOR))) {
                type = Token.TokenType.T_VALUE_SEPARATOR;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions2 = new NfaFunction[]{LS_EXPAND::getNfaNameLS_EXPANDIndex0};
            functionTableMap.put(LexicalState.LS_EXPAND, functions2);
        }
    }

    private static class LS_SELECT {
        private LS_SELECT() {
        }

        private static Token.TokenType getNfaNameLS_SELECTIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(1);
            } else if (ch == 44 && (validTypes == null || validTypes.contains(Token.TokenType.T_VALUE_SEPARATOR))) {
                type = Token.TokenType.T_VALUE_SEPARATOR;
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SELECTIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(2);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SELECTIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 83 || ch == 115) {
                nextStates.set(3);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SELECTIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(4);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SELECTIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 73 || ch == 105) {
                nextStates.set(5);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SELECTIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 78 || ch == 110) {
                nextStates.set(6);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SELECTIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 67 || ch == 99) {
                nextStates.set(7);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SELECTIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(8);
            }
            return type;
        }

        private static Token.TokenType getNfaNameLS_SELECTIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 58 && (validTypes == null || validTypes.contains(Token.TokenType.T_DISTINCT))) {
                type = Token.TokenType.T_DISTINCT;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions2 = new NfaFunction[]{LS_SELECT::getNfaNameLS_SELECTIndex0, LS_SELECT::getNfaNameLS_SELECTIndex1, LS_SELECT::getNfaNameLS_SELECTIndex2, LS_SELECT::getNfaNameLS_SELECTIndex3, LS_SELECT::getNfaNameLS_SELECTIndex4, LS_SELECT::getNfaNameLS_SELECTIndex5, LS_SELECT::getNfaNameLS_SELECTIndex6, LS_SELECT::getNfaNameLS_SELECTIndex7, LS_SELECT::getNfaNameLS_SELECTIndex8};
            functionTableMap.put(LexicalState.LS_SELECT, functions2);
        }
    }
}

