/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes;

import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.Node;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.PLexer;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.Token;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.TokenSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseNode
implements Node {
    private PLexer tokenSource;
    private static Class<? extends List> listClass;
    private Node parent;
    private List<Node> children = this.newList();
    private int beginOffset;
    private int endOffset;
    private boolean unparsed;
    private Map<String, Node> namedChildMap;
    private Map<String, List<Node>> namedChildListMap;

    @Override
    public PLexer getTokenSource() {
        if (this.tokenSource == null) {
            for (Node child : this.children()) {
                if (child.getTokenSource() instanceof PLexer) {
                    this.tokenSource = (PLexer)child.getTokenSource();
                }
                if (this.tokenSource == null) continue;
                break;
            }
        }
        return this.tokenSource;
    }

    @Override
    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = (PLexer)tokenSource;
    }

    public static void setListClass(Class<? extends List> listClass) {
        BaseNode.listClass = listClass;
    }

    private List<Node> newList() {
        if (listClass == null) {
            return new ArrayList<Node>();
        }
        try {
            return listClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isUnparsed() {
        return this.unparsed;
    }

    @Override
    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    @Override
    public void setParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void addChild(Node n) {
        this.children.add(n);
        n.setParent(this);
    }

    @Override
    public void addChild(int i, Node n) {
        this.children.add(i, n);
        n.setParent(this);
    }

    @Override
    public Node getChild(int i) {
        return this.children.get(i);
    }

    @Override
    public void setChild(int i, Node n) {
        this.children.get(i).setParent(null);
        this.children.set(i, n);
        n.setParent(this);
    }

    @Override
    public Node removeChild(int i) {
        Node n = this.children.remove(i);
        n.setParent(null);
        return n;
    }

    @Override
    public Node remove(int i) {
        Node n = this.children.remove(i);
        n.setParent(null);
        return n;
    }

    @Override
    public void clearChildren() {
        for (Node child : this.children) {
            child.setParent(null);
        }
        this.children.clear();
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public List<Node> children() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public int getBeginOffset() {
        return this.beginOffset;
    }

    @Override
    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    @Override
    public List<Node> subList(int from, int to) {
        return this.children.subList(from, to);
    }

    public List<Token> getRealTokens() {
        return this.descendants(Token.class, t2 -> !t2.isUnparsed());
    }

    @Override
    public void add(int i, Node n) {
        this.addChild(i, n);
    }

    @Override
    public Node get(int i) {
        return this.getChild(i);
    }

    @Override
    public Node set(int i, Node n) {
        this.setChild(i, n);
        return n;
    }

    @Override
    public boolean add(Node n) {
        this.addChild(n);
        return true;
    }

    @Override
    public void clear() {
        this.clearChildren();
    }

    @Override
    public boolean addAll(Collection<? extends Node> nodes) {
        return this.children.addAll(nodes);
    }

    @Override
    public boolean addAll(int i, Collection<? extends Node> nodes) {
        return this.children.addAll(i, nodes);
    }

    @Override
    public boolean containsAll(Collection<?> nodes) {
        return this.children.containsAll(nodes);
    }

    @Override
    public boolean retainAll(Collection<?> nodes) {
        return this.children.containsAll(nodes);
    }

    @Override
    public boolean removeAll(Collection<?> nodes) {
        return this.children.removeAll(nodes);
    }

    public String toString() {
        return this.getSource();
    }

    public Node getNamedChild(String name) {
        if (this.namedChildMap == null) {
            return null;
        }
        return this.namedChildMap.get(name);
    }

    public void setNamedChild(String name, Node node) {
        if (this.namedChildMap == null) {
            this.namedChildMap = new HashMap<String, Node>();
        }
        if (this.namedChildMap.containsKey(name)) {
            String msg = String.format("Duplicate named child not allowed: {0}", name);
            throw new RuntimeException(msg);
        }
        this.namedChildMap.put(name, node);
    }

    public List<Node> getNamedChildList(String name) {
        if (this.namedChildListMap == null) {
            return null;
        }
        return this.namedChildListMap.get(name);
    }

    public void addToNamedChildList(String name, Node node) {
        List<Node> nodeList;
        if (this.namedChildListMap == null) {
            this.namedChildListMap = new HashMap<String, List<Node>>();
        }
        if ((nodeList = this.namedChildListMap.get(name)) == null) {
            nodeList = new ArrayList<Node>();
            this.namedChildListMap.put(name, nodeList);
        }
        nodeList.add(node);
    }
}

