/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.pathparser;

import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.InvalidToken;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.Node;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.PLexer;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.TokenSource;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_ARRAYINDEX;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_DOUBLE;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_LB;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_LONG;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_NAME;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_PATH_SEPARATOR;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_RB;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_REF;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_STR_LIT;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_VALUE;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Token
implements CharSequence,
Node.TerminalNode {
    private PLexer tokenSource;
    private TokenType type = TokenType.DUMMY;
    private int beginOffset;
    private int endOffset;
    private boolean unparsed;
    private Node parent;

    @Override
    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    @Override
    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    @Override
    public PLexer getTokenSource() {
        return this.tokenSource;
    }

    @Override
    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = (PLexer)tokenSource;
    }

    @Override
    public TokenType getType() {
        return this.type;
    }

    protected void setType(TokenType type) {
        this.type = type;
    }

    public boolean isVirtual() {
        return this.type == TokenType.EOF;
    }

    public boolean isSkipped() {
        return false;
    }

    @Override
    public int getBeginOffset() {
        return this.beginOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public final Token getNext() {
        return this.getNextParsedToken();
    }

    public final Token getPrevious() {
        Token result;
        for (result = this.previousCachedToken(); result != null && result.isUnparsed(); result = result.previousCachedToken()) {
        }
        return result;
    }

    private Token getNextParsedToken() {
        Token result;
        for (result = this.nextCachedToken(); result != null && result.isUnparsed(); result = result.nextCachedToken()) {
        }
        return result;
    }

    public Token nextCachedToken() {
        if (this.getType() == TokenType.EOF) {
            return null;
        }
        PLexer tokenSource = this.getTokenSource();
        return tokenSource != null ? (Token)tokenSource.nextCachedToken(this.getEndOffset()) : null;
    }

    public Token previousCachedToken() {
        if (this.getTokenSource() == null) {
            return null;
        }
        return (Token)this.getTokenSource().previousCachedToken(this.getBeginOffset());
    }

    Token getPreviousToken() {
        return this.previousCachedToken();
    }

    public Token replaceType(TokenType type) {
        Token result = Token.newToken(type, this.getTokenSource(), this.getBeginOffset(), this.getEndOffset());
        this.getTokenSource().cacheToken(result);
        return result;
    }

    @Override
    public String getSource() {
        if (this.type == TokenType.EOF) {
            return "";
        }
        PLexer flm = this.getTokenSource();
        return flm == null ? null : flm.getText(this.getBeginOffset(), this.getEndOffset());
    }

    protected Token() {
    }

    public Token(TokenType type, PLexer tokenSource, int beginOffset, int endOffset) {
        this.type = type;
        this.tokenSource = tokenSource;
        this.beginOffset = beginOffset;
        this.endOffset = endOffset;
    }

    @Override
    public boolean isUnparsed() {
        return this.unparsed;
    }

    @Override
    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    public Iterator<Token> precedingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.previousCachedToken() != null;
            }

            @Override
            public Token next() {
                Token previous = this.currentPoint.previousCachedToken();
                if (previous == null) {
                    throw new NoSuchElementException("No previous token!");
                }
                this.currentPoint = previous;
                return this.currentPoint;
            }
        };
    }

    public List<Token> precedingUnparsedTokens() {
        ArrayList<Token> result = new ArrayList<Token>();
        for (Token t2 = this.previousCachedToken(); t2 != null && t2.isUnparsed(); t2 = t2.previousCachedToken()) {
            result.add(t2);
        }
        Collections.reverse(result);
        return result;
    }

    public Iterator<Token> followingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.nextCachedToken() != null;
            }

            @Override
            public Token next() {
                Token next = this.currentPoint.nextCachedToken();
                if (next == null) {
                    throw new NoSuchElementException("No next token!");
                }
                this.currentPoint = next;
                return this.currentPoint;
            }
        };
    }

    public void copyLocationInfo(Token from) {
        this.setTokenSource(from.getTokenSource());
        this.setBeginOffset(from.getBeginOffset());
        this.setEndOffset(from.getEndOffset());
    }

    public void copyLocationInfo(Token start, Token end) {
        this.setTokenSource(start.getTokenSource());
        if (this.tokenSource == null) {
            this.setTokenSource(end.getTokenSource());
        }
        this.setBeginOffset(start.getBeginOffset());
        this.setEndOffset(end.getEndOffset());
    }

    public static Token newToken(TokenType type, PLexer tokenSource, int beginOffset, int endOffset) {
        switch (type) {
            case T_NAME: {
                return new T_NAME(TokenType.T_NAME, tokenSource, beginOffset, endOffset);
            }
            case T_DOUBLE: {
                return new T_DOUBLE(TokenType.T_DOUBLE, tokenSource, beginOffset, endOffset);
            }
            case T_LONG: {
                return new T_LONG(TokenType.T_LONG, tokenSource, beginOffset, endOffset);
            }
            case T_ARRAYINDEX: {
                return new T_ARRAYINDEX(TokenType.T_ARRAYINDEX, tokenSource, beginOffset, endOffset);
            }
            case T_VALUE: {
                return new T_VALUE(TokenType.T_VALUE, tokenSource, beginOffset, endOffset);
            }
            case T_REF: {
                return new T_REF(TokenType.T_REF, tokenSource, beginOffset, endOffset);
            }
            case T_LB: {
                return new T_LB(TokenType.T_LB, tokenSource, beginOffset, endOffset);
            }
            case T_RB: {
                return new T_RB(TokenType.T_RB, tokenSource, beginOffset, endOffset);
            }
            case T_PATH_SEPARATOR: {
                return new T_PATH_SEPARATOR(TokenType.T_PATH_SEPARATOR, tokenSource, beginOffset, endOffset);
            }
            case T_STR_LIT: {
                return new T_STR_LIT(TokenType.T_STR_LIT, tokenSource, beginOffset, endOffset);
            }
            case INVALID: {
                return new InvalidToken(tokenSource, beginOffset, endOffset);
            }
        }
        return new Token(type, tokenSource, beginOffset, endOffset);
    }

    @Override
    public String getLocation() {
        return this.getInputSource() + ":" + this.getBeginLine() + ":" + this.getBeginColumn();
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public int length() {
        return this.endOffset - this.beginOffset;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.getTokenSource().subSequence(this.beginOffset + start, this.beginOffset + end);
    }

    @Override
    public char charAt(int offset) {
        return this.getTokenSource().charAt(this.beginOffset + offset);
    }

    @Override
    @Deprecated
    public String getImage() {
        return this.getSource();
    }

    @Override
    public String toString() {
        return this.getSource();
    }

    public static enum TokenType implements Node.NodeType
    {
        EOF,
        _TOKEN_1,
        _TOKEN_2,
        _TOKEN_3,
        _TOKEN_4,
        T_PATH_SEPARATOR,
        T_VALUE,
        T_REF,
        T_LB,
        T_RB,
        T_NAME,
        T_LONG,
        T_DOUBLE,
        T_STR_LIT,
        T_ARRAYINDEX,
        DUMMY,
        INVALID;


        @Override
        public boolean isUndefined() {
            return this == DUMMY;
        }

        @Override
        public boolean isInvalid() {
            return this == INVALID;
        }

        @Override
        public boolean isEOF() {
            return this == EOF;
        }
    }
}

