/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.pathparser;

import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.Node;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.NonTerminalCall;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.PLexer;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.ParseException;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.Token;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.TokenSource;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.P_EntityId;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.P_PathElement;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.Start;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.concurrent.CancellationException;

public class PParser {
    static final int UNLIMITED = Integer.MAX_VALUE;
    Token lastConsumedToken;
    private Token.TokenType nextTokenType;
    private Token currentLookaheadToken;
    private String currentlyParsedProduction;
    private String currentLookaheadProduction;
    EnumSet<Token.TokenType> outerFollowSet;
    private final Token DUMMY_START_TOKEN = new Token();
    private boolean cancelled;
    private PLexer token_source;
    private static HashMap<Token.TokenType[], EnumSet<Token.TokenType>> enumSetCache = new HashMap();
    private static final EnumSet<Token.TokenType> first_set$pathParser_ccc$52$14 = PParser.tokenTypeSet(Token.TokenType.T_LONG, Token.TokenType.T_STR_LIT);
    private ArrayList<NonTerminalCall> parsingStack = new ArrayList();
    private ArrayList<NonTerminalCall> lookaheadStack = new ArrayList();
    private boolean buildTree = true;
    private boolean tokensAreNodes = true;
    private boolean unparsedTokensAreNodes = false;
    NodeScope currentNodeScope = new NodeScope();

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setInputSource(String inputSource) {
        this.token_source.setInputSource(inputSource);
    }

    String getInputSource() {
        return this.token_source.getInputSource();
    }

    public PParser(String inputSource, CharSequence content) {
        this(new PLexer(inputSource, content));
    }

    public PParser(CharSequence content) {
        this("input", content);
    }

    public PParser(String inputSource, Path path) throws IOException {
        this(inputSource, TokenSource.stringFromBytes(Files.readAllBytes(path)));
    }

    public PParser(String inputSource, Path path, Charset charset) throws IOException {
        this(inputSource, TokenSource.stringFromBytes(Files.readAllBytes(path), charset));
    }

    public PParser(Path path) throws IOException {
        this(path.toString(), path);
    }

    public PParser(PLexer lexer) {
        this.token_source = lexer;
        this.lastConsumedToken = this.DUMMY_START_TOKEN;
        this.lastConsumedToken.setTokenSource(lexer);
    }

    public void setStartingPos(int startingLine, int startingColumn) {
        this.token_source.setStartingPos(startingLine, startingColumn);
    }

    private final Token nextToken(Token tok) {
        Token result = this.token_source.getNextToken(tok);
        while (result.isUnparsed()) {
            result = this.token_source.getNextToken(result);
        }
        this.nextTokenType = null;
        return result;
    }

    public final Token getNextToken() {
        return this.getToken(1);
    }

    public final Token getToken(int index) {
        int i;
        Token t2 = this.currentLookaheadToken == null ? this.lastConsumedToken : this.currentLookaheadToken;
        for (i = 0; i < index; ++i) {
            t2 = this.nextToken(t2);
        }
        for (i = 0; i > index && (t2 = t2.getPrevious()) != null; --i) {
        }
        return t2;
    }

    private final Token.TokenType nextTokenType() {
        if (this.nextTokenType == null) {
            this.nextTokenType = this.nextToken(this.lastConsumedToken).getType();
        }
        return this.nextTokenType;
    }

    boolean activateTokenTypes(Token.TokenType ... types) {
        if (this.token_source.activeTokenTypes == null) {
            return false;
        }
        boolean result = false;
        for (Token.TokenType tt : types) {
            result |= this.token_source.activeTokenTypes.add(tt);
        }
        if (result) {
            this.token_source.reset(this.getToken(0));
            this.nextTokenType = null;
        }
        return result;
    }

    boolean deactivateTokenTypes(Token.TokenType ... types) {
        boolean result = false;
        if (this.token_source.activeTokenTypes == null) {
            this.token_source.activeTokenTypes = EnumSet.allOf(Token.TokenType.class);
        }
        for (Token.TokenType tt : types) {
            result |= this.token_source.activeTokenTypes.remove(tt);
        }
        if (result) {
            this.token_source.reset(this.getToken(0));
            this.nextTokenType = null;
        }
        return result;
    }

    private static EnumSet<Token.TokenType> tokenTypeSet(Token.TokenType first, Token.TokenType ... rest) {
        Object[] key = new Token.TokenType[1 + rest.length];
        key[0] = first;
        if (rest.length > 0) {
            System.arraycopy(rest, 0, key, 1, rest.length);
        }
        Arrays.sort(key);
        if (enumSetCache.containsKey(key)) {
            return enumSetCache.get(key);
        }
        EnumSet<Token.TokenType> result = rest.length == 0 ? EnumSet.of(first) : EnumSet.of(first, rest);
        enumSetCache.put((Token.TokenType[])key, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Start Start() throws ParseException {
        Start start;
        String prevProduction;
        block20: {
            block21: {
                if (this.cancelled) {
                    throw new CancellationException();
                }
                prevProduction = this.currentlyParsedProduction;
                this.currentlyParsedProduction = "Start";
                Start thisProduction = null;
                if (this.buildTree) {
                    thisProduction = new Start();
                    this.openNodeScope(thisProduction);
                }
                ParseException parseException2 = null;
                int callStackSize3 = this.parsingStack.size();
                try {
                    this.consumeToken(Token.TokenType.T_PATH_SEPARATOR);
                    this.pushOntoCallStack("Start", "src/main/congocc/pathParser.ccc", 44, 22);
                    try {
                        this.P_PathElement();
                    }
                    finally {
                        this.popCallStack();
                    }
                    while (this.nextTokenType() == Token.TokenType.T_PATH_SEPARATOR) {
                        this.consumeToken(Token.TokenType.T_PATH_SEPARATOR);
                        this.pushOntoCallStack("Start", "src/main/congocc/pathParser.ccc", 44, 56);
                        try {
                            this.P_PathElement();
                        }
                        finally {
                            this.popCallStack();
                        }
                    }
                    if (this.nextTokenType() == Token.TokenType.T_REF) {
                        this.consumeToken(Token.TokenType.T_REF);
                    } else if (this.nextTokenType() == Token.TokenType.T_VALUE) {
                        this.consumeToken(Token.TokenType.T_VALUE);
                    }
                    this.consumeToken(Token.TokenType.EOF);
                    start = thisProduction;
                    this.restoreCallStack(callStackSize3);
                    if (thisProduction == null) break block20;
                    if (parseException2 != null) break block21;
                    this.closeNodeScope((Node)thisProduction, this.nodeArity() > 1);
                }
                catch (ParseException e) {
                    try {
                        parseException2 = e;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        this.restoreCallStack(callStackSize3);
                        if (thisProduction != null) {
                            if (parseException2 == null) {
                                this.closeNodeScope((Node)thisProduction, this.nodeArity() > 1);
                            } else {
                                this.clearNodeScope();
                            }
                        }
                        this.currentlyParsedProduction = prevProduction;
                        throw throwable;
                    }
                }
                break block20;
            }
            this.clearNodeScope();
        }
        this.currentlyParsedProduction = prevProduction;
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void P_PathElement() throws ParseException {
        String prevProduction;
        block18: {
            block19: {
                if (this.cancelled) {
                    throw new CancellationException();
                }
                prevProduction = this.currentlyParsedProduction;
                this.currentlyParsedProduction = "P_PathElement";
                P_PathElement thisProduction = null;
                if (this.buildTree) {
                    thisProduction = new P_PathElement();
                    this.openNodeScope(thisProduction);
                }
                ParseException parseException62 = null;
                int callStackSize63 = this.parsingStack.size();
                try {
                    this.consumeToken(Token.TokenType.T_NAME);
                    if (this.nextTokenType() == Token.TokenType.T_ARRAYINDEX) {
                        this.pushOntoCallStack("P_PathElement", "src/main/congocc/pathParser.ccc", 48, 14);
                        try {
                            this.P_ArrayIndex();
                        }
                        finally {
                            this.popCallStack();
                        }
                    }
                    if (this.nextTokenType() == Token.TokenType.T_LB) {
                        this.pushOntoCallStack("P_PathElement", "src/main/congocc/pathParser.ccc", 48, 29);
                        try {
                            this.P_EntityId();
                        }
                        finally {
                            this.popCallStack();
                        }
                    }
                    this.restoreCallStack(callStackSize63);
                    if (thisProduction == null) break block18;
                    if (parseException62 != null) break block19;
                    this.closeNodeScope((Node)thisProduction, this.nodeArity() > 1);
                }
                catch (ParseException e) {
                    try {
                        parseException62 = e;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        this.restoreCallStack(callStackSize63);
                        if (thisProduction != null) {
                            if (parseException62 == null) {
                                this.closeNodeScope((Node)thisProduction, this.nodeArity() > 1);
                            } else {
                                this.clearNodeScope();
                            }
                        }
                        this.currentlyParsedProduction = prevProduction;
                        throw throwable;
                    }
                }
                break block18;
            }
            this.clearNodeScope();
        }
        this.currentlyParsedProduction = prevProduction;
    }

    public final void P_EntityId() throws ParseException {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "P_EntityId";
        P_EntityId thisProduction = null;
        if (this.buildTree) {
            thisProduction = new P_EntityId();
            this.openNodeScope(thisProduction);
        }
        ParseException parseException94 = null;
        int callStackSize95 = this.parsingStack.size();
        try {
            this.consumeToken(Token.TokenType.T_LB);
            if (this.nextTokenType() == Token.TokenType.T_LONG) {
                this.consumeToken(Token.TokenType.T_LONG);
            } else if (this.nextTokenType() == Token.TokenType.T_STR_LIT) {
                this.consumeToken(Token.TokenType.T_STR_LIT);
            } else {
                this.pushOntoCallStack("P_EntityId", "src/main/congocc/pathParser.ccc", 52, 14);
                throw new ParseException(this.lastConsumedToken, first_set$pathParser_ccc$52$14, this.parsingStack);
            }
            this.consumeToken(Token.TokenType.T_RB);
        }
        catch (ParseException e) {
            parseException94 = e;
            throw e;
        }
        finally {
            this.restoreCallStack(callStackSize95);
            if (thisProduction != null) {
                if (parseException94 == null) {
                    this.closeNodeScope((Node)thisProduction, true);
                } else {
                    this.clearNodeScope();
                }
            }
            this.currentlyParsedProduction = prevProduction;
        }
    }

    public final void P_ArrayIndex() throws ParseException {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "P_ArrayIndex";
        this.consumeToken(Token.TokenType.T_ARRAYINDEX);
        while (this.nextTokenType() == Token.TokenType.T_ARRAYINDEX) {
            this.consumeToken(Token.TokenType.T_ARRAYINDEX);
        }
    }

    private final void pushOntoCallStack(String methodName, String fileName, int line, int column) {
        this.parsingStack.add(new NonTerminalCall("PParser", this.token_source, fileName, methodName, line, column, null));
    }

    private final void popCallStack() {
        NonTerminalCall ntc = this.parsingStack.remove(this.parsingStack.size() - 1);
        this.currentlyParsedProduction = ntc.productionName;
    }

    private final void restoreCallStack(int prevSize) {
        while (this.parsingStack.size() > prevSize) {
            this.popCallStack();
        }
    }

    void dumpLookaheadStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it = this.lookaheadStack.listIterator(this.lookaheadStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpCallStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it = this.parsingStack.listIterator(this.parsingStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpLookaheadCallStack(PrintStream ps) {
        ps.println("Current Parser Production is: " + this.currentlyParsedProduction);
        ps.println("Current Lookahead Production is: " + this.currentLookaheadProduction);
        ps.println("---Lookahead Stack---");
        this.dumpLookaheadStack(ps);
        ps.println("---Call Stack---");
        this.dumpCallStack(ps);
    }

    public boolean isParserTolerant() {
        return false;
    }

    public void setParserTolerant(boolean tolerantParsing) {
        if (tolerantParsing) {
            throw new UnsupportedOperationException("This parser was not built with that feature!");
        }
    }

    private Token consumeToken(Token.TokenType expectedType) throws ParseException {
        Token nextToken = this.nextToken(this.lastConsumedToken);
        if (nextToken.getType() != expectedType) {
            nextToken = this.handleUnexpectedTokenType(expectedType, nextToken);
        }
        this.lastConsumedToken = nextToken;
        this.nextTokenType = null;
        if (this.buildTree && this.tokensAreNodes) {
            this.pushNode(this.lastConsumedToken);
        }
        return this.lastConsumedToken;
    }

    private Token handleUnexpectedTokenType(Token.TokenType expectedType, Token nextToken) throws ParseException {
        throw new ParseException(nextToken, EnumSet.of(expectedType), this.parsingStack);
    }

    public boolean isTreeBuildingEnabled() {
        return this.buildTree;
    }

    public void setUnparsedTokensAreNodes(boolean unparsedTokensAreNodes) {
        this.unparsedTokensAreNodes = unparsedTokensAreNodes;
    }

    public void setTokensAreNodes(boolean tokensAreNodes) {
        this.tokensAreNodes = tokensAreNodes;
    }

    public Node rootNode() {
        return this.currentNodeScope.rootNode();
    }

    public void pushNode(Node n) {
        this.currentNodeScope.add(n);
    }

    public Node popNode() {
        return this.currentNodeScope.pop();
    }

    public Node peekNode() {
        return this.currentNodeScope.peek();
    }

    public void pokeNode(Node n) {
        this.currentNodeScope.poke(n);
    }

    public int nodeArity() {
        return this.currentNodeScope.size();
    }

    private void clearNodeScope() {
        this.currentNodeScope.clear();
    }

    private void openNodeScope(Node n) {
        new NodeScope();
        if (n != null) {
            n.setTokenSource(this.lastConsumedToken.getTokenSource());
            n.setBeginOffset(this.lastConsumedToken.getEndOffset());
            n.setEndOffset(n.getBeginOffset());
            n.setTokenSource(this.token_source);
            n.open();
        }
    }

    private boolean closeNodeScope(Node n, int num) {
        n.setEndOffset(this.lastConsumedToken.getEndOffset());
        this.currentNodeScope.close();
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < num; ++i) {
            nodes.add(this.popNode());
        }
        Collections.reverse(nodes);
        for (Node child : nodes) {
            if (child.getInputSource() != n.getInputSource()) continue;
            n.setBeginOffset(child.getBeginOffset());
            break;
        }
        for (Node child : nodes) {
            if (this.unparsedTokensAreNodes && child instanceof Token) {
                Token tok = (Token)child;
                while (tok.previousCachedToken() != null && tok.previousCachedToken().isUnparsed()) {
                    tok = tok.previousCachedToken();
                }
                boolean locationSet = false;
                while (tok.isUnparsed()) {
                    n.addChild(tok);
                    if (!locationSet && tok.getInputSource() == n.getInputSource() && tok.getBeginOffset() < n.getBeginOffset()) {
                        n.setBeginOffset(tok.getBeginOffset());
                        locationSet = true;
                    }
                    tok = tok.nextCachedToken();
                }
            }
            if (child.getInputSource() == n.getInputSource()) {
                n.setEndOffset(child.getEndOffset());
            }
            n.addChild(child);
        }
        n.close();
        this.pushNode(n);
        return true;
    }

    private boolean closeNodeScope(Node n, boolean condition) {
        if (n == null || !condition) {
            this.currentNodeScope.close();
            return false;
        }
        return this.closeNodeScope(n, this.nodeArity());
    }

    public boolean getBuildTree() {
        return this.buildTree;
    }

    public void setBuildTree(boolean buildTree) {
        this.buildTree = buildTree;
    }

    class NodeScope
    extends ArrayList<Node> {
        NodeScope parentScope;

        NodeScope() {
            this.parentScope = PParser.this.currentNodeScope;
            PParser.this.currentNodeScope = this;
        }

        boolean isRootScope() {
            return this.parentScope == null;
        }

        Node rootNode() {
            NodeScope ns = this;
            while (ns.parentScope != null) {
                ns = ns.parentScope;
            }
            return ns.isEmpty() ? null : (Node)ns.get(0);
        }

        Node peek() {
            if (this.isEmpty()) {
                return this.parentScope == null ? null : this.parentScope.peek();
            }
            return (Node)this.get(this.size() - 1);
        }

        Node pop() {
            return this.isEmpty() ? this.parentScope.pop() : (Node)this.remove(this.size() - 1);
        }

        void poke(Node n) {
            if (this.isEmpty()) {
                this.parentScope.poke(n);
            } else {
                this.set(this.size() - 1, n);
            }
        }

        void close() {
            this.parentScope.addAll(this);
            PParser.this.currentNodeScope = this.parentScope;
        }

        int nestingLevel() {
            int result = 0;
            NodeScope parent = this;
            while (parent.parentScope != null) {
                ++result;
                parent = parent.parentScope;
            }
            return result;
        }

        @Override
        public NodeScope clone() {
            NodeScope clone = (NodeScope)super.clone();
            if (this.parentScope != null) {
                clone.parentScope = this.parentScope.clone();
            }
            return clone;
        }
    }
}

