/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.pathparser;

import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.InvalidToken;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.Token;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.TokenSource;
import java.util.BitSet;
import java.util.EnumSet;

public class PLexer
extends TokenSource {
    LexicalState lexicalState = LexicalState.values()[0];
    EnumSet<Token.TokenType> activeTokenTypes = EnumSet.allOf(Token.TokenType.class);
    static final EnumSet<Token.TokenType> regularTokens = EnumSet.of(Token.TokenType.EOF, new Token.TokenType[]{Token.TokenType.T_PATH_SEPARATOR, Token.TokenType.T_VALUE, Token.TokenType.T_REF, Token.TokenType.T_LB, Token.TokenType.T_RB, Token.TokenType.T_NAME, Token.TokenType.T_LONG, Token.TokenType.T_DOUBLE, Token.TokenType.T_STR_LIT, Token.TokenType.T_ARRAYINDEX});
    private static final EnumSet<Token.TokenType> unparsedTokens = EnumSet.noneOf(Token.TokenType.class);
    static final EnumSet<Token.TokenType> skippedTokens = EnumSet.of(Token.TokenType._TOKEN_1, Token.TokenType._TOKEN_2, Token.TokenType._TOKEN_3, Token.TokenType._TOKEN_4);
    private static final EnumSet<Token.TokenType> moreTokens = EnumSet.noneOf(Token.TokenType.class);
    private static NfaFunction[] nfaFunctions;

    public PLexer(CharSequence input) {
        this("input", input);
    }

    public PLexer(String inputSource, CharSequence input) {
        this(inputSource, input, LexicalState.DEFAULT, 1, 1);
    }

    public PLexer(String inputSource, CharSequence input, LexicalState lexState, int startingLine, int startingColumn) {
        super(inputSource, input, startingLine, startingColumn, 1, true, true, false, "");
        if (this.lexicalState != null) {
            this.switchTo(lexState);
        }
    }

    public Token getNextToken(Token tok) {
        if (tok == null) {
            tok = this.tokenizeAt(0);
            this.cacheToken(tok);
            return tok;
        }
        Token cachedToken = tok.nextCachedToken();
        if (cachedToken != null && this.activeTokenTypes != null && !this.activeTokenTypes.contains(cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        if (cachedToken == null) {
            Token token = this.tokenizeAt(tok.getEndOffset());
            this.cacheToken(token);
            return token;
        }
        return cachedToken;
    }

    static MatchInfo getMatchInfo(CharSequence input, int position, EnumSet<Token.TokenType> activeTokenTypes, NfaFunction[] nfaFunctions) {
        if (position >= input.length()) {
            return new MatchInfo(Token.TokenType.EOF, 0);
        }
        int start = position;
        int matchLength = 0;
        Token.TokenType matchedType = Token.TokenType.INVALID;
        BitSet currentStates = new BitSet(65);
        BitSet nextStates = new BitSet(65);
        do {
            int curChar;
            if (position > start) {
                BitSet temp = currentStates;
                currentStates = nextStates;
                nextStates = temp;
                nextStates.clear();
            } else {
                currentStates.set(0);
            }
            if (position >= input.length()) break;
            if ((curChar = Character.codePointAt(input, position++)) > 65535) {
                ++position;
            }
            int nextActive = currentStates.nextSetBit(0);
            while (nextActive != -1) {
                Token.TokenType returnedType = nfaFunctions[nextActive].apply(curChar, nextStates, activeTokenTypes);
                if (returnedType != null && (position - start > matchLength || returnedType.ordinal() < matchedType.ordinal())) {
                    matchedType = returnedType;
                    matchLength = position - start;
                }
                nextActive = currentStates.nextSetBit(nextActive + 1);
            }
        } while (position < input.length() && !nextStates.isEmpty());
        return new MatchInfo(matchedType, matchLength);
    }

    final Token tokenizeAt(int position) {
        int tokenBeginOffset = position;
        boolean inMore = false;
        StringBuilder invalidChars = null;
        Token matchedToken = null;
        Token.TokenType matchedType = null;
        while (matchedToken == null) {
            if (!inMore) {
                tokenBeginOffset = position;
            }
            MatchInfo matchInfo = PLexer.getMatchInfo(this, position, this.activeTokenTypes, nfaFunctions);
            matchedType = matchInfo.matchedType;
            inMore = moreTokens.contains(matchedType);
            position += matchInfo.matchLength;
            if (matchedType == Token.TokenType.INVALID) {
                if (invalidChars == null) {
                    invalidChars = new StringBuilder();
                }
                int cp = Character.codePointAt(this, tokenBeginOffset);
                invalidChars.appendCodePoint(cp);
                ++position;
                if (cp <= 65535) continue;
                ++position;
                continue;
            }
            if (invalidChars != null) {
                return new InvalidToken(this, tokenBeginOffset - invalidChars.length(), tokenBeginOffset);
            }
            if (skippedTokens.contains(matchedType)) {
                this.skipTokens(tokenBeginOffset, position);
                continue;
            }
            if (!regularTokens.contains(matchedType) && !unparsedTokens.contains(matchedType)) continue;
            matchedToken = Token.newToken(matchedType, this, tokenBeginOffset, position);
            matchedToken.setUnparsed(!regularTokens.contains(matchedType));
        }
        return matchedToken;
    }

    public boolean switchTo(LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(Token t2, LexicalState state) {
        this.uncacheTokens(t2);
        if (state != null) {
            this.switchTo(state);
        }
    }

    void reset(Token t2) {
        this.reset(t2, null);
    }

    void cacheToken(Token tok) {
        this.cacheTokenAt(tok, tok.getBeginOffset());
    }

    static {
        DEFAULT.NFA_FUNCTIONS_init();
    }

    public static enum LexicalState {
        DEFAULT;

    }

    static class MatchInfo {
        Token.TokenType matchedType;
        int matchLength;

        MatchInfo(Token.TokenType matchedType, int matchLength) {
            this.matchedType = matchedType;
            this.matchLength = matchLength;
        }
    }

    static interface NfaFunction {
        public Token.TokenType apply(int var1, BitSet var2, EnumSet<Token.TokenType> var3);
    }

    private static class DEFAULT {
        private DEFAULT() {
        }

        private static Token.TokenType getNfaIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 39) {
                nextStates.set(19);
            } else if (ch == 45) {
                nextStates.set(27);
                nextStates.set(39);
            } else if (ch == 47) {
                nextStates.set(21);
                nextStates.set(41);
            } else if (ch == 64) {
                nextStates.set(1);
                nextStates.set(13);
            } else if (ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122) {
                nextStates.set(34);
            } else if (ch == 91) {
                nextStates.set(35);
            } else if (ch == 48) {
                nextStates.set(33);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DOUBLE)) {
                    type = Token.TokenType.T_DOUBLE;
                }
            } else if (ch >= 49 && ch <= 57) {
                nextStates.set(28);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DOUBLE)) {
                    type = Token.TokenType.T_DOUBLE;
                }
            }
            if (ch == 48) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_LONG)) {
                    type = Token.TokenType.T_LONG;
                }
            } else if (ch >= 49 && ch <= 57) {
                nextStates.set(40);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_LONG)) {
                    type = Token.TokenType.T_LONG;
                }
            } else if (ch == 41) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_RB)) {
                    type = Token.TokenType.T_RB;
                }
            } else if (ch == 40) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_LB)) {
                    type = Token.TokenType.T_LB;
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_PATH_SEPARATOR)) {
                    type = Token.TokenType.T_PATH_SEPARATOR;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_4)) {
                    type = Token.TokenType._TOKEN_4;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_3)) {
                    type = Token.TokenType._TOKEN_3;
                }
            } else if (ch == 9) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_2)) {
                    type = Token.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_1))) {
                type = Token.TokenType._TOKEN_1;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(2);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(3);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(4);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(5);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 115) {
                nextStates.set(6);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(7);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(8);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102) {
                nextStates.set(9);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 76) {
                nextStates.set(10);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(11);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 110) {
                nextStates.set(12);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 107 && (validTypes == null || validTypes.contains(Token.TokenType.T_NAME))) {
                type = Token.TokenType.T_NAME;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(14);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 111) {
                nextStates.set(15);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 116) {
                nextStates.set(16);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(17);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 105) {
                nextStates.set(18);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 100 && (validTypes == null || validTypes.contains(Token.TokenType.T_NAME))) {
                type = Token.TokenType.T_NAME;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(19);
            } else if (ch == 39) {
                nextStates.set(20);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_STR_LIT)) {
                    type = Token.TokenType.T_STR_LIT;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaIndex20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 39) {
                nextStates.set(19);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 36) {
                nextStates.set(22);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 118) {
                nextStates.set(23);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                nextStates.set(24);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 108) {
                nextStates.set(25);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 117) {
                nextStates.set(26);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101 && (validTypes == null || validTypes.contains(Token.TokenType.T_VALUE))) {
                type = Token.TokenType.T_VALUE;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48) {
                nextStates.set(33);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DOUBLE)) {
                    type = Token.TokenType.T_DOUBLE;
                }
            } else if (ch >= 49 && ch <= 57) {
                nextStates.set(28);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DOUBLE)) {
                    type = Token.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaIndex28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(31);
            } else if (ch == 69) {
                nextStates.set(29);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(28);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DOUBLE)) {
                    type = Token.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaIndex29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(30);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(30);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DOUBLE)) {
                    type = Token.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaIndex30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(30);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DOUBLE)) {
                    type = Token.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaIndex31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(32);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DOUBLE)) {
                    type = Token.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaIndex32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(29);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(32);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_DOUBLE)) {
                    type = Token.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaIndex33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(31);
            } else if (ch == 69) {
                nextStates.set(29);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45 || ch == 46 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(34);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_NAME)) {
                    type = Token.TokenType.T_NAME;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaIndex35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 45) {
                nextStates.set(38);
            } else if (ch == 48) {
                nextStates.set(36);
            } else if (ch >= 49 && ch <= 57) {
                nextStates.set(37);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 93 && (validTypes == null || validTypes.contains(Token.TokenType.T_ARRAYINDEX))) {
                type = Token.TokenType.T_ARRAYINDEX;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(37);
            } else if (ch == 93 && (validTypes == null || validTypes.contains(Token.TokenType.T_ARRAYINDEX))) {
                type = Token.TokenType.T_ARRAYINDEX;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48) {
                nextStates.set(36);
            } else if (ch >= 49 && ch <= 57) {
                nextStates.set(37);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 48) {
                if (validTypes == null || validTypes.contains(Token.TokenType.T_LONG)) {
                    type = Token.TokenType.T_LONG;
                }
            } else if (ch >= 49 && ch <= 57) {
                nextStates.set(40);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_LONG)) {
                    type = Token.TokenType.T_LONG;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaIndex40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(40);
                if (validTypes == null || validTypes.contains(Token.TokenType.T_LONG)) {
                    type = Token.TokenType.T_LONG;
                }
            }
            return type;
        }

        private static Token.TokenType getNfaIndex41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 36) {
                nextStates.set(42);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 114) {
                nextStates.set(43);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 101) {
                nextStates.set(44);
            }
            return type;
        }

        private static Token.TokenType getNfaIndex44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes) {
            Token.TokenType type = null;
            if (ch == 102 && (validTypes == null || validTypes.contains(Token.TokenType.T_REF))) {
                type = Token.TokenType.T_REF;
            }
            return type;
        }

        private static void NFA_FUNCTIONS_init() {
            nfaFunctions = new NfaFunction[]{DEFAULT::getNfaIndex0, DEFAULT::getNfaIndex1, DEFAULT::getNfaIndex2, DEFAULT::getNfaIndex3, DEFAULT::getNfaIndex4, DEFAULT::getNfaIndex5, DEFAULT::getNfaIndex6, DEFAULT::getNfaIndex7, DEFAULT::getNfaIndex8, DEFAULT::getNfaIndex9, DEFAULT::getNfaIndex10, DEFAULT::getNfaIndex11, DEFAULT::getNfaIndex12, DEFAULT::getNfaIndex13, DEFAULT::getNfaIndex14, DEFAULT::getNfaIndex15, DEFAULT::getNfaIndex16, DEFAULT::getNfaIndex17, DEFAULT::getNfaIndex18, DEFAULT::getNfaIndex19, DEFAULT::getNfaIndex20, DEFAULT::getNfaIndex21, DEFAULT::getNfaIndex22, DEFAULT::getNfaIndex23, DEFAULT::getNfaIndex24, DEFAULT::getNfaIndex25, DEFAULT::getNfaIndex26, DEFAULT::getNfaIndex27, DEFAULT::getNfaIndex28, DEFAULT::getNfaIndex29, DEFAULT::getNfaIndex30, DEFAULT::getNfaIndex31, DEFAULT::getNfaIndex32, DEFAULT::getNfaIndex33, DEFAULT::getNfaIndex34, DEFAULT::getNfaIndex35, DEFAULT::getNfaIndex36, DEFAULT::getNfaIndex37, DEFAULT::getNfaIndex38, DEFAULT::getNfaIndex39, DEFAULT::getNfaIndex40, DEFAULT::getNfaIndex41, DEFAULT::getNfaIndex42, DEFAULT::getNfaIndex43, DEFAULT::getNfaIndex44};
        }
    }
}

