/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import de.fraunhofer.iosb.ilt.frostserver.model.ComplexValue;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeComplex;
import java.io.IOException;

public class ParserUtils {
    private ParserUtils() {
    }

    public static JsonSerializer<Object> getDefaultSerializer() {
        return new JsonSerializer<Object>(){

            @Override
            public void serialize(Object t2, JsonGenerator jg, SerializerProvider sp) throws IOException {
                jg.writePOJO(t2);
            }
        };
    }

    public static <T> JsonDeserializer<T> getDefaultDeserializer(final TypeReference<T> tr) {
        return new JsonDeserializer<T>(){

            @Override
            public T deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JacksonException {
                return jp.readValueAs(tr);
            }
        };
    }

    public static JsonDeserializer<Object> getLocationDeserializer() {
        return new JsonDeserializer<Object>(){

            @Override
            public Object deserialize(JsonParser jp, DeserializationContext dc) throws IOException {
                Object valueTree = jp.readValueAsTree();
                return valueTree;
            }
        };
    }

    public static JsonDeserializer<ComplexValue> getComplexTypeDeserializer(TypeComplex type) {
        return new ComplexTypeDeserializer(type);
    }

    private static class ComplexTypeDeserializer
    extends JsonDeserializer<ComplexValue> {
        private final TypeComplex type;

        public ComplexTypeDeserializer(TypeComplex type) {
            this.type = type;
        }

        @Override
        public ComplexValue deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
            ComplexValue result = this.type.instantiate();
            JsonToken currentToken = parser.currentToken();
            if (currentToken == JsonToken.VALUE_NULL) {
                return null;
            }
            currentToken = parser.nextToken();
            while (currentToken == JsonToken.FIELD_NAME) {
                String fieldName = parser.getCurrentName();
                parser.nextValue();
                Property property = this.type.getProperty(fieldName);
                if (property == null) {
                    if (!this.type.isOpenType()) {
                        String message = "Unknown field: " + fieldName + " on " + this.type.getName() + " expected one of: " + this.type.getPropertiesByName().keySet();
                        throw new UnrecognizedPropertyException(parser, message, parser.getCurrentLocation(), TypeComplex.class, fieldName, null);
                    }
                    result.setProperty(fieldName, parser.readValueAsTree());
                } else {
                    this.deserializeProperty(parser, ctxt, property, result);
                }
                currentToken = parser.nextToken();
            }
            return result;
        }

        private void deserializeProperty(JsonParser parser, DeserializationContext ctxt, Property property, ComplexValue result) throws IOException {
            if (property instanceof EntityPropertyMain) {
                EntityPropertyMain epm = (EntityPropertyMain)property;
                this.deserializeEntityProperty(parser, ctxt, epm, result);
            } else if (property instanceof NavigationProperty) {
                throw new IllegalArgumentException("NavigationProperties not supported on ComplexTypes.");
            }
        }

        private void deserializeEntityProperty(JsonParser parser, DeserializationContext ctxt, EntityPropertyMain property, ComplexValue result) throws IOException {
            JsonDeserializer deserializer = property.getType().getDeserializer();
            if (deserializer == null) {
                Object value = parser.readValueAs(Object.class);
                result.setProperty(property, value);
            } else {
                Object value = deserializer.deserialize(parser, ctxt);
                result.setProperty(property, value);
            }
        }
    }
}

