/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitVersionInfo {
    public static final TypeReference<Map<String, String>> TYPE_MAP_STRING_STRING = new TypeReference<Map<String, String>>(){};
    public static final String PACKAGE_NAME = "FROST-Server.Core";
    private static final String PATH_GIT_COMMIT_ID_DESCRIBE = "git.commit.id.describe";
    private static final Logger LOGGER = LoggerFactory.getLogger(GitVersionInfo.class);
    private static Map<String, String> gitData;

    private GitVersionInfo() {
    }

    public static void logGitInfo() {
        GitVersionInfo.init();
        if (LOGGER.isInfoEnabled()) {
            String version = gitData.get(PATH_GIT_COMMIT_ID_DESCRIBE);
            LOGGER.info("{} Version: {}", (Object)PACKAGE_NAME, (Object)version);
        }
    }

    public static String getGitDescription() {
        GitVersionInfo.init();
        return gitData.get(PATH_GIT_COMMIT_ID_DESCRIBE);
    }

    private static void init() {
        if (gitData == null) {
            gitData = GitVersionInfo.readInfo();
        }
    }

    private static Map<String, String> readInfo() {
        Map<String, String> map;
        ClassLoader classLoader = GitVersionInfo.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("git.json");
        ObjectMapper mapper = new ObjectMapper();
        try {
            map = mapper.readValue(inputStream, TYPE_MAP_STRING_STRING);
        }
        catch (IOException exc) {
            LOGGER.error("Failed to read git info file.", exc);
            map = new HashMap<String, String>();
        }
        return map;
    }
}

