/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.settings;

import de.fraunhofer.iosb.ilt.frostserver.settings.CachedSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigUtils;
import de.fraunhofer.iosb.ilt.frostserver.settings.PropertyMissingException;
import de.fraunhofer.iosb.ilt.frostserver.settings.PropertyTypeException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Settings {
    private static final Logger LOGGER = LoggerFactory.getLogger(Settings.class);
    private static final String NOT_SET_USING_DEFAULT_VALUE = "Not set {}{}, using default value '{}'.";
    private static final String NOT_SET_NO_DEFAULT_VALUE = "Not set {}, and no default value!";
    private static final String ERROR_GETTING_SETTINGS_VALUE = "error getting settings value";
    private static final String SETTING_HAS_VALUE = "Setting {}{} has value '{}'.";
    private static final String HIDDEN_VALUE = "*****";
    private final Properties properties;
    private boolean logSensitiveData;
    private String prefix;

    private static Properties addEnvironment(Properties wrapped) {
        Map<String, String> environment = System.getenv();
        Properties wrapper = new Properties(wrapped);
        TreeMap<String, String> sortedEnv = new TreeMap<String, String>(environment);
        for (Map.Entry entry : sortedEnv.entrySet()) {
            String key = ((String)entry.getKey()).replace('_', '.');
            LOGGER.debug("Added environment variable: {}", (Object)key);
            wrapper.setProperty(key, (String)entry.getValue());
        }
        return wrapper;
    }

    public Settings() {
        this(new Properties(), "", true, false);
    }

    public Settings(Properties properties) {
        this(properties, "", true, false);
    }

    public Settings(Properties properties, String prefix, boolean wrapInEnvironment, boolean logSensitiveData) {
        if (properties == null) {
            throw new IllegalArgumentException("properties must be non-null");
        }
        this.properties = wrapInEnvironment ? Settings.addEnvironment(properties) : properties;
        this.prefix = prefix == null ? "" : prefix;
        this.logSensitiveData = logSensitiveData;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Settings getSubSettings(String prefix) {
        return new CachedSettings(this, prefix);
    }

    public boolean getLogSensitiveData() {
        return this.logSensitiveData;
    }

    public void setLogSensitiveData(boolean logSensitiveData) {
        this.logSensitiveData = logSensitiveData;
    }

    private String getPropertyKey(String propertyName) {
        return this.prefix + propertyName.replace('_', '.');
    }

    public boolean containsName(String name) {
        String val = this.properties.getProperty(this.getPropertyKey(name));
        return val != null;
    }

    private void checkExists(String key) {
        if (this.properties.getProperty(key) != null) {
            return;
        }
        LOGGER.error(NOT_SET_NO_DEFAULT_VALUE, (Object)key);
        throw new PropertyMissingException(key);
    }

    public void set(String name, String value) {
        this.properties.put(this.getPropertyKey(name), value);
    }

    public void set(String name, boolean value) {
        this.properties.put(this.getPropertyKey(name), Boolean.toString(value));
    }

    public String get(String name) {
        return this.get(name, false);
    }

    public String getSensitive(String name) {
        return this.get(name, true);
    }

    private String get(String name, boolean sensitiveValue) {
        String key = this.getPropertyKey(name);
        this.checkExists(key);
        String value = this.properties.getProperty(key);
        this.logHasValue(name, value, sensitiveValue);
        return value;
    }

    public String get(String name, String defaultValue) {
        return this.get(name, defaultValue, false);
    }

    public String getSensitive(String name, String defaultValue) {
        return this.get(name, defaultValue, true);
    }

    private String get(String name, String defaultValue, boolean sensitive) {
        String key = this.getPropertyKey(name);
        String value = this.properties.getProperty(key);
        if (value == null) {
            this.logDefaultValue(name, defaultValue, sensitive);
            return defaultValue;
        }
        this.logHasValue(name, value, sensitive);
        return value;
    }

    public String get(String name, Class<? extends ConfigDefaults> defaultsProvider) {
        String key = this.getPropertyKey(name);
        String value = this.properties.getProperty(key);
        boolean sensitive = ConfigUtils.isSensitive(defaultsProvider, name);
        if (value == null) {
            String defaultValue = ConfigUtils.getDefaultValue(defaultsProvider, name);
            this.logDefaultValue(name, defaultValue, sensitive);
            return defaultValue;
        }
        this.logHasValue(name, value, sensitive);
        return value;
    }

    public int getInt(String name) {
        try {
            return Integer.parseInt(this.get(name));
        }
        catch (NumberFormatException ex) {
            throw new PropertyTypeException(name, Integer.class, ex);
        }
    }

    public int getInt(String name, int defaultValue) {
        if (this.containsName(name)) {
            try {
                return this.getInt(name);
            }
            catch (Exception ex) {
                LOGGER.trace(ERROR_GETTING_SETTINGS_VALUE, ex);
            }
        }
        LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, defaultValue);
        return defaultValue;
    }

    public int getInt(String name, Class<? extends ConfigDefaults> defaultsProvider) {
        if (this.containsName(name)) {
            try {
                return this.getInt(name);
            }
            catch (Exception ex) {
                LOGGER.trace(ERROR_GETTING_SETTINGS_VALUE, ex);
            }
        }
        int defaultValue = ConfigUtils.getDefaultValueInt(defaultsProvider, name);
        LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, defaultValue);
        return defaultValue;
    }

    public long getLong(String name) {
        try {
            return Long.parseLong(this.get(name));
        }
        catch (NumberFormatException ex) {
            throw new PropertyTypeException(name, Long.class, ex);
        }
    }

    public long getLong(String name, long defaultValue) {
        if (this.containsName(name)) {
            try {
                return this.getLong(name);
            }
            catch (Exception ex) {
                LOGGER.trace(ERROR_GETTING_SETTINGS_VALUE, ex);
            }
        }
        LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, defaultValue);
        return defaultValue;
    }

    public long getLong(String name, Class<? extends ConfigDefaults> defaultsProvider) {
        if (this.containsName(name)) {
            try {
                return this.getLong(name);
            }
            catch (Exception ex) {
                LOGGER.trace(ERROR_GETTING_SETTINGS_VALUE, ex);
            }
        }
        int defaultValue = ConfigUtils.getDefaultValueInt(defaultsProvider, name);
        LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, defaultValue);
        return defaultValue;
    }

    public double getDouble(String name) {
        try {
            return Double.parseDouble(this.get(name));
        }
        catch (NumberFormatException ex) {
            throw new PropertyTypeException(name, Double.class, ex);
        }
    }

    public double getDouble(String name, double defaultValue) {
        if (this.containsName(name)) {
            try {
                return this.getDouble(name);
            }
            catch (Exception ex) {
                LOGGER.trace(ERROR_GETTING_SETTINGS_VALUE, ex);
            }
        }
        LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, defaultValue);
        return defaultValue;
    }

    public double getDouble(String name, Class<? extends ConfigDefaults> defaultsProvider) {
        if (this.containsName(name)) {
            try {
                return this.getDouble(name);
            }
            catch (Exception ex) {
                LOGGER.trace(ERROR_GETTING_SETTINGS_VALUE, ex);
            }
        }
        double defaultValue = ConfigUtils.getDefaultValueDouble(defaultsProvider, name);
        LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, defaultValue);
        return defaultValue;
    }

    public boolean getBoolean(String name) {
        try {
            return Boolean.parseBoolean(this.get(name));
        }
        catch (PropertyMissingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PropertyTypeException(name, Boolean.class, ex);
        }
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        if (this.containsName(name)) {
            try {
                return this.getBoolean(name);
            }
            catch (Exception ex) {
                LOGGER.trace(ERROR_GETTING_SETTINGS_VALUE, ex);
            }
        }
        LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, defaultValue);
        return defaultValue;
    }

    public boolean getBoolean(String name, Class<? extends ConfigDefaults> defaultsProvider) {
        if (this.containsName(name)) {
            try {
                return this.getBoolean(name);
            }
            catch (Exception ex) {
                LOGGER.trace(ERROR_GETTING_SETTINGS_VALUE, ex);
            }
        }
        boolean defaultValue = ConfigUtils.getDefaultValueBoolean(defaultsProvider, name);
        LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, defaultValue);
        return defaultValue;
    }

    private void logHasValue(String name, String value, boolean sensitive) {
        if (!sensitive || this.logSensitiveData) {
            LOGGER.info(SETTING_HAS_VALUE, this.prefix, name, value);
        } else {
            LOGGER.info(SETTING_HAS_VALUE, this.prefix, name, HIDDEN_VALUE);
        }
    }

    private void logDefaultValue(String name, String defaultValue, boolean sensitive) {
        if (!sensitive || this.logSensitiveData) {
            LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, defaultValue);
        } else {
            LOGGER.info(NOT_SET_USING_DEFAULT_VALUE, this.prefix, name, HIDDEN_VALUE);
        }
    }
}

