/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.settings;

import de.fraunhofer.iosb.ilt.frostserver.extensions.Extension;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValue;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueBoolean;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueInt;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSettings
implements ConfigDefaults {
    @DefaultValue(value="de.fraunhofer.iosb.ilt.sensorthingsserver.mqtt.moquette.MoquetteMqttServer")
    public static final String TAG_IMPLEMENTATION_CLASS = "mqttServerImplementationClass";
    @DefaultValueBoolean(value=true)
    public static final String TAG_ENABLED = "Enabled";
    @DefaultValueInt(value=2)
    public static final String TAG_QOS = "QoS";
    @DefaultValueInt(value=1883)
    public static final String TAG_PORT = "Port";
    @DefaultValue(value="0.0.0.0")
    public static final String TAG_HOST = "Host";
    @DefaultValue(value="localhost")
    public static final String TAG_HOST_INTERNAL = "internalHost";
    @DefaultValueInt(value=10)
    public static final String TAG_SUBSCRIBE_MESSAGE_QUEUE_SIZE = "SubscribeMessageQueueSize";
    @DefaultValueInt(value=10)
    public static final String TAG_SUBSCRIBE_THREAD_POOL_SIZE = "SubscribeThreadPoolSize";
    @DefaultValueInt(value=10)
    public static final String TAG_CREATE_MESSAGE_QUEUE_SIZE = "CreateMessageQueueSize";
    @DefaultValueInt(value=5)
    public static final String TAG_CREATE_THREAD_POOL_SIZE = "CreateThreadPoolSize";
    @DefaultValue(value="")
    public static final String TAG_EXPOSED_MQTT_ENDPOINTS = "exposedEndpoints";
    @DefaultValueBoolean(value=true)
    public static final String TAG_MQTT_ALLOW_EXPAND = "allowExpand";
    @DefaultValueBoolean(value=false)
    public static final String TAG_MQTT_ALLOW_FILTER = "allowFilter";
    public static final int MIN_PORT = 1025;
    public static final int MAX_PORT = 65535;
    public static final int MIN_QOS_LEVEL = 0;
    public static final int MAX_QOS_LEVEL = 2;
    private static final String MUST_BE_POSITIVE = " must be > 0";
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttSettings.class);
    private CoreSettings coreSettings;
    private String mqttServerImplementationClass;
    private boolean enableMqtt;
    private String host;
    private String internalHost;
    private int port;
    private int qosLevel;
    private List<String> endpoints;
    private int subscribeMessageQueueSize;
    private int subscribeThreadPoolSize;
    private int createMessageQueueSize;
    private int createThreadPoolSize;
    private boolean allowMqttExpand;
    private boolean allowMqttFilter;
    private Settings customSettings;

    public MqttSettings(CoreSettings coreSettings, Settings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("settings most be non-null");
        }
        this.coreSettings = coreSettings;
        this.init(coreSettings, settings);
    }

    private void init(CoreSettings coreSettings, Settings customSettings) {
        this.customSettings = customSettings;
        this.mqttServerImplementationClass = customSettings.get(TAG_IMPLEMENTATION_CLASS, this.getClass());
        this.enableMqtt = customSettings.getBoolean(TAG_ENABLED, this.getClass());
        this.port = customSettings.getInt(TAG_PORT, this.getClass());
        this.allowMqttExpand = customSettings.getBoolean(TAG_MQTT_ALLOW_EXPAND, this.getClass());
        this.allowMqttFilter = customSettings.getBoolean(TAG_MQTT_ALLOW_FILTER, this.getClass());
        this.setHost(customSettings.get(TAG_HOST, this.getClass()));
        this.setInternalHost(customSettings.get(TAG_HOST_INTERNAL, this.getClass()));
        this.setSubscribeMessageQueueSize(customSettings.getInt(TAG_SUBSCRIBE_MESSAGE_QUEUE_SIZE, this.getClass()));
        this.setSubscribeThreadPoolSize(customSettings.getInt(TAG_SUBSCRIBE_THREAD_POOL_SIZE, this.getClass()));
        this.setCreateMessageQueueSize(customSettings.getInt(TAG_CREATE_MESSAGE_QUEUE_SIZE, this.getClass()));
        this.setCreateThreadPoolSize(customSettings.getInt(TAG_CREATE_THREAD_POOL_SIZE, this.getClass()));
        this.setQosLevel(customSettings.getInt(TAG_QOS, this.getClass()));
        if (this.enableMqtt) {
            coreSettings.getEnabledExtensions().add(Extension.MQTT);
        }
    }

    private void searchExposedEndpoints(CoreSettings coreSettings) {
        if (!this.enableMqtt) {
            this.endpoints = Collections.emptyList();
            return;
        }
        String endpointsString = this.customSettings.get(TAG_EXPOSED_MQTT_ENDPOINTS, this.getClass());
        if (!endpointsString.isEmpty()) {
            String[] splitEndpoints = endpointsString.split(",");
            this.endpoints = Collections.unmodifiableList(Arrays.asList(splitEndpoints));
        } else {
            String serviceRootUrl = coreSettings.getQueryDefaults().getServiceRootUrl();
            try {
                URL serviceRoot = new URL(serviceRootUrl);
                ArrayList<CallSite> genEndpoints = new ArrayList<CallSite>();
                genEndpoints.add((CallSite)((Object)("mqtt://" + serviceRoot.getHost() + ":" + this.getPort())));
                this.endpoints = Collections.unmodifiableList(genEndpoints);
                LOGGER.info("Generated MQTT endpoint list: {}", (Object)this.endpoints);
                LOGGER.info("Please set mqtt.exposedEndpoints to set the correct MQTT end points.");
            }
            catch (MalformedURLException ex) {
                LOGGER.error("Failed to create MQTT urls.", ex);
            }
        }
    }

    public void fillServerSettings(Map<String, Object> target) {
        if (this.enableMqtt) {
            if (this.endpoints == null) {
                this.searchExposedEndpoints(this.coreSettings);
            }
            for (String requirement : Extension.MQTT.getRequirements()) {
                HashMap<String, List<String>> mqttSettings = new HashMap<String, List<String>>();
                mqttSettings.put("endpoints", this.endpoints);
                target.put(requirement, mqttSettings);
            }
        }
    }

    public boolean isEnableMqtt() {
        return this.enableMqtt;
    }

    public int getPort() {
        return this.port;
    }

    public int getQosLevel() {
        return this.qosLevel;
    }

    public void setEnableMqtt(boolean enableMqtt) {
        this.enableMqtt = enableMqtt;
    }

    public void setQosLevel(int qosLevel) {
        if (qosLevel < 0 || qosLevel > 2) {
            throw new IllegalArgumentException("QoS must be between 0 and 2");
        }
        this.qosLevel = qosLevel;
    }

    public String getHost() {
        return this.host;
    }

    public String getInternalHost() {
        return this.internalHost;
    }

    public String getTopicPrefix(Version version) {
        return version.urlPart + "/";
    }

    public void setHost(String host) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("Host must be non-empty");
        }
        this.host = host;
    }

    public void setInternalHost(String internalHost) {
        this.internalHost = internalHost;
    }

    public int getSubscribeMessageQueueSize() {
        return this.subscribeMessageQueueSize;
    }

    public int getSubscribeThreadPoolSize() {
        return this.subscribeThreadPoolSize;
    }

    public void setSubscribeMessageQueueSize(int subscribeMessageQueueSize) {
        if (subscribeMessageQueueSize < 1) {
            throw new IllegalArgumentException("SubscribeMessageQueueSize must be > 0");
        }
        this.subscribeMessageQueueSize = subscribeMessageQueueSize;
    }

    public void setSubscribeThreadPoolSize(int subscribeThreadPoolSize) {
        if (subscribeThreadPoolSize < 1) {
            throw new IllegalArgumentException("SubscribeThreadPoolSize must be > 0");
        }
        this.subscribeThreadPoolSize = subscribeThreadPoolSize;
    }

    public String getMqttServerImplementationClass() {
        return this.mqttServerImplementationClass;
    }

    public void setMqttServerImplementationClass(String mqttServerImplementationClass) {
        if (mqttServerImplementationClass == null || mqttServerImplementationClass.isEmpty()) {
            throw new IllegalArgumentException("mqttServerImplementationClass must be non-empty");
        }
        try {
            Class.forName(mqttServerImplementationClass, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("mqttServerImplementationClass '" + mqttServerImplementationClass + "' could not be found", ex);
        }
        this.mqttServerImplementationClass = mqttServerImplementationClass;
    }

    public Settings getCustomSettings() {
        return this.customSettings;
    }

    public int getCreateMessageQueueSize() {
        return this.createMessageQueueSize;
    }

    public int getCreateThreadPoolSize() {
        return this.createThreadPoolSize;
    }

    public void setCreateMessageQueueSize(int createMessageQueueSize) {
        if (createMessageQueueSize < 1) {
            throw new IllegalArgumentException("CreateMessageQueueSize must be > 0");
        }
        this.createMessageQueueSize = createMessageQueueSize;
    }

    public void setCreateThreadPoolSize(int createThreadPoolSize) {
        if (createThreadPoolSize < 1) {
            throw new IllegalArgumentException("CreateThreadPoolSize must be > 0");
        }
        this.createThreadPoolSize = createThreadPoolSize;
    }

    public boolean isAllowMqttExpand() {
        return this.allowMqttExpand;
    }

    public boolean isAllowMqttFilter() {
        return this.allowMqttFilter;
    }
}

