/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.settings;

import de.fraunhofer.iosb.ilt.frostclient.settings.annotation.DefaultValueDouble;
import de.fraunhofer.iosb.ilt.frostclient.settings.annotation.SensitiveValue;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValue;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueBoolean;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueInt;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigUtils.class);
    private static final String UNABLE_TO_ACCESS_FIELD_ON_OBJECT = "Unable to access field '{}' on object: {}.";

    private ConfigUtils() {
    }

    public static <T extends ConfigDefaults> Set<String> getConfigTags(Class<T> target) {
        HashSet<String> configTags = new HashSet<String>();
        for (Field f : target.getFields()) {
            try {
                if (!f.isAnnotationPresent(DefaultValue.class) && !f.isAnnotationPresent(DefaultValueInt.class) && !f.isAnnotationPresent(DefaultValueBoolean.class)) continue;
                configTags.add(f.get(target).toString());
            }
            catch (IllegalAccessException e) {
                LOGGER.warn(UNABLE_TO_ACCESS_FIELD_ON_OBJECT, (Object)f.getName(), (Object)target);
            }
        }
        return configTags;
    }

    public static <T extends ConfigDefaults> Map<String, String> getConfigDefaults(Class<T> target) {
        HashMap<String, String> configDefaults = new HashMap<String, String>();
        for (Field f : target.getFields()) {
            String defaultValue = null;
            if (f.isAnnotationPresent(DefaultValue.class)) {
                defaultValue = f.getAnnotation(DefaultValue.class).value();
            } else if (f.isAnnotationPresent(DefaultValueInt.class)) {
                defaultValue = Integer.toString(f.getAnnotation(DefaultValueInt.class).value());
            } else if (f.isAnnotationPresent(DefaultValueBoolean.class)) {
                defaultValue = Boolean.toString(f.getAnnotation(DefaultValueBoolean.class).value());
            }
            try {
                if (defaultValue == null) continue;
                String key = f.get(target).toString();
                configDefaults.put(key, defaultValue);
            }
            catch (IllegalAccessException exc) {
                LOGGER.warn(UNABLE_TO_ACCESS_FIELD_ON_OBJECT, (Object)f.getName(), (Object)target);
            }
        }
        return configDefaults;
    }

    public static <T extends ConfigDefaults> Map<String, Integer> getConfigDefaultsInt(Class<T> target) {
        HashMap<String, Integer> configDefaults = new HashMap<String, Integer>();
        List<Field> fields2 = FieldUtils.getFieldsListWithAnnotation(target, DefaultValueInt.class);
        for (Field f : fields2) {
            try {
                configDefaults.put(f.get(target).toString(), f.getAnnotation(DefaultValueInt.class).value());
            }
            catch (IllegalAccessException exc) {
                LOGGER.warn(UNABLE_TO_ACCESS_FIELD_ON_OBJECT, (Object)f.getName(), (Object)target);
            }
        }
        return configDefaults;
    }

    public static <T extends ConfigDefaults> Map<String, Boolean> getConfigDefaultsBoolean(Class<T> target) {
        HashMap<String, Boolean> configDefaults = new HashMap<String, Boolean>();
        List<Field> fields2 = FieldUtils.getFieldsListWithAnnotation(target, DefaultValueBoolean.class);
        for (Field f : fields2) {
            try {
                configDefaults.put(f.get(target).toString(), f.getAnnotation(DefaultValueBoolean.class).value());
            }
            catch (IllegalAccessException exc) {
                LOGGER.warn(UNABLE_TO_ACCESS_FIELD_ON_OBJECT, (Object)f.getName(), (Object)target);
            }
        }
        return configDefaults;
    }

    public static <T extends ConfigDefaults> boolean isSensitive(Class<T> target, String fieldValue) {
        for (Field f : target.getFields()) {
            try {
                if (!f.isAnnotationPresent(SensitiveValue.class) || !f.get(target).toString().equals(fieldValue)) continue;
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                LOGGER.warn(UNABLE_TO_ACCESS_FIELD_ON_OBJECT, (Object)f.getName(), (Object)target);
            }
        }
        return false;
    }

    public static <T extends ConfigDefaults> String getDefaultValue(Class<T> target, String fieldValue) {
        for (Field f : target.getFields()) {
            try {
                if (!fieldValue.equals(f.get(target).toString())) continue;
                if (f.isAnnotationPresent(DefaultValue.class)) {
                    return f.getAnnotation(DefaultValue.class).value();
                }
                if (f.isAnnotationPresent(DefaultValueInt.class)) {
                    return Integer.toString(f.getAnnotation(DefaultValueInt.class).value());
                }
                if (f.isAnnotationPresent(DefaultValueBoolean.class)) {
                    return Boolean.toString(f.getAnnotation(DefaultValueBoolean.class).value());
                }
                if (!f.isAnnotationPresent(DefaultValueDouble.class)) continue;
                return Double.toString(f.getAnnotation(DefaultValueDouble.class).value());
            }
            catch (IllegalAccessException e) {
                LOGGER.warn(UNABLE_TO_ACCESS_FIELD_ON_OBJECT, (Object)f.getName(), (Object)target);
            }
        }
        throw new IllegalArgumentException(target.getName() + " has no default-annotated field " + fieldValue);
    }

    public static <T extends ConfigDefaults> int getDefaultValueInt(Class<T> target, String fieldValue) {
        for (Field f : target.getFields()) {
            if (!f.isAnnotationPresent(DefaultValueInt.class)) continue;
            try {
                if (!f.get(target).toString().equals(fieldValue)) continue;
                return f.getAnnotation(DefaultValueInt.class).value();
            }
            catch (IllegalAccessException e) {
                LOGGER.warn(UNABLE_TO_ACCESS_FIELD_ON_OBJECT, (Object)f.getName(), (Object)target);
            }
        }
        throw new IllegalArgumentException(target.getName() + " has no integer-default-annotated field " + fieldValue);
    }

    public static <T extends ConfigDefaults> double getDefaultValueDouble(Class<T> target, String fieldValue) {
        for (Field f : target.getFields()) {
            if (!f.isAnnotationPresent(DefaultValueDouble.class)) continue;
            try {
                if (!f.get(target).toString().equals(fieldValue)) continue;
                return f.getAnnotation(DefaultValueDouble.class).value();
            }
            catch (IllegalAccessException e) {
                LOGGER.warn(UNABLE_TO_ACCESS_FIELD_ON_OBJECT, (Object)f.getName(), (Object)target);
            }
        }
        throw new IllegalArgumentException(target.getName() + " has no double-default-annotated field " + fieldValue);
    }

    public static <T extends ConfigDefaults> boolean getDefaultValueBoolean(Class<T> target, String fieldValue) {
        for (Field f : target.getFields()) {
            if (!f.isAnnotationPresent(DefaultValueBoolean.class)) continue;
            try {
                if (!f.get(target).toString().equals(fieldValue)) continue;
                return f.getAnnotation(DefaultValueBoolean.class).value();
            }
            catch (IllegalAccessException e) {
                LOGGER.warn(UNABLE_TO_ACCESS_FIELD_ON_OBJECT, (Object)f.getName(), (Object)target);
            }
        }
        throw new IllegalArgumentException(target.getName() + " has no boolean-default-annotated field " + fieldValue);
    }
}

