/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.settings;

import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValue;

public class BusSettings
implements ConfigDefaults {
    @DefaultValue(value="de.fraunhofer.iosb.ilt.frostserver.messagebus.InternalMessageBus")
    public static final String TAG_IMPLEMENTATION_CLASS = "busImplementationClass";
    private String busImplementationClass;
    private Settings customSettings;

    public BusSettings(Settings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("settings most be non-null");
        }
        this.init(settings);
    }

    private void init(Settings settings) {
        this.busImplementationClass = settings.get(TAG_IMPLEMENTATION_CLASS, this.getClass());
        this.customSettings = settings;
    }

    public String getBusImplementationClass() {
        return this.busImplementationClass;
    }

    public void setBusImplementationClass(String busImplementationClass) {
        if (busImplementationClass == null || busImplementationClass.isEmpty()) {
            throw new IllegalArgumentException("busImplementationClass must be non-empty");
        }
        try {
            Class.forName(busImplementationClass, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("busImplementationClass '" + busImplementationClass + "' could not be found", ex);
        }
        this.busImplementationClass = busImplementationClass;
    }

    public Settings getCustomSettings() {
        return this.customSettings;
    }
}

