/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.service;

import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponse;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceResponseDefault
implements ServiceResponse {
    private Object result;
    private StringWriter resultFormatted = new StringWriter();
    private String contentType;
    private int code;
    private String message;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public ServiceResponseDefault() {
    }

    public ServiceResponseDefault(int code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public ServiceResponseDefault setCode(int code) {
        this.code = code;
        return this;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public ServiceResponseDefault setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public ServiceResponseDefault setResult(Object result) {
        this.result = result;
        return this;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public ServiceResponseDefault setMessage(String message) {
        this.message = message;
        return this;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public ServiceResponseDefault addHeader(String name, String value) {
        this.headers.computeIfAbsent(name, t2 -> new ArrayList()).add(value);
        return this;
    }

    @Override
    public ServiceResponseDefault addHeaders(String name, List<String> values) {
        this.headers.computeIfAbsent(name, t2 -> new ArrayList()).addAll(values);
        return this;
    }

    @Override
    public ServiceResponseDefault setHeader(String name, String value) {
        this.headers.put(name, Arrays.asList(value));
        return this;
    }

    @Override
    public ServiceResponse setStatus(int code, String message) {
        this.code = code;
        this.message = message;
        return this;
    }

    @Override
    public StringWriter getWriter() {
        return this.resultFormatted;
    }

    @Override
    public boolean isSuccessful() {
        return this.code >= 200 && this.code < 300;
    }
}

