/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.service;

import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.JsonReader;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.JsonReaderDefault;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.query.QueryDefaults;
import de.fraunhofer.iosb.ilt.frostserver.service.UpdateMode;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRequest.class);
    private static final ThreadLocal<ServiceRequest> LOCAL_REQUEST = new ThreadLocal();
    private String requestType;
    private String urlPath;
    private String urlQuery;
    private String contentString;
    private InputStream contentBinary;
    private Version version;
    private String contentType;
    private Map<String, List<String>> parameterMap;
    private Map<String, Object> attributeMap = new HashMap<String, Object>();
    private PrincipalExtended userPrincipal = PrincipalExtended.ANONYMOUS_PRINCIPAL;
    private CoreSettings coreSettings;
    private QueryDefaults queryDefaults;
    private UpdateMode updateMode;
    private JsonReader jsonReader;

    public Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    public ServiceRequest setAttributeMap(Map<String, Object> attributeMap) {
        this.attributeMap = attributeMap;
        return this;
    }

    public ServiceRequest setAttribute(String key, Object value) {
        this.attributeMap.put(key, value);
        return this;
    }

    public CoreSettings getCoreSettings() {
        return this.coreSettings;
    }

    public ServiceRequest setCoreSettings(CoreSettings coreSettings) {
        this.coreSettings = coreSettings;
        if (this.queryDefaults == null) {
            this.queryDefaults = coreSettings.getQueryDefaults();
        }
        return this;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public ServiceRequest setRequestType(String requestType) {
        this.requestType = requestType;
        return this;
    }

    public String getContentString() {
        if (this.contentString != null) {
            return this.contentString;
        }
        try {
            return IOUtils.toString(this.contentBinary, StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            LOGGER.debug("Failed to convert input to a string", ex);
            LOGGER.error("Failed to convert input to a string: {}", (Object)ex.getMessage());
            throw new IllegalStateException("Failed to read input.");
        }
    }

    public Reader getContentReader() {
        if (this.contentString != null) {
            return new StringReader(this.contentString);
        }
        return new BufferedReader(new InputStreamReader(this.contentBinary, StandardCharsets.UTF_8));
    }

    public InputStream getContentStream() {
        if (this.contentString != null) {
            return new ByteArrayInputStream(this.contentString.getBytes(StandardCharsets.UTF_8));
        }
        return this.contentBinary;
    }

    public ServiceRequest setContent(InputStream content) {
        this.contentBinary = content;
        return this;
    }

    public ServiceRequest setContent(String content) {
        this.contentString = content;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServiceRequest setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public ServiceRequest setUpdateMode(UpdateMode updateMode) {
        this.updateMode = updateMode;
        return this;
    }

    public Map<String, List<String>> getParameterMap() {
        if (this.parameterMap == null) {
            this.parameterMap = new HashMap<String, List<String>>();
        }
        return this.parameterMap;
    }

    public ServiceRequest setParameterMap(Map<String, List<String>> parameterMap) {
        this.parameterMap = parameterMap;
        return this;
    }

    public String getParameter(String parameter) {
        return this.getParameter(parameter, null);
    }

    public String getParameter(String parameter, String dflt) {
        if (this.parameterMap == null) {
            return dflt;
        }
        List<String> list = this.parameterMap.get(parameter);
        if (list == null || list.isEmpty()) {
            return dflt;
        }
        return list.get(0);
    }

    public ServiceRequest addParameterIfAbsent(String name, String value) {
        this.getParameterMap().putIfAbsent(name, Arrays.asList(value));
        return this;
    }

    public QueryDefaults getQueryDefaults() {
        return this.queryDefaults;
    }

    public ServiceRequest setQueryDefaults(QueryDefaults queryDefaults) {
        this.queryDefaults = queryDefaults;
        return this;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public ServiceRequest setUrlPath(String urlPath) {
        this.urlPath = urlPath;
        return this;
    }

    public String getUrlQuery() {
        return this.urlQuery;
    }

    public ServiceRequest setUrlQuery(String urlQuery) {
        this.urlQuery = urlQuery;
        return this;
    }

    public String getUrl() {
        if (this.urlQuery == null || this.urlQuery.isEmpty()) {
            return this.urlPath;
        }
        return this.urlPath + "?" + this.urlQuery;
    }

    public final ServiceRequest setUrl(String url) {
        if (url.contains("?")) {
            this.urlPath = url.substring(0, url.lastIndexOf(63));
            this.urlQuery = url.substring(url.indexOf(63) + 1);
        } else {
            this.urlPath = url;
            this.urlQuery = null;
        }
        return this;
    }

    public JsonReader getJsonReader() {
        if (this.jsonReader == null) {
            this.jsonReader = new JsonReaderDefault(this.coreSettings.getModelRegistry(), this.userPrincipal);
        }
        return this.jsonReader;
    }

    public ServiceRequest setJsonReader(JsonReader jsonReader) {
        this.jsonReader = jsonReader;
        return this;
    }

    public PrincipalExtended getUserPrincipal() {
        return this.userPrincipal;
    }

    public ServiceRequest setUserPrincipal(PrincipalExtended userPrincipal) {
        this.userPrincipal = userPrincipal;
        return this;
    }

    public Version getVersion() {
        return this.version;
    }

    public ServiceRequest setVersion(Version version) {
        this.version = version;
        return this;
    }

    public static ServiceRequest getLocalRequest() {
        return LOCAL_REQUEST.get();
    }

    public static void setLocalRequest(ServiceRequest localRequest) {
        LOCAL_REQUEST.set(localRequest);
        PrincipalExtended.setLocalPrincipal(localRequest.getUserPrincipal());
    }

    public static void removeLocalRequest() {
        LOCAL_REQUEST.remove();
        PrincipalExtended.removeLocalPrincipal();
    }
}

