/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.github.fge.jsonpatch.JsonPatch;
import de.fraunhofer.iosb.ilt.frostserver.extensions.Extension;
import de.fraunhofer.iosb.ilt.frostserver.formatter.ResultFormatter;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.JsonReader;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.JsonWriter;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.parser.path.PathParser;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.QueryParser;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.UrlHelper;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManagerFactory;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.query.Metadata;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.query.QueryDefaults;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginManager;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginService;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponse;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponseDefault;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.HttpMethod;
import de.fraunhofer.iosb.ilt.frostserver.util.SimpleJsonMapper;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.ForbiddenException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncorrectRequestException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.NoSuchEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.UnauthorizedException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Service
implements AutoCloseable {
    public static final String KEY_SERVER_SETTINGS = "serverSettings";
    public static final String KEY_CONFORMANCE_LIST = "conformance";
    private static final Logger LOGGER = LoggerFactory.getLogger(Service.class);
    private static final String EXCEPTION = "Exception:";
    private static final String POST_ONLY_ALLOWED_TO_COLLECTIONS = "POST only allowed to Collections.";
    private static final String COULD_NOT_PARSE_JSON = "Could not parse json.";
    private static final String FAILED_TO_HANDLE_REQUEST_DETAILS_IN_DEBUG = "Failed to handle request (details in debug): {}";
    private static final String FAILED_TO_UPDATE_ENTITY = "Failed to update entity.";
    private static final String NOTHING_FOUND_RESPONSE = "Nothing found.";
    private final CoreSettings settings;
    private final ModelRegistry modelRegistry;
    private PersistenceManager persistenceManager;
    private boolean transactionActive = false;

    public Service(CoreSettings settings) {
        this.settings = settings;
        this.modelRegistry = settings.getModelRegistry();
        PersistenceManagerFactory.init(settings);
    }

    public String getRequestType(HttpMethod method, Version version, String path, String contentType) {
        PluginService plugin = this.settings.getPluginManager().getServiceForPath(version, path);
        return PluginManager.decodeRequestType(plugin, version, path, method, contentType);
    }

    public ServiceResponse execute(ServiceRequest request, ServiceResponse response) {
        String requestType;
        if (!this.transactionActive) {
            this.getPm().setRole(request.getUserPrincipal());
        }
        if (response == null) {
            response = new ServiceResponseDefault();
        }
        switch (requestType = request.getRequestType()) {
            case "getCapabilities": {
                return this.executeGetCapabilities(request, response);
            }
            case "create": {
                return this.executePost(request, response);
            }
            case "read": {
                return this.executeGet(request, response);
            }
            case "delete": {
                return this.executeDelete(request, response);
            }
            case "updateAll": {
                return this.executePut(request, response);
            }
            case "updateChanged": {
                return this.executePatch(request, response, false);
            }
            case "updateChangeset": {
                return this.executePatch(request, response, true);
            }
        }
        PluginService plugin = this.settings.getPluginManager().getServiceForRequestType(request.getVersion(), requestType);
        if (plugin == null) {
            return Service.errorResponse(response, 500, "Illegal request type.");
        }
        return plugin.execute(this, request, response);
    }

    public Service startTransaction(Principal user) {
        this.getPm().setRole(user);
        this.transactionActive = true;
        return this;
    }

    public Service commitTransaction() {
        this.transactionActive = false;
        this.getPm().commit();
        return this;
    }

    public Service rollbackTransaction() {
        this.transactionActive = false;
        this.getPm().rollback();
        return this;
    }

    @Override
    public void close() {
        this.transactionActive = false;
        if (this.persistenceManager != null) {
            this.persistenceManager.close();
        }
    }

    public void maybeCommitAndClose() {
        if (!this.transactionActive) {
            this.getPm().commitAndClose();
            this.persistenceManager = null;
        }
    }

    public void rollbackAndClose(PersistenceManager pm) {
        if (pm != null) {
            pm.rollbackAndClose();
        }
    }

    public void maybeRollbackAndClose() {
        if (!this.transactionActive) {
            this.getPm().rollbackAndClose();
            this.persistenceManager = null;
        }
    }

    public PersistenceManager getPm() {
        if (this.persistenceManager == null) {
            this.persistenceManager = PersistenceManagerFactory.getInstance(this.settings).create();
        }
        return this.persistenceManager;
    }

    public CoreSettings getSettings() {
        return this.settings;
    }

    private ServiceResponse executeGetCapabilities(ServiceRequest request, ServiceResponse response) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Set<Extension> enabledSettings = this.settings.getEnabledExtensions();
        Version version = request.getVersion();
        ArrayList<Map<String, String>> capList = new ArrayList<Map<String, String>>();
        result.put("value", capList);
        String serviceRootUrl = request.getQueryDefaults().getServiceRootUrl();
        for (EntityType entityType : this.modelRegistry.getEntityTypes(request.getUserPrincipal().isAdmin())) {
            String collectionUri = URI.create(serviceRootUrl + "/" + version.urlPart + "/" + entityType.plural).normalize().toString();
            capList.add(this.createCapability(entityType.plural, collectionUri));
        }
        if (version == Version.V_1_1) {
            LinkedHashMap<String, Object> serverSettings = new LinkedHashMap<String, Object>();
            result.put(KEY_SERVER_SETTINGS, serverSettings);
            TreeSet<String> extensionList = new TreeSet<String>();
            serverSettings.put(KEY_CONFORMANCE_LIST, extensionList);
            for (Extension setting : enabledSettings) {
                if (!setting.isExposedFeature()) continue;
                extensionList.addAll(setting.getRequirements());
            }
            this.settings.getMqttSettings().fillServerSettings(serverSettings);
        }
        this.settings.getPluginManager().modifyServiceDocument(request, result);
        response.setCode(200);
        response.setResult(result);
        return this.formatResponse(request, response, result);
    }

    private ServiceResponse formatResponse(ServiceRequest request, ServiceResponse response, Object result) {
        ResultFormatter formatter;
        try {
            formatter = this.settings.getFormatter(request.getVersion(), "default");
        }
        catch (IncorrectRequestException ex) {
            LOGGER.error("Formatter not available.", ex);
            return Service.errorResponse(response, 500, "Failed to instantiate formatter");
        }
        return this.formatResponse(response, formatter, null, null, result);
    }

    private ServiceResponse formatResponse(ServiceResponse response, ResultFormatter formatter, Query query, ResourcePath path, Object result) {
        response.setContentType(formatter.getContentType());
        try {
            formatter.format(path, query, result, this.settings.getQueryDefaults().useAbsoluteNavigationLinks()).writeFormatted(response.getWriter());
        }
        catch (IOException ex) {
            LOGGER.error("Formatter not available.", ex);
            return Service.errorResponse(response, 500, "Failed to format");
        }
        return response;
    }

    private Map<String, String> createCapability(String name, String url) {
        HashMap<String, String> val = new HashMap<String, String>();
        val.put("name", name);
        val.put("url", url);
        return Collections.unmodifiableMap(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse executeGet(ServiceRequest request, ServiceResponse response) {
        PersistenceManager pm = this.getPm();
        try {
            ServiceResponse serviceResponse = this.handleGet(pm, request, response);
            return serviceResponse;
        }
        catch (UnauthorizedException e) {
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 401, e.getMessage());
            return serviceResponse;
        }
        catch (ForbiddenException e) {
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 403, e.getMessage());
            return serviceResponse;
        }
        catch (Exception e) {
            LOGGER.error(FAILED_TO_HANDLE_REQUEST_DETAILS_IN_DEBUG, (Object)e.getMessage());
            LOGGER.debug(EXCEPTION, e);
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 500, "Failed to execute query. See logs for details.");
            return serviceResponse;
        }
        finally {
            this.maybeRollbackAndClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse handleGet(PersistenceManager pm, ServiceRequest request, ServiceResponse response) {
        ResultFormatter formatter;
        Query query;
        ResourcePath path;
        Version version = request.getVersion();
        QueryDefaults queryDefaults = request.getQueryDefaults();
        try {
            path = PathParser.parsePath(this.modelRegistry, queryDefaults.getServiceRootUrl(), version, request.getUrlPath(), request.getUserPrincipal());
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            return Service.errorResponse(response, 404, ex.getMessage());
        }
        try {
            query = QueryParser.parseQuery(request.getUrlQuery(), queryDefaults, this.modelRegistry, path, request.getUserPrincipal()).validate();
            this.settings.getPluginManager().parsedQuery(this.settings, request, query);
            formatter = this.settings.getFormatter(version, query.getFormat());
            formatter.preProcessRequest(path, query);
        }
        catch (IncorrectRequestException | IllegalArgumentException ex) {
            return Service.errorResponse(response, 400, ex.getMessage());
        }
        if (!pm.validatePath(path)) {
            this.maybeCommitAndClose();
            return Service.errorResponse(response, version.getCannedResponse(Version.CannedResponseType.NOTHING_FOUND));
        }
        try {
            Object object = pm.get(path, query);
            if (object == null) {
                if (path.isValue() || path.isEntityProperty()) {
                    ServiceResponse serviceResponse = Service.successResponse(response, 204, "No Content");
                    return serviceResponse;
                }
                ServiceResponse serviceResponse = Service.errorResponse(response, version.getCannedResponse(Version.CannedResponseType.NOTHING_FOUND));
                return serviceResponse;
            }
            response.setResult(object);
            response.setCode(200);
            ServiceResponse serviceResponse = this.formatResponse(response, formatter, query, path, object);
            return serviceResponse;
        }
        catch (UnsupportedOperationException e) {
            LOGGER.error("Unsupported operation.", e);
            pm.rollbackAndClose();
            ServiceResponse serviceResponse = Service.errorResponse(response, 500, "Unsupported operation: " + e.getMessage());
            return serviceResponse;
        }
        catch (IllegalArgumentException e) {
            LOGGER.trace("Illegal operation.", e);
            pm.rollbackAndClose();
            ServiceResponse serviceResponse = Service.errorResponse(response, 400, "Illegal operation: " + e.getMessage());
            return serviceResponse;
        }
        catch (ClassCastException e) {
            LOGGER.error("Result did not match expected format", e);
            pm.rollbackAndClose();
            ServiceResponse serviceResponse = Service.errorResponse(response, 500, "Illegal result type: " + e.getMessage());
            return serviceResponse;
        }
        finally {
            this.maybeCommitAndClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse executePost(ServiceRequest request, ServiceResponse response) {
        String urlPath = request.getUrlPath();
        if (urlPath == null || urlPath.equals("/")) {
            return Service.errorResponse(response, 400, POST_ONLY_ALLOWED_TO_COLLECTIONS);
        }
        PersistenceManager pm = this.getPm();
        try {
            ServiceResponse serviceResponse = this.handlePost(pm, urlPath, response, request);
            return serviceResponse;
        }
        catch (UnauthorizedException e) {
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 401, e.getMessage());
            return serviceResponse;
        }
        catch (ForbiddenException e) {
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 403, e.getMessage());
            return serviceResponse;
        }
        catch (IllegalArgumentException e) {
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 400, "Incorrect request: " + e.getMessage());
            return serviceResponse;
        }
        catch (IOException | RuntimeException e) {
            LOGGER.error(FAILED_TO_HANDLE_REQUEST_DETAILS_IN_DEBUG, (Object)e.getMessage());
            LOGGER.debug(EXCEPTION, e);
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 500, "Failed to store data.");
            return serviceResponse;
        }
        finally {
            this.maybeRollbackAndClose();
        }
    }

    private ServiceResponse handlePost(PersistenceManager pm, String urlPath, ServiceResponse response, ServiceRequest request) throws IOException {
        Entity entity;
        ResultFormatter formatter;
        Query query;
        ResourcePath path;
        Version version = request.getVersion();
        QueryDefaults queryDefaults = request.getQueryDefaults();
        try {
            path = PathParser.parsePath(this.modelRegistry, queryDefaults.getServiceRootUrl(), version, urlPath, request.getUserPrincipal());
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            return Service.errorResponse(response, 404, ex.getMessage());
        }
        if (!(path.getMainElement() instanceof PathElementEntitySet)) {
            return Service.errorResponse(response, 400, POST_ONLY_ALLOWED_TO_COLLECTIONS);
        }
        try {
            query = QueryParser.parseQuery(request.getUrlQuery(), queryDefaults, this.modelRegistry, path, request.getUserPrincipal()).validate();
            this.settings.getPluginManager().parsedQuery(this.settings, request, query);
            formatter = this.findFormatter(query, request, version);
        }
        catch (IncorrectRequestException | IllegalArgumentException ex) {
            return Service.errorResponse(response, 400, ex.getMessage());
        }
        if (!pm.validatePath(path)) {
            this.maybeCommitAndClose();
            return Service.errorResponse(response, 404, NOTHING_FOUND_RESPONSE);
        }
        PathElementEntitySet mainSet = (PathElementEntitySet)path.getMainElement();
        EntityType type = mainSet.getEntityType();
        JsonReader jsonReader = request.getJsonReader();
        try {
            entity = jsonReader.parseEntity(type, request.getContentReader());
            if (mainSet.getParent() != null) {
                type.setParent(mainSet, entity);
            }
            type.validateCreate(entity);
            this.settings.getCustomLinksHelper().cleanPropertiesMap(entity);
        }
        catch (JsonParseException | JsonMappingException | IncompleteEntityException | IllegalStateException ex) {
            LOGGER.trace("Post failed.", ex);
            return Service.errorResponse(response, 400, ex.getMessage());
        }
        try {
            if (!pm.insert(entity, request.getUpdateMode())) {
                LOGGER.debug("No need to insert entity.");
            }
            this.maybeCommitAndClose();
            entity.setQuery(query);
            response.setResult(entity);
            response.setCode(201);
            if (query.getMetadata() != Metadata.OFF) {
                String url = UrlHelper.generateSelfLink(path, entity);
                response.addHeader("Location", url);
            }
            return this.formatResponse(response, formatter, query, path, entity);
        }
        catch (IncompleteEntityException | NoSuchEntityException | IllegalArgumentException e) {
            pm.rollbackAndClose();
            return Service.errorResponse(response, 400, e.getMessage());
        }
    }

    public ResultFormatter findFormatter(Query query, ServiceRequest request, Version version) throws IncorrectRequestException {
        String format = query.getFormat();
        if (format == null) {
            format = request.getParameter("$format");
        }
        ResultFormatter formatter = this.settings.getFormatter(version, format);
        return formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse executePatch(ServiceRequest request, ServiceResponse response, boolean isChangeSet) {
        PersistenceManager pm = null;
        try {
            if (request.getUrlPath() == null || request.getUrlPath().equals("/")) {
                ServiceResponse serviceResponse = Service.errorResponse(response, 400, "PATCH only allowed on Entities.");
                return serviceResponse;
            }
            pm = this.getPm();
            if (isChangeSet) {
                ServiceResponse serviceResponse = this.handleChangeSet(pm, request, response);
                return serviceResponse;
            }
            ServiceResponse serviceResponse = this.handlePatch(pm, request, response);
            return serviceResponse;
        }
        catch (UnauthorizedException e) {
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 401, e.getMessage());
            return serviceResponse;
        }
        catch (ForbiddenException e) {
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 403, e.getMessage());
            return serviceResponse;
        }
        catch (IncompleteEntityException | IOException | RuntimeException exc) {
            LOGGER.error(FAILED_TO_HANDLE_REQUEST_DETAILS_IN_DEBUG, (Object)exc.getMessage());
            LOGGER.debug(EXCEPTION, exc);
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 500, "Failed to store data.");
            return serviceResponse;
        }
        finally {
            this.maybeRollbackAndClose();
        }
    }

    private ServiceResponse handlePatch(PersistenceManager pm, ServiceRequest request, ServiceResponse response) throws IOException {
        Entity entity;
        PathElementEntity mainElement;
        try {
            mainElement = this.parsePathForPutPatch(pm, request);
            JsonReader entityParser = request.getJsonReader();
            entity = entityParser.parseEntity(mainElement.getEntityType(), request.getContentReader());
            this.settings.getCustomLinksHelper().cleanPropertiesMap(entity);
            entity.getEntityType().validateUpdate(entity);
        }
        catch (IllegalArgumentException exc) {
            LOGGER.trace("Path not valid for patch.", exc);
            return Service.errorResponse(response, 400, exc.getMessage());
        }
        catch (JsonParseException | JsonMappingException exc) {
            LOGGER.trace(COULD_NOT_PARSE_JSON, exc);
            return Service.errorResponse(response, 400, "Could not parse json. " + exc.getMessage());
        }
        catch (IncompleteEntityException | NoSuchEntityException exc) {
            return Service.errorResponse(response, 404, exc.getMessage());
        }
        try {
            if (pm.update(mainElement, entity, request.getUpdateMode())) {
                this.maybeCommitAndClose();
                response.setCode(200);
                return response;
            }
            pm.rollbackAndClose();
            return Service.errorResponse(response, 400, "Failed to patch entity.");
        }
        catch (IncompleteEntityException | NoSuchEntityException | IllegalArgumentException e) {
            pm.rollbackAndClose();
            return Service.errorResponse(response, 400, e.getMessage());
        }
    }

    private ServiceResponse handleChangeSet(PersistenceManager pm, ServiceRequest request, ServiceResponse response) throws IOException, IncompleteEntityException {
        JsonPatch jsonPatch;
        PathElementEntity mainElement;
        try {
            mainElement = this.parsePathForPutPatch(pm, request);
            jsonPatch = SimpleJsonMapper.getSimpleObjectMapper().readValue(request.getContentReader(), JsonPatch.class);
        }
        catch (IllegalArgumentException exc) {
            LOGGER.trace("Path not valid.", exc);
            return Service.errorResponse(response, 400, exc.getMessage());
        }
        catch (JsonParseException exc) {
            LOGGER.trace(COULD_NOT_PARSE_JSON, exc);
            return Service.errorResponse(response, 400, COULD_NOT_PARSE_JSON);
        }
        catch (NoSuchEntityException exc) {
            return Service.errorResponse(response, 404, exc.getMessage());
        }
        try {
            if (pm.update(mainElement, jsonPatch)) {
                this.maybeCommitAndClose();
                return Service.successResponse(response, 200, "JSON-Patch applied.");
            }
            pm.rollbackAndClose();
            return Service.errorResponse(response, 400, FAILED_TO_UPDATE_ENTITY);
        }
        catch (NoSuchEntityException | IllegalArgumentException e) {
            pm.rollbackAndClose();
            return Service.errorResponse(response, 400, e.getMessage());
        }
    }

    private PathElementEntity parsePathForPutPatch(PersistenceManager pm, ServiceRequest request) throws NoSuchEntityException {
        ResourcePath path;
        try {
            path = PathParser.parsePath(this.modelRegistry, request.getQueryDefaults().getServiceRootUrl(), request.getVersion(), request.getUrlPath(), request.getUserPrincipal());
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            throw new NoSuchEntityException(ex.getMessage());
        }
        if (!pm.validatePath(path)) {
            throw new NoSuchEntityException("No entity found for path.");
        }
        if (!(path.getMainElement() instanceof PathElementEntity) || path.getMainElement() != path.getLastElement()) {
            throw new IllegalArgumentException("PATCH & PUT only allowed on Entities.");
        }
        PathElementEntity mainElement = (PathElementEntity)path.getMainElement();
        if (!mainElement.primaryKeyFullySet()) {
            throw new IllegalArgumentException("PATCH & PUT only allowed on Entities.");
        }
        if (request.getUrlQuery() != null && !request.getUrlQuery().isEmpty()) {
            throw new IllegalArgumentException("No query options allowed on PATCH & PUT.");
        }
        return mainElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse executePut(ServiceRequest request, ServiceResponse response) {
        PersistenceManager pm = null;
        try {
            if (request.getUrlPath() == null || request.getUrlPath().equals("/")) {
                ServiceResponse serviceResponse = Service.errorResponse(response, 400, "PATCH only allowed on Entities.");
                return serviceResponse;
            }
            pm = this.getPm();
            ServiceResponse serviceResponse = this.handlePut(pm, request, response);
            return serviceResponse;
        }
        catch (UnauthorizedException e) {
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 401, e.getMessage());
            return serviceResponse;
        }
        catch (ForbiddenException e) {
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 403, e.getMessage());
            return serviceResponse;
        }
        catch (IncompleteEntityException | IOException | RuntimeException e) {
            LOGGER.trace("Failed to handle request", e);
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 400, e.getMessage());
            return serviceResponse;
        }
        finally {
            this.maybeRollbackAndClose();
        }
    }

    private ServiceResponse handlePut(PersistenceManager pm, ServiceRequest request, ServiceResponse response) throws IOException, IncompleteEntityException {
        Entity entity;
        PathElementEntity mainElement;
        try {
            mainElement = this.parsePathForPutPatch(pm, request);
            JsonReader entityParser = request.getJsonReader();
            entity = entityParser.parseEntity(mainElement.getEntityType(), request.getContentReader());
            entity.validateUpdate();
            this.settings.getCustomLinksHelper().cleanPropertiesMap(entity);
            entity.setEntityPropertiesSet(true, true);
        }
        catch (IllegalArgumentException exc) {
            LOGGER.trace("Path not valid.", exc);
            return Service.errorResponse(response, 400, exc.getMessage());
        }
        catch (JsonParseException | IncompleteEntityException exc) {
            LOGGER.trace(COULD_NOT_PARSE_JSON, exc);
            return Service.errorResponse(response, 400, COULD_NOT_PARSE_JSON);
        }
        catch (NoSuchEntityException exc) {
            return Service.errorResponse(response, 404, exc.getMessage());
        }
        try {
            if (pm.update(mainElement, entity, request.getUpdateMode())) {
                this.maybeCommitAndClose();
                return Service.successResponse(response, 200, "Updated.");
            }
            pm.rollbackAndClose();
            return Service.errorResponse(response, 400, FAILED_TO_UPDATE_ENTITY);
        }
        catch (NoSuchEntityException e) {
            pm.rollbackAndClose();
            return Service.errorResponse(response, 400, e.getMessage());
        }
    }

    private ServiceResponse executeDelete(ServiceRequest request, ServiceResponse response) {
        ResourcePath path;
        if (request.getUrlPath() == null || request.getUrlPath().equals("/")) {
            return Service.errorResponse(response, 400, "DELETE only allowed on Entities and Sets.");
        }
        try {
            path = PathParser.parsePath(this.modelRegistry, request.getQueryDefaults().getServiceRootUrl(), request.getVersion(), request.getUrlPath(), request.getUserPrincipal());
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            return Service.errorResponse(response, 404, ex.getMessage());
        }
        if (path.isRef()) {
            return this.executeDeleteRef(request, response, path);
        }
        if (path.getMainElement() instanceof PathElementEntity) {
            return this.executeDeleteEntity(request, response, path);
        }
        if (this.settings.isFilterDeleteEnabled() && path.getMainElement() instanceof PathElementEntitySet) {
            return this.executeDeleteSet(request, response, path);
        }
        return Service.errorResponse(response, 400, "Not a valid path for DELETE.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse executeDeleteEntity(ServiceRequest request, ServiceResponse response, ResourcePath path) {
        PersistenceManager pm = null;
        try {
            PathElementEntity mainEntity = (PathElementEntity)path.getMainElement();
            if (mainEntity != path.getLastElement()) {
                ServiceResponse serviceResponse = Service.errorResponse(response, 400, "DELETE not allowed on properties.");
                return serviceResponse;
            }
            if (!mainEntity.primaryKeyFullySet()) {
                ServiceResponse serviceResponse = Service.errorResponse(response, 400, "No ID found.");
                return serviceResponse;
            }
            if (request.getUrlQuery() != null && !request.getUrlQuery().isEmpty()) {
                ServiceResponse serviceResponse = Service.errorResponse(response, 400, "No query options allowed on PATH when deleting an entity.");
                return serviceResponse;
            }
            pm = this.getPm();
            if (!pm.validatePath(path)) {
                this.maybeCommitAndClose();
                ServiceResponse serviceResponse = Service.errorResponse(response, 404, NOTHING_FOUND_RESPONSE);
                return serviceResponse;
            }
            ServiceResponse serviceResponse = this.handleDeleteEntity(pm, mainEntity, response);
            return serviceResponse;
        }
        catch (UnauthorizedException e) {
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 401, e.getMessage());
            return serviceResponse;
        }
        catch (ForbiddenException e) {
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 403, e.getMessage());
            return serviceResponse;
        }
        catch (Exception e) {
            LOGGER.trace("", e);
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 400, e.getMessage());
            return serviceResponse;
        }
        finally {
            this.maybeRollbackAndClose();
        }
    }

    private ServiceResponse handleDeleteEntity(PersistenceManager pm, PathElementEntity mainEntity, ServiceResponse response) {
        try {
            if (pm.delete(mainEntity)) {
                this.maybeCommitAndClose();
                response.setCode(200);
                return response;
            }
            pm.rollbackAndClose();
            return Service.errorResponse(response, 400, "Failed to delete entity.");
        }
        catch (NoSuchEntityException e) {
            pm.rollbackAndClose();
            return Service.errorResponse(response, 404, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse executeDeleteSet(ServiceRequest request, ServiceResponse response, ResourcePath path) {
        PersistenceManager pm = null;
        try {
            PathElementEntitySet mainEntity = (PathElementEntitySet)path.getMainElement();
            if (mainEntity != path.getLastElement()) {
                ServiceResponse serviceResponse = Service.errorResponse(response, 400, "DELETE not allowed on properties.");
                return serviceResponse;
            }
            pm = this.getPm();
            if (!pm.validatePath(path)) {
                this.maybeCommitAndClose();
                ServiceResponse serviceResponse = Service.errorResponse(response, 404, NOTHING_FOUND_RESPONSE);
                return serviceResponse;
            }
            ServiceResponse serviceResponse = this.handleDeleteSet(request, response, pm, path);
            return serviceResponse;
        }
        catch (ForbiddenException e) {
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 403, e.getMessage());
            return serviceResponse;
        }
        catch (UnauthorizedException e) {
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 401, e.getMessage());
            return serviceResponse;
        }
        catch (Exception e) {
            LOGGER.trace("", e);
            this.rollbackAndClose(pm);
            ServiceResponse serviceResponse = Service.errorResponse(response, 400, e.getMessage());
            return serviceResponse;
        }
        finally {
            this.maybeRollbackAndClose();
        }
    }

    private ServiceResponse handleDeleteSet(ServiceRequest request, ServiceResponse response, PersistenceManager pm, ResourcePath path) {
        Query query;
        try {
            query = QueryParser.parseQuery(request.getUrlQuery(), request.getQueryDefaults(), this.modelRegistry, path, request.getUserPrincipal()).validate();
            this.settings.getPluginManager().parsedQuery(this.settings, request, query);
        }
        catch (IllegalArgumentException e) {
            return Service.errorResponse(response, 400, "Failed to parse query: " + e.getMessage());
        }
        if (query.getCount().isPresent()) {
            return Service.errorResponse(response, 400, "$count not allowed on delete requests.");
        }
        if (!query.getExpand().isEmpty()) {
            return Service.errorResponse(response, 400, "$expand not allowed on delete requests.");
        }
        if (query.getTop().isPresent()) {
            return Service.errorResponse(response, 400, "$top not allowed on delete requests.");
        }
        if (query.getSkip().isPresent()) {
            return Service.errorResponse(response, 400, "$skip not allowed on delete requests.");
        }
        try {
            pm.delete(path, query);
            this.maybeCommitAndClose();
            return Service.successResponse(response, 200, "Deleted.");
        }
        catch (NoSuchEntityException e) {
            pm.rollbackAndClose();
            return Service.errorResponse(response, 404, e.getMessage());
        }
    }

    private ServiceResponse executeDeleteRef(ServiceRequest request, ServiceResponse response, ResourcePath path) {
        LinkData linkData;
        PersistenceManager pm = this.getPm();
        if (!pm.validatePath(path)) {
            this.maybeRollbackAndClose();
            return Service.errorResponse(response, 404, NOTHING_FOUND_RESPONSE);
        }
        List<PathElement> pathElements = path.getPathElements();
        if (pathElements.size() < 2) {
            return Service.errorResponse(response, 400, "Path must contain at least an Entity and a NavigationProperty to delete a reference.");
        }
        PathElement lastElement = path.getLastElement();
        if (lastElement instanceof PathElementEntitySet) {
            PathElementEntitySet containingSet = (PathElementEntitySet)lastElement;
            linkData = this.parseForRefWithId(request, path, containingSet);
        } else if (lastElement instanceof PathElementEntity) {
            PathElementEntity peEntity = (PathElementEntity)lastElement;
            linkData = this.parseForRefInPath(path, peEntity);
        } else {
            return Service.errorResponse(response, 400, "Not a valid DELETE-Reference action.");
        }
        if (linkData.message != null) {
            return Service.errorResponse(response, 400, linkData.message);
        }
        if (!linkData.navigationProperty.getEntityType().equals(linkData.targetEntity.getEntityType())) {
            return Service.errorResponse(response, 400, "Target Entity does not match NavigationProperty type: " + linkData.targetEntity.getEntityType().entityName + " != " + linkData.navigationProperty.getEntityType().entityName);
        }
        try {
            pm.deleteRelation(linkData.sourceEntity, linkData.navigationProperty, linkData.targetEntity);
            this.maybeCommitAndClose();
            return Service.successResponse(response, 204, "");
        }
        catch (IncompleteEntityException ex) {
            pm.rollbackAndClose();
            return Service.errorResponse(response, 405, ex.getMessage());
        }
        catch (NoSuchEntityException ex) {
            return Service.errorResponse(response, 404, ex.getMessage());
        }
    }

    private LinkData parseForRefWithId(ServiceRequest request, ResourcePath path, PathElementEntitySet containingSet) {
        PathElementEntity pathElementEntity;
        Query query;
        List<PathElement> pathElements = path.getPathElements();
        PathElement precedingElement = pathElements.get(pathElements.size() - 2);
        if (!(precedingElement instanceof PathElementEntity)) {
            return LinkData.error("NavigationProperty must be preceded by an Entity.");
        }
        NavigationPropertyMain.NavigationPropertyEntitySet navigationProperty = containingSet.getNavigationProperty();
        PathElementEntity sourceEntity = containingSet.getParent();
        QueryDefaults queryDefaults = request.getQueryDefaults();
        try {
            query = QueryParser.parseQuery(request.getUrlQuery(), queryDefaults, this.modelRegistry, path, request.getUserPrincipal()).validate();
            this.settings.getPluginManager().parsedQuery(this.settings, request, query);
        }
        catch (IllegalArgumentException ex) {
            return LinkData.error("Failed to parse query: " + ex.getMessage());
        }
        String targetUrl = query.getId();
        String serviceRootUrl = queryDefaults.getServiceRootUrl();
        Version version = request.getVersion();
        String versionUrl = version.urlPart;
        if (!targetUrl.startsWith(serviceRootUrl)) {
            try {
                URL requestUrl = new URL(serviceRootUrl + "/" + versionUrl + request.getUrlPath());
                targetUrl = new URL(requestUrl, targetUrl).toString();
            }
            catch (MalformedURLException ex) {
                return LinkData.error("Failed to parse URL in $id: " + ex.getMessage());
            }
        }
        if (!targetUrl.startsWith(serviceRootUrl)) {
            return LinkData.error("$id parameter must be a relative URL or an absolute URL in this service (Thus start with '" + serviceRootUrl + "'.");
        }
        if (!(targetUrl = targetUrl.substring(serviceRootUrl.length() + 1)).startsWith(versionUrl)) {
            return LinkData.error("$id parameter must use the same version as the request ('" + versionUrl + "').");
        }
        ResourcePath targetPath = PathParser.parsePath(this.modelRegistry, serviceRootUrl, version, targetUrl = targetUrl.substring(versionUrl.length()), request.getUserPrincipal());
        PathElement lastTargetElement = targetPath.getLastElement();
        if (!(lastTargetElement instanceof PathElementEntity)) {
            return LinkData.error("$id parameter does not point to an Entity.");
        }
        PathElementEntity targetEntity = pathElementEntity = (PathElementEntity)lastTargetElement;
        return LinkData.ok(sourceEntity, navigationProperty, targetEntity);
    }

    private LinkData parseForRefInPath(ResourcePath path, PathElementEntity lastElement) {
        PathElementEntitySet peEntitySet;
        int lastIdx;
        List<PathElement> pathElements = path.getPathElements();
        PathElement precedingElement = pathElements.get((lastIdx = pathElements.size() - 1) - 1);
        if (!(precedingElement instanceof PathElementEntitySet)) {
            return LinkData.error("Not a valid DELETE-Reference action.");
        }
        PathElementEntitySet containingSet = peEntitySet = (PathElementEntitySet)precedingElement;
        NavigationPropertyMain.NavigationPropertyEntitySet navigationProperty = containingSet.getNavigationProperty();
        PathElementEntity sourceEntity = containingSet.getParent();
        if (!sourceEntity.primaryKeyFullySet() || !lastElement.primaryKeyFullySet()) {
            return LinkData.error("Could not find Id for source or target entity.");
        }
        return LinkData.ok(sourceEntity, navigationProperty, lastElement);
    }

    public static ServiceResponse successResponse(ServiceResponse response, Version.CannedResponse cr) {
        return Service.successResponse(response, cr.code, cr.message);
    }

    public static ServiceResponse successResponse(ServiceResponse response, int code, String message) {
        return Service.jsonResponse(response, "success", code, message);
    }

    public static ServiceResponse errorResponse(ServiceResponse response, Version.CannedResponse cr) {
        return Service.errorResponse(response, cr.code, cr.message);
    }

    public static ServiceResponse errorResponse(ServiceResponse response, int code, String message) {
        if (code < 500) {
            LOGGER.debug("{} response: {}", (Object)code, (Object)message);
        }
        if (response == null) {
            response = new ServiceResponseDefault();
        }
        return Service.jsonResponse(response, "error", code, message);
    }

    public static ServiceResponse jsonResponse(ServiceResponse response, String type, int code, String message) {
        String cleanMessage = StringHelper.cleanForOutput(message, 200);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("type", type);
        body.put("code", code);
        body.put("message", cleanMessage);
        try {
            return response.setStatus(code, JsonWriter.writeObject(body));
        }
        catch (IOException ex) {
            LOGGER.error("Failed to serialise error response.", ex);
            return response.setStatus(code, cleanMessage);
        }
    }

    private record LinkData(PathElementEntity sourceEntity, NavigationPropertyMain.NavigationPropertyEntitySet navigationProperty, PathElementEntity targetEntity, String message) {
        public static LinkData ok(PathElementEntity sourceEntity, NavigationPropertyMain.NavigationPropertyEntitySet navigationProperty, PathElementEntity targetEntity) {
            return new LinkData(sourceEntity, navigationProperty, targetEntity, null);
        }

        public static LinkData error(String message) {
            return new LinkData(null, null, null, message);
        }
    }
}

