/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.service;

import de.fraunhofer.iosb.ilt.frostserver.formatter.ResultFormatter;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManagerFactory;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.service.InitResult;
import de.fraunhofer.iosb.ilt.frostserver.service.Plugin;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginModel;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginResultFormat;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginRootDocument;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginService;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValue;
import de.fraunhofer.iosb.ilt.frostserver.util.HttpMethod;
import de.fraunhofer.iosb.ilt.frostserver.util.LiquibaseUser;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager
implements ConfigDefaults {
    public static final String VALUE_PROVIDED_PLUGINS = "de.fraunhofer.iosb.ilt.frostserver.plugin.coremodel.PluginCoreService,de.fraunhofer.iosb.ilt.frostserver.plugin.coremodel.PluginCoreModel,de.fraunhofer.iosb.ilt.frostserver.formatter.PluginResultFormatDefault,de.fraunhofer.iosb.ilt.frostserver.plugin.actuation.PluginActuation,de.fraunhofer.iosb.ilt.frostserver.plugin.multidatastream.PluginMultiDatastream,de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.PluginBatchProcessing,de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.PluginResultFormatDataArray,de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.PluginResultFormatCsv,de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.PluginResultFormatGeoJson,de.fraunhofer.iosb.ilt.frostserver.plugin.odata.PluginOData,de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.PluginOpenApi,de.fraunhofer.iosb.ilt.frostserver.plugin.modelloader.PluginModelLoader,de.fraunhofer.iosb.ilt.frostserver.plugin.coremodelv2.PluginCoreModelV2,de.fraunhofer.iosb.ilt.frostserver.plugin.modelom.PluginModelOM,de.fraunhofer.iosb.ilt.frostserver.plugin.modelsampling.PluginModelSampling,de.fraunhofer.iosb.ilt.frostserver.plugin.modelrelations.PluginModelRelations,de.fraunhofer.iosb.ilt.frostserver.plugin.projects.PluginProjects";
    @DefaultValue(value="de.fraunhofer.iosb.ilt.frostserver.plugin.coremodel.PluginCoreService,de.fraunhofer.iosb.ilt.frostserver.plugin.coremodel.PluginCoreModel,de.fraunhofer.iosb.ilt.frostserver.formatter.PluginResultFormatDefault,de.fraunhofer.iosb.ilt.frostserver.plugin.actuation.PluginActuation,de.fraunhofer.iosb.ilt.frostserver.plugin.multidatastream.PluginMultiDatastream,de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.PluginBatchProcessing,de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.PluginResultFormatDataArray,de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.PluginResultFormatCsv,de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.PluginResultFormatGeoJson,de.fraunhofer.iosb.ilt.frostserver.plugin.odata.PluginOData,de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.PluginOpenApi,de.fraunhofer.iosb.ilt.frostserver.plugin.modelloader.PluginModelLoader,de.fraunhofer.iosb.ilt.frostserver.plugin.coremodelv2.PluginCoreModelV2,de.fraunhofer.iosb.ilt.frostserver.plugin.modelom.PluginModelOM,de.fraunhofer.iosb.ilt.frostserver.plugin.modelsampling.PluginModelSampling,de.fraunhofer.iosb.ilt.frostserver.plugin.modelrelations.PluginModelRelations,de.fraunhofer.iosb.ilt.frostserver.plugin.projects.PluginProjects")
    public static final String TAG_PROVIDED_PLUGINS = "providedPlugins";
    @DefaultValue(value="")
    public static final String TAG_PLUGINS = "plugins";
    public static final String PATH_WILDCARD = "*";
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginManager.class);
    private final List<PluginResultFormat> resultFormatPlugins = new ArrayList<PluginResultFormat>();
    private final Map<Version, Map<String, PluginResultFormat>> resultFormattersByFormat = new HashMap<Version, Map<String, PluginResultFormat>>();
    private final Map<Version, List<PluginResultFormat>> resultFormatters = new HashMap<Version, List<PluginResultFormat>>();
    private final Map<Version, Map<String, PluginService>> pathHandlers = new HashMap<Version, Map<String, PluginService>>();
    private final Map<Version, Map<String, PluginService>> requestTypeHandlers = new HashMap<Version, Map<String, PluginService>>();
    private final List<PluginRootDocument> serviceDocModifiers = new ArrayList<PluginRootDocument>();
    private final List<PluginModel> modelModifiers = new ArrayList<PluginModel>();
    private final Map<Class<? extends Plugin>, Object> plugins = new HashMap<Class<? extends Plugin>, Object>();
    private final Map<String, Version> versions = new TreeMap<String, Version>();
    private CoreSettings settings;

    public PluginManager setCoreSettings(CoreSettings settings) {
        this.settings = settings;
        return this;
    }

    public void init() {
        Settings pluginSettings = this.settings.getPluginSettings();
        String provided = pluginSettings.get(TAG_PROVIDED_PLUGINS, this.getClass()).trim();
        String extra = pluginSettings.get(TAG_PLUGINS, this.getClass()).trim();
        LOGGER.info("Loading plugins...");
        this.loadPlugins(provided);
        this.loadPlugins(extra);
        this.initPlugins(PersistenceManagerFactory.getInstance(this.settings).create());
    }

    public void initPlugins(PersistenceManager pm) {
        this.initResultFormatters();
        ModelRegistry modelRegistry = this.settings.getModelRegistry();
        for (PluginModel plugin : this.modelModifiers) {
            plugin.registerEntityTypes();
        }
        ArrayList<PluginModel> redo = new ArrayList<PluginModel>(this.modelModifiers);
        int pass = 0;
        while (!redo.isEmpty() && pass < 5) {
            LOGGER.info("Initialising data model plugins. Pass {}, {} plugins.", (Object)(++pass), (Object)redo.size());
            Iterator it = redo.iterator();
            while (it.hasNext()) {
                PluginModel plugin = (PluginModel)it.next();
                if (!plugin.linkEntityTypes(pm)) continue;
                it.remove();
            }
        }
        if (!redo.isEmpty()) {
            LOGGER.error("Failed to initialise {} data model plugins:", (Object)redo.size());
            for (PluginModel plugin : redo) {
                LOGGER.error("    {}", (Object)plugin.getClass().getName());
            }
        }
        for (PluginModel plugin : this.modelModifiers) {
            plugin.installSecurityDefinitions(pm);
        }
        modelRegistry.initFinalise();
    }

    private void loadPlugins(String classList) {
        if (classList.isEmpty()) {
            return;
        }
        ArrayList<Plugin> pluginsToLoad = new ArrayList<Plugin>();
        String[] split = classList.trim().split(",");
        LOGGER.info("Loading {} plugins...", (Object)split.length);
        for (String className : split) {
            try {
                LOGGER.info("Loading {}", (Object)className);
                Class<Plugin> clazz = this.getClass().getClassLoader().loadClass(className.trim()).asSubclass(Plugin.class);
                Plugin plugin = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                pluginsToLoad.add(plugin);
            }
            catch (ClassNotFoundException | NoClassDefFoundError ex) {
                LOGGER.warn("Could not find given plugin class: '{}': {}", (Object)StringHelper.cleanForLogging(className), (Object)ex.getMessage());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                LOGGER.warn("Could not load given plugin class: '{}': {}", (Object)StringHelper.cleanForLogging(className), (Object)ex.getMessage());
                LOGGER.info("Exception:", ex);
            }
            catch (RuntimeException ex) {
                LOGGER.warn("Plugin caused an exception during loading.", ex);
            }
        }
        while (!pluginsToLoad.isEmpty()) {
            int count = pluginsToLoad.size();
            LOGGER.info("Initialising {} plugins...", (Object)count);
            Iterator it = pluginsToLoad.iterator();
            while (it.hasNext()) {
                Plugin plugin = (Plugin)it.next();
                try {
                    LOGGER.info("Initialising {}", (Object)plugin.getClass().getName());
                    InitResult result = plugin.init(this.settings);
                    switch (result) {
                        case INIT_DELAY: {
                            break;
                        }
                        case INIT_FAILED: {
                            LOGGER.warn("Failed to initialise plugin: '{}'", (Object)plugin);
                            it.remove();
                            break;
                        }
                        default: {
                            it.remove();
                            break;
                        }
                    }
                }
                catch (RuntimeException ex) {
                    LOGGER.warn("Plugin caused an exception during initialisation.", ex);
                }
            }
            if (count != pluginsToLoad.size()) continue;
            LOGGER.error("All {} remaining plugins can not be initialised", (Object)count);
            break;
        }
    }

    public void registerPlugin(Plugin plugin) {
        if (plugin instanceof PluginService) {
            PluginService ps = (PluginService)plugin;
            this.registerPlugin(ps);
        }
        if (plugin instanceof PluginRootDocument) {
            PluginRootDocument prd = (PluginRootDocument)plugin;
            this.serviceDocModifiers.add(prd);
        }
        if (plugin instanceof PluginModel) {
            PluginModel pm = (PluginModel)plugin;
            this.modelModifiers.add(pm);
        }
        if (plugin instanceof PluginResultFormat) {
            PluginResultFormat prf = (PluginResultFormat)plugin;
            this.resultFormatPlugins.add(prf);
        }
        if (plugin instanceof LiquibaseUser) {
            LiquibaseUser lu = (LiquibaseUser)((Object)plugin);
            this.settings.addLiquibaseUser(lu);
        }
        this.plugins.put(plugin.getClass(), plugin);
    }

    private void initResultFormatters() {
        for (PluginResultFormat plugin : this.resultFormatPlugins) {
            this.initResultFormatter(plugin);
        }
    }

    private void initResultFormatter(PluginResultFormat plugin) {
        Collection<Version> pluginVersions = plugin.getVersions();
        Collection<String> formatNames = plugin.getFormatNames();
        for (Version version : pluginVersions) {
            this.resultFormatters.computeIfAbsent(version, t2 -> new ArrayList()).add(plugin);
            for (String format : formatNames) {
                if (!this.versions.containsKey(version.urlPart)) continue;
                this.resultFormattersByFormat.computeIfAbsent(version, v -> new TreeMap()).put(format.toLowerCase(), plugin);
            }
        }
    }

    private void registerPlugin(PluginService plugin) {
        Collection<Version> pluginVersions = plugin.getVersions();
        if (plugin.definesVersions()) {
            for (Version version : pluginVersions) {
                this.versions.put(version.urlPart, version);
            }
        }
        for (String path : plugin.getVersionedUrlPaths()) {
            for (Version version : pluginVersions) {
                if (!this.versions.containsKey(version.urlPart)) continue;
                this.pathHandlers.computeIfAbsent(version, v -> new TreeMap()).put(path, plugin);
            }
            for (String type : plugin.getRequestTypes()) {
                for (Version version : pluginVersions) {
                    if (!this.versions.containsKey(version.urlPart)) continue;
                    this.requestTypeHandlers.computeIfAbsent(version, t2 -> new TreeMap()).put(type, plugin);
                }
            }
        }
    }

    public <P extends Plugin> boolean isPluginEnabled(Class<P> pluginClass) {
        P plugin = this.getPlugin(pluginClass);
        if (plugin == null) {
            return false;
        }
        return plugin.isEnabled();
    }

    public <P extends Plugin> P getPlugin(Class<P> plugin) {
        return (P)((Plugin)this.plugins.get(plugin));
    }

    public List<PluginModel> getModelPlugins() {
        return this.modelModifiers;
    }

    public void modifyServiceDocument(ServiceRequest request, Map<String, Object> result) {
        for (PluginRootDocument plugin : this.serviceDocModifiers) {
            plugin.modifyServiceDocument(request, result);
        }
    }

    public PluginService getServiceForRequestType(Version version, String requestType) {
        Map<String, PluginService> types = this.requestTypeHandlers.get(version);
        if (types == null) {
            return null;
        }
        return types.get(requestType);
    }

    public PluginService getServiceForPath(Version version, String path) {
        Map<String, PluginService> paths = this.pathHandlers.get(version);
        if (paths == null) {
            return null;
        }
        PluginService service = paths.get(path);
        if (service == null) {
            return paths.get(PATH_WILDCARD);
        }
        return service;
    }

    public ResultFormatter getFormatter(Version version, String formatName) {
        Map<String, PluginResultFormat> formatters = this.resultFormattersByFormat.get(version);
        if (formatters == null) {
            return null;
        }
        PluginResultFormat plugin = formatters.get(formatName.toLowerCase());
        if (plugin == null) {
            return null;
        }
        return plugin.getResultFormatter(formatName);
    }

    public void parsedQuery(CoreSettings settings, ServiceRequest request, Query query) {
        List<PluginResultFormat> formatters = this.resultFormatters.get(query.getVersion());
        for (PluginResultFormat formatter : formatters) {
            formatter.parsedPathAndQuery(settings, request, query);
        }
    }

    public Version getVersion(String versionString) {
        return this.versions.get(versionString);
    }

    public Map<String, Version> getVersions() {
        return this.versions;
    }

    public static String decodeRequestType(PluginService plugin, Version version, String path, String method, String contentType) throws IllegalArgumentException {
        return PluginManager.decodeRequestType(plugin, version, path, HttpMethod.fromString(method), contentType);
    }

    public static String decodeRequestType(PluginService plugin, Version version, String path, HttpMethod method, String contentType) throws IllegalArgumentException {
        String requestType = plugin.getRequestTypeFor(version, path, method, contentType);
        if (requestType == null) {
            String cleanedPath = StringHelper.cleanForLogging(path);
            LOGGER.error("Unhandled request; Method {}, path {}", (Object)method, (Object)cleanedPath);
            throw new IllegalArgumentException("Unhandled request; Method " + method + ", path " + cleanedPath);
        }
        return requestType;
    }
}

