/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.query.expression.function.logical;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.path.ParserContext;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.property.PropertyReference;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Expression;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.ExpressionVisitor;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Path;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.BooleanConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.Function;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.FunctionTypeBinding;
import java.util.Objects;

public class Any
extends Function {
    private Path collection;
    private String lambdaName;

    public Any() {
    }

    public Any(Path collection, String lambdaName) {
        this.collection = collection;
        this.lambdaName = lambdaName;
    }

    public Any(Path collection, String lambdaName, Expression filter) {
        super(filter);
        this.collection = collection;
        this.lambdaName = lambdaName;
    }

    @Override
    protected void initAllowedTypeBindings() {
        this.allowedTypeBindings.add(new FunctionTypeBinding(BooleanConstant.class, BooleanConstant.class));
    }

    @Override
    public <O> O accept(ExpressionVisitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void validate(ParserContext parentContext, EntityType type) {
        ParserContext context = new ParserContext(parentContext);
        this.collection.validate(context, type);
        Property lastElement = this.collection.lastElement();
        if (!(lastElement instanceof NavigationPropertyMain.NavigationPropertyEntitySet)) {
            throw new IllegalArgumentException("Any can only be used on an EntitySet, " + lastElement + " is not an EntitySet.");
        }
        NavigationPropertyMain.NavigationPropertyEntitySet npes = (NavigationPropertyMain.NavigationPropertyEntitySet)lastElement;
        EntityType anyType = npes.getEntityType();
        context.registerVariable(this.lambdaName, new PropertyReference(this.lambdaName, npes));
        super.validate(context, anyType);
    }

    public String getLambdaName() {
        return this.lambdaName;
    }

    public void setCollection(Path collection) {
        this.collection = collection;
    }

    public Path getCollection() {
        return this.collection;
    }

    @Override
    public String toUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.collection.toUrl());
        sb.append("/any(");
        sb.append(this.lambdaName);
        sb.append(':');
        boolean first = true;
        for (Expression p : this.parameters) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(p.toUrl());
        }
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toUrl();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Any other = (Any)obj;
        if (!Objects.equals(this.lambdaName, other.lambdaName)) {
            return false;
        }
        if (!Objects.equals(this.collection, other.collection)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + Objects.hashCode(this.collection);
        hash = 23 * hash + Objects.hashCode(this.lambdaName);
        return 23 * hash + super.hashCode();
    }
}

