/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.query.expression.function;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.path.ParserContext;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.DynamicContext;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Expression;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.BooleanConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.Constant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.DateConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.DateTimeConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.DoubleConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.DurationConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.IntegerConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.LineStringConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.PointConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.PolygonConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.StringConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.FunctionTypeBinding;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Function
implements Expression {
    private static final Logger LOGGER = LoggerFactory.getLogger(Function.class);
    protected List<Expression> parameters = new ArrayList<Expression>();
    protected List<FunctionTypeBinding> allowedTypeBindings;
    private final String functionName;
    private DynamicContext context;

    protected Function() {
        this.allowedTypeBindings = new ArrayList<FunctionTypeBinding>();
        this.functionName = this.getClass().getSimpleName().toLowerCase();
    }

    protected Function(Expression ... parameters) {
        this.parameters.addAll(Arrays.asList(parameters));
        this.allowedTypeBindings = new ArrayList<FunctionTypeBinding>();
        this.functionName = this.getClass().getSimpleName().toLowerCase();
    }

    protected Function(String functionName) {
        this.functionName = functionName;
        this.allowedTypeBindings = new ArrayList<FunctionTypeBinding>();
    }

    protected Function(String functionName, Expression ... parameters) {
        this.functionName = functionName;
        this.parameters = Arrays.asList(parameters);
        this.allowedTypeBindings = new ArrayList<FunctionTypeBinding>();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public String toUrl() {
        StringBuilder sb = new StringBuilder(this.getFunctionName());
        sb.append("(");
        boolean first = true;
        for (Expression p : this.parameters) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(p.toUrl());
        }
        sb.append(")");
        return sb.toString();
    }

    public void setParameters(List<Expression> parameters) {
        this.parameters = parameters;
    }

    public void setParameters(Expression ... parameters) {
        this.parameters = Arrays.asList(parameters);
    }

    @Override
    public void addParameter(Expression parameter) {
        this.parameters.add(parameter);
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public DynamicContext getContext() {
        return this.context;
    }

    public Function setContext(DynamicContext context) {
        this.context = context;
        return this;
    }

    @Override
    public final Expression compress() {
        return this.eval(this.parameters.stream().map(Expression::compress).toList());
    }

    @Override
    public void validate(ParserContext context, EntityType type) {
        for (Expression p : this.parameters) {
            p.validate(context, type);
        }
    }

    private Expression eval(List<Expression> parameters) {
        try {
            Method method = this.findMethod(parameters);
            if (method != null) {
                return (Expression)method.invoke((Object)this, parameters.toArray());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
            LOGGER.info("Could not eval.", ex);
        }
        return this;
    }

    private Method findMethod(List<Expression> parameters) {
        Method[] methods = this.getClass().getDeclaredMethods();
        ArrayList<Method> suitableMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (!method.getName().equals("eval") || parameters.size() != method.getParameterCount()) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            boolean assignable = true;
            for (int i = 0; i < parameters.size(); ++i) {
                if (parameterTypes[i].isAssignableFrom(parameters.get(i).getClass())) continue;
                assignable = false;
                break;
            }
            if (!assignable) continue;
            suitableMethods.add(method);
        }
        if (!suitableMethods.isEmpty()) {
            return (Method)suitableMethods.get(0);
        }
        return null;
    }

    protected abstract void initAllowedTypeBindings();

    public List<FunctionTypeBinding> getAllowedTypeBindings() {
        if (this.allowedTypeBindings == null || this.allowedTypeBindings.isEmpty()) {
            this.initAllowedTypeBindings();
        }
        return this.allowedTypeBindings;
    }

    public int hashCode() {
        return Objects.hash(this.parameters, this.allowedTypeBindings);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Function other = (Function)obj;
        return Objects.equals(this.parameters, other.parameters) && Objects.equals(this.getAllowedTypeBindings(), other.getAllowedTypeBindings());
    }

    protected static List<FunctionTypeBinding> getTypeBindingForAllTypes() {
        ArrayList<FunctionTypeBinding> result = new ArrayList<FunctionTypeBinding>();
        result.add(new FunctionTypeBinding(BooleanConstant.class, BooleanConstant.class, BooleanConstant.class));
        result.add(new FunctionTypeBinding(DateConstant.class, DateConstant.class, DateConstant.class));
        result.add(new FunctionTypeBinding(DateTimeConstant.class, DateTimeConstant.class, DateTimeConstant.class));
        result.add(new FunctionTypeBinding(DoubleConstant.class, DoubleConstant.class, DoubleConstant.class));
        result.add(new FunctionTypeBinding(DurationConstant.class, DurationConstant.class, DurationConstant.class));
        result.add(new FunctionTypeBinding(IntegerConstant.class, IntegerConstant.class, IntegerConstant.class));
        result.add(new FunctionTypeBinding(LineStringConstant.class, LineStringConstant.class, LineStringConstant.class));
        result.add(new FunctionTypeBinding(PointConstant.class, PointConstant.class, PointConstant.class));
        result.add(new FunctionTypeBinding(PolygonConstant.class, PolygonConstant.class, PolygonConstant.class));
        result.add(new FunctionTypeBinding(StringConstant.class, StringConstant.class, StringConstant.class));
        result.add(new FunctionTypeBinding(IntegerConstant.class, IntegerConstant.class, IntegerConstant.class));
        return result;
    }

    protected static List<FunctionTypeBinding> getTypeBindingForAllTypesWithReturnType(Class<? extends Constant> returnType) {
        ArrayList<FunctionTypeBinding> result = new ArrayList<FunctionTypeBinding>();
        result.add(new FunctionTypeBinding(BooleanConstant.class, BooleanConstant.class, returnType));
        result.add(new FunctionTypeBinding(DateConstant.class, DateConstant.class, returnType));
        result.add(new FunctionTypeBinding(DateTimeConstant.class, DateTimeConstant.class, returnType));
        result.add(new FunctionTypeBinding(DoubleConstant.class, DoubleConstant.class, returnType));
        result.add(new FunctionTypeBinding(DurationConstant.class, DurationConstant.class, returnType));
        result.add(new FunctionTypeBinding(IntegerConstant.class, IntegerConstant.class, returnType));
        result.add(new FunctionTypeBinding(LineStringConstant.class, LineStringConstant.class, returnType));
        result.add(new FunctionTypeBinding(PointConstant.class, PointConstant.class, returnType));
        result.add(new FunctionTypeBinding(PolygonConstant.class, PolygonConstant.class, returnType));
        result.add(new FunctionTypeBinding(StringConstant.class, StringConstant.class, returnType));
        result.add(new FunctionTypeBinding(IntegerConstant.class, IntegerConstant.class, returnType));
        return result;
    }
}

