/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.query.expression.constant;

import de.fraunhofer.iosb.ilt.frostserver.query.expression.ExpressionVisitor;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.Constant;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.text.ParseException;
import net.time4j.PlainTime;
import net.time4j.format.expert.Iso8601Format;

public class TimeConstant
extends Constant<PlainTime> {
    public TimeConstant(PlainTime value) {
        super(value);
    }

    public TimeConstant(String value) throws ParseException {
        super(Iso8601Format.EXTENDED_WALL_TIME.parse(value));
    }

    @Override
    public String toUrl() {
        return ((PlainTime)this.getValue()).toString();
    }

    @Override
    public <O> O accept(ExpressionVisitor<O> visitor) {
        return visitor.visit(this);
    }

    public static TimeConstant parse(String value) {
        try {
            return new TimeConstant(value);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Failed to parse PlainTime " + StringHelper.cleanForLogging(value), ex);
        }
    }
}

