/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.query.expression.constant;

import de.fraunhofer.iosb.ilt.frostserver.query.expression.ExpressionVisitor;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.Constant;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.text.ParseException;
import net.time4j.range.MomentInterval;

public class IntervalConstant
extends Constant<MomentInterval> {
    public IntervalConstant(MomentInterval value) {
        super(value);
    }

    public IntervalConstant(String value) throws ParseException {
        super(MomentInterval.parseISO(value));
    }

    @Override
    public String toUrl() {
        return StringHelper.FORMAT_INTERVAL.print((MomentInterval)this.getValue());
    }

    @Override
    public <O> O accept(ExpressionVisitor<O> visitor) {
        return visitor.visit(this);
    }

    public static IntervalConstant parse(String value) {
        try {
            return new IntervalConstant(value);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Failed to parse MomentInterval " + StringHelper.cleanForLogging(value), ex);
        }
    }
}

