/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.query.expression.constant;

import de.fraunhofer.iosb.ilt.frostserver.query.expression.ExpressionVisitor;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.Constant;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.text.ParseException;
import net.time4j.Duration;

public class DurationConstant
extends Constant<Duration> {
    public DurationConstant(Duration value) {
        super(value);
    }

    public DurationConstant(String value) throws ParseException {
        super(Duration.parsePeriod(value));
    }

    @Override
    public String toUrl() {
        return "duration'" + ((Duration)this.getValue()).toString() + "'";
    }

    public String asISO8601() {
        return ((Duration)this.getValue()).toStringISO();
    }

    @Override
    public <O> O accept(ExpressionVisitor<O> visitor) {
        return visitor.visit(this);
    }

    public static DurationConstant parse(String value) {
        try {
            return new DurationConstant(value);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Failed to parse Duration " + StringHelper.cleanForLogging(value), ex);
        }
    }
}

