/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.query.expression.constant;

import de.fraunhofer.iosb.ilt.frostserver.query.expression.ExpressionVisitor;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.Constant;
import net.time4j.PlainDate;
import net.time4j.format.expert.Iso8601Format;

public class DateConstant
extends Constant<PlainDate> {
    public DateConstant(PlainDate value) {
        super(value);
    }

    public DateConstant(String value) {
        if (value.lastIndexOf(45) <= 0) {
            throw new IllegalArgumentException("Not a date: " + value);
        }
        this.value = PlainDate.parse(value, Iso8601Format.EXTENDED_CALENDAR_DATE);
    }

    @Override
    public String toUrl() {
        return ((PlainDate)this.getValue()).toString();
    }

    @Override
    public <O> O accept(ExpressionVisitor<O> visitor) {
        return visitor.visit(this);
    }

    public static DateConstant parse(String value) {
        return new DateConstant(value);
    }
}

