/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.query.expression.constant;

import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeObject;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.BooleanConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.Constant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.DoubleConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.IntegerConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.StringConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.TimeObjectConstant;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConstantFactory.class.getName());

    private ConstantFactory() {
    }

    public static Constant of(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Constant) {
            Constant c = (Constant)object;
            return c;
        }
        if (object instanceof BigDecimal) {
            return new StringConstant(Objects.toString(object));
        }
        if (object instanceof Boolean) {
            Boolean aBoolean = (Boolean)object;
            return new BooleanConstant(aBoolean);
        }
        if (object instanceof Double) {
            Double aDouble = (Double)object;
            return new DoubleConstant(aDouble);
        }
        if (object instanceof Integer) {
            Integer integer = (Integer)object;
            return new IntegerConstant(integer);
        }
        if (object instanceof Long) {
            Long aLong = (Long)object;
            return new IntegerConstant(aLong);
        }
        if (object instanceof String) {
            String string = (String)object;
            return new StringConstant(string);
        }
        if (object instanceof UUID) {
            UUID uuid = (UUID)object;
            return new StringConstant(uuid.toString());
        }
        if (object instanceof TimeObject) {
            TimeObject timeObject = (TimeObject)object;
            return new TimeObjectConstant(timeObject);
        }
        LOGGER.warn("Can not make constant of {}", (Object)object.getClass());
        return null;
    }
}

